/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModSingleDatabaseRoot;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmRoot;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbmSingleDatabaseRoot<S extends DbmSchema>
extends DbmRoot<S>
implements BasicModSingleDatabaseRoot {
    protected final Family<S> mySchemas;
    @Nullable
    private S myCurrentSchema;

    public DbmSingleDatabaseRoot(@NotNull DbmModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/common/DbmSingleDatabaseRoot", "<init>"));
        }
        super(model);
        this.mySchemas = Family.of(this, ObjectKind.SCHEMA);
        this.assignFamilies(this.mySchemas);
    }

    @Override
    @NotNull
    public Family<S> getSchemas() {
        Family<S> family = this.mySchemas;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSingleDatabaseRoot", "getSchemas"));
        }
        return family;
    }

    @Override
    @NotNull
    public Family<S> getNamespaces() {
        Family<S> family = this.mySchemas;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSingleDatabaseRoot", "getNamespaces"));
        }
        return family;
    }

    @Override
    @NotNull
    public Iterable<S> getAllSchemas() {
        Family<S> family = this.mySchemas;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSingleDatabaseRoot", "getAllSchemas"));
        }
        return family;
    }

    @Override
    @Nullable
    public DbmSchema findSchema(String name) {
        return (DbmSchema)((Family)this.getSchemas()).get(name);
    }

    @Nullable
    public S getCurrentSchema() {
        return this.myCurrentSchema;
    }

    @Override
    @Nullable
    public S getCurrentNamespace() {
        return this.getCurrentSchema();
    }

    public void setCurrentSchema(@Nullable DbmSchema currentSchema) {
        if (this.myCurrentSchema == currentSchema) {
            return;
        }
        this.modifying();
        assert (currentSchema == null || this.mySchemas.contains(currentSchema));
        this.myCurrentSchema = currentSchema;
    }

    @Override
    public void setCurrentNamespace(@Nullable DbmNamespace currentNamespace) {
        if (currentNamespace == null || currentNamespace instanceof DbmSchema) {
            this.setCurrentSchema((DbmSchema)currentNamespace);
        }
    }
}

