/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmRef;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbmUtil {
    static final Logger LOG = Logger.getInstance((String)"com.intellij.dbm.DatabaseModel");
    public static final Function<DbmRef.ResolvedRef<?, ?>, Object> REF_SOURCE = ref -> ref.source;
    public static final Function<DbmRef.ResolvedRef<?, ?>, Object> REF_TARGET = ref -> ref.target;
    private static final JBTreeTraverser<DbmObject> DBM_TRAVERSER = new JBTreeTraverser(o -> Iterables.concat(o.getFamilies()));

    public static <R extends DbmObject> Function<DbmRef.ResolvedRef<?, ?>, DbmRef.ResolvedRef<? extends R, ? extends DbmObject>> CAST_REF_SOURCE(Class<R> clazz) {
        return ref -> clazz.isInstance(ref.source) ? ref : null;
    }

    public static <T extends DbmObject> Function<DbmRef.ResolvedRef<?, ?>, DbmRef.ResolvedRef<? extends DbmObject, ? extends T>> CAST_REF_TARGET(Class<T> clazz) {
        return ref -> clazz.isInstance(ref.target) ? ref : null;
    }

    public static String[] branch(@NotNull DbmObject object1, @NotNull DbmObject object2, boolean useSurrogateNames) {
        if (object1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object1", "com/intellij/dbm/common/DbmUtil", "branch"));
        }
        if (object2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object2", "com/intellij/dbm/common/DbmUtil", "branch"));
        }
        LinkedList<String> list = new LinkedList<String>();
        DbmObject object = object2;
        while (object != object1) {
            list.add(0, object.identity(useSurrogateNames));
            if ((object = object.getDbParent()) != null) continue;
            throw new IllegalArgumentException("The object2 must be a (sub)child of the object1");
        }
        list.add(0, object1.identity(useSurrogateNames));
        return ArrayUtil.toStringArray(list);
    }

    public static String[] fullPath(@NotNull DbmObject object, boolean useSurrogateNames) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DbmUtil", "fullPath"));
        }
        LinkedList<String> list = new LinkedList<String>();
        for (DbmObject obj = object; obj != null; obj = obj.getDbParent()) {
            list.add(0, obj.identity(useSurrogateNames));
        }
        return ArrayUtil.toStringArray(list);
    }

    private static String pluralize(String noun) {
        if (noun.equals("index")) {
            return "indices";
        }
        return StringUtil.pluralize((String)noun);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static <T> List<T> freezeList(List<T> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        switch (n) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (list instanceof ImmutableList) {
            return list;
        }
        return ImmutableList.copyOf(list);
    }

    public static JBTreeTraverser<DbmObject> dbmTraverser() {
        return DBM_TRAVERSER;
    }

    @Contract(value="null->null", pure=true)
    public static DbmObject getModelObjectOf(@Nullable DasObject dasObject) {
        Object x = dasObject;
        while (x != null) {
            if (x instanceof DbmObject) {
                return (DbmObject)x;
            }
            if (x instanceof DbElement) {
                x = ((DbElement)x).getDelegate();
                continue;
            }
            return null;
        }
        return null;
    }

    @Contract(value="!null->!null; null->null")
    public static String humanizeEnumName(String enumName) {
        return enumName != null ? enumName.toLowerCase(Locale.ROOT).replace('_', ' ') : null;
    }
}

