/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DeltaItem;
import com.intellij.dbm.common.DeltaObject;
import com.intellij.dbm.common.Family;
import com.intellij.openapi.util.Couple;
import com.intellij.util.CollectionUtils;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModelComparison {
    private static final ImmutableList<DeltaItem> NO_ITEMS_DIFFERENCE = ImmutableList.of();
    private static final ImmutableList<DeltaObject> NO_CHILDREN_DIFFERENCE = ImmutableList.of();

    public static <T extends DbmObject> DeltaObject compare(@NotNull T objectA, @NotNull T objectB) {
        if (objectA == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectA", "com/intellij/dbm/common/ModelComparison", "compare"));
        }
        if (objectB == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectB", "com/intellij/dbm/common/ModelComparison", "compare"));
        }
        if (objectA.getKind() != objectB.getKind()) {
            throw new IllegalArgumentException("Cannot compare objects of different kinds: " + objectA.getKind() + " and " + objectB.getKind());
        }
        ImmutableList<DeltaItem> comparedItems = ModelComparison.compareItems(objectA, objectB);
        ImmutableList<DeltaObject> comparedChildren = ModelComparison.compareChildren(objectA, objectB);
        return new DeltaObject(objectA, objectB, comparedItems, comparedChildren);
    }

    @NotNull
    static ImmutableList<DeltaItem> compareItems(@NotNull DbmObject objectA, @NotNull DbmObject objectB) {
        String name;
        if (objectA == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectA", "com/intellij/dbm/common/ModelComparison", "compareItems"));
        }
        if (objectB == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectB", "com/intellij/dbm/common/ModelComparison", "compareItems"));
        }
        ImmutableMap<String, Object> stateA = objectA.getState(false);
        ImmutableMap<String, Object> stateB = objectB.getState(false);
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map.Entry entry : stateA.entrySet()) {
            name = (String)entry.getKey();
            if (stateB.containsKey((Object)name)) continue;
            result.add((Object)new DeltaItem(name, entry.getValue(), null));
        }
        for (Map.Entry entry : stateA.entrySet()) {
            Object valueB;
            Object valueA;
            name = (String)entry.getKey();
            if (!stateB.containsKey((Object)name) || ModelComparison.eq(valueA = entry.getValue(), valueB = stateB.get((Object)name))) continue;
            result.add((Object)new DeltaItem(name, valueA, valueB));
        }
        for (Map.Entry entry : stateB.entrySet()) {
            name = (String)entry.getKey();
            if (stateA.containsKey((Object)name)) continue;
            result.add((Object)new DeltaItem(name, null, entry.getValue()));
        }
        ImmutableList immutableList = result.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/ModelComparison", "compareItems"));
        }
        return immutableList;
    }

    static ImmutableList<DeltaObject> compareChildren(final @NotNull DbmObject objectA, @NotNull DbmObject objectB) {
        if (objectA == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectA", "com/intellij/dbm/common/ModelComparison", "compareChildren"));
        }
        if (objectB == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectB", "com/intellij/dbm/common/ModelComparison", "compareChildren"));
        }
        ImmutableSortedMap families = CollectionUtils.sortingMerge(objectA.getFamilies(), objectB.getFamilies(), new Function<Family<?>, Comparable>(){

            public Comparable<1C> apply(Family<?> family) {
                class C
                implements Comparable<C> {
                    final ObjectKind kind;
                    final /* synthetic */ DbmObject val$objectA;

                    C(ObjectKind objectKind) {
                        this.val$objectA = objectKind;
                        this.kind = kind;
                    }

                    @Override
                    public int compareTo(C o) {
                        return this.val$objectA.model.metaModel.compare(this.kind, o.kind);
                    }
                }
                return new C(family.getChildKind(), objectA);
            }
        });
        ImmutableList.Builder result = ImmutableList.builder();
        for (Couple f : families.values()) {
            ImmutableList childrenA = ((Family)f.first).asList();
            ImmutableList childrenB = ((Family)f.second).asList();
            ImmutableSortedMap<Comparable, Couple<DbmObject>> children = CollectionUtils.sortingMerge(childrenA, childrenB, new Function<DbmObject, Comparable>(){

                public String apply(DbmObject object) {
                    return object.identity();
                }
            });
            for (Couple twins : children.values()) {
                DeltaObject innerDelta;
                DbmObject twinA = (DbmObject)twins.first;
                DbmObject twinB = (DbmObject)twins.second;
                if (twinA != null && twinB != null) {
                    innerDelta = ModelComparison.compare(twinA, twinB);
                    if (innerDelta.areEqual()) continue;
                    result.add((Object)innerDelta);
                    continue;
                }
                innerDelta = new DeltaObject(twinA, twinB, NO_ITEMS_DIFFERENCE, NO_CHILDREN_DIFFERENCE);
                result.add((Object)innerDelta);
            }
        }
        return result.build();
    }

    private static boolean eq(@Nullable Object objectA, @Nullable Object objectB) {
        if (objectA == objectB) {
            return true;
        }
        if (objectA == null || objectB == null) {
            return false;
        }
        return objectA.equals(objectB);
    }
}

