/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.dbm.common.BaseIntrospector;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmMultiDatabaseModel;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.LongIdName;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;

public abstract class MultiDatabaseIntrospector<DB extends DbmDatabase, S extends DbmSchema, M extends DbmMultiDatabaseModel<DB, S>>
extends BaseIntrospector<S, M> {
    public MultiDatabaseIntrospector(@NotNull DBFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/dbm/common/MultiDatabaseIntrospector", "<init>"));
        }
        super(facade);
    }

    @Override
    protected void introspectNamespaces(@NotNull DBTransaction tran) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/MultiDatabaseIntrospector", "introspectNamespaces"));
        }
        List<LongIdName> dbs = this.listDatabases(tran);
        this.applyDatabases(dbs);
    }

    protected void applyDatabases(final @NotNull List<LongIdName> dbs) {
        if (dbs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbs", "com/intellij/dbm/common/MultiDatabaseIntrospector", "applyDatabases"));
        }
        this.withModel(new BaseIntrospector.SimpleModelWorker<M>(){

            @Override
            public void working(M model) {
                Family databases = ((DbmMultiDatabaseModel)model).databases();
                databases.markChildrenAsSyncPending();
                boolean empty = databases.isEmpty();
                boolean first = true;
                for (LongIdName db : dbs) {
                    DbmDatabase database = (DbmDatabase)databases.renew(db.id, db.name);
                    if (!first) continue;
                    first = false;
                    ((DbmMultiDatabaseModel)model).setCurrentDatabase(database);
                    if (!empty) continue;
                    database.setVisible(true);
                }
                databases.removeSyncPendingChildren();
            }
        });
    }

    @Override
    protected void introspectAuto(@NotNull DBTransaction tran, DbmNamespace[] namespaces) {
        JBIterable schemasToIntrospect;
        JBIterable databasesToIntrospect;
        boolean explicit;
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/MultiDatabaseIntrospector", "introspectAuto"));
        }
        DbmMultiDatabaseModel model = (DbmMultiDatabaseModel)this.getModel();
        boolean bl = explicit = namespaces != null && namespaces.length > 0;
        if (explicit) {
            databasesToIntrospect = JBIterable.of((Object[])namespaces).filter(DbmDatabase.class).transform(db -> db);
        } else {
            this.introspectNamespaces(tran);
            databasesToIntrospect = model.databases().iterable().filter(DbmNamespace::isVisible);
        }
        this.introspectDatabases(tran, databasesToIntrospect);
        if (explicit) {
            JBIterable schemasExplicit = JBIterable.of((Object[])namespaces).filter(DbmSchema.class).transform(s -> s);
            JBIterable schemasFromDatabases = databasesToIntrospect.transform(DbmDatabase::getSchemas).flatten(x -> x).filter(DbmNamespace::isVisible).transform(s -> s);
            schemasToIntrospect = schemasExplicit.append((Iterable)schemasFromDatabases);
        } else {
            schemasToIntrospect = databasesToIntrospect.transform(DbmDatabase::getSchemas).flatten(x -> x).filter(DbmNamespace::isVisible).transform(s -> s);
        }
        this.introspectSchemas(tran, schemasToIntrospect);
    }

    protected void introspectDatabases(@NotNull DBTransaction tran, @NotNull JBIterable<DB> databasesToIntrospect) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/MultiDatabaseIntrospector", "introspectDatabases"));
        }
        if (databasesToIntrospect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databasesToIntrospect", "com/intellij/dbm/common/MultiDatabaseIntrospector", "introspectDatabases"));
        }
        for (DbmDatabase database : databasesToIntrospect) {
            DatabaseRetriever retriever = this.createDatabaseRetriever(tran, database);
            retriever.process();
        }
    }

    protected void introspectSchemas(@NotNull DBTransaction tran, @NotNull JBIterable<S> schemasToIntrospect) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/MultiDatabaseIntrospector", "introspectSchemas"));
        }
        if (schemasToIntrospect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemasToIntrospect", "com/intellij/dbm/common/MultiDatabaseIntrospector", "introspectSchemas"));
        }
        ArrayList<BaseIntrospector.SchemaRetriever> retrievers = new ArrayList<BaseIntrospector.SchemaRetriever>(schemasToIntrospect.size());
        for (DbmSchema schema : schemasToIntrospect) {
            retrievers.add(this.createSchemaRetriever(tran, schema));
        }
        for (BaseIntrospector.SchemaRetriever retriever : retrievers) {
            retriever.processPreliminaryPhase();
        }
        for (BaseIntrospector.SchemaRetriever retriever : retrievers) {
            retriever.processMainPhase();
        }
    }

    @NotNull
    protected abstract DatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction var1, @NotNull DB var2);

    @NotNull
    protected abstract BaseIntrospector.SchemaRetriever createSchemaRetriever(@NotNull DBTransaction var1, @NotNull S var2);

    protected abstract List<LongIdName> listDatabases(@NotNull DBTransaction var1);

    protected void retrieveSessionBriefInfo(DBTransaction tran) {
    }

    protected static abstract class DatabaseRetriever
    extends BaseIntrospector.DatabaseRetriever {
        protected final DB database;
        final /* synthetic */ MultiDatabaseIntrospector this$0;

        public DatabaseRetriever(@NotNull DBTransaction transaction, @NotNull M model, DB database) {
            if (transaction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/intellij/dbm/common/MultiDatabaseIntrospector$DatabaseRetriever", "<init>"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/common/MultiDatabaseIntrospector$DatabaseRetriever", "<init>"));
            }
            if (database == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/MultiDatabaseIntrospector$DatabaseRetriever", "<init>"));
            }
            this.this$0 = this$0;
            super((BaseIntrospector)this$0, transaction, model);
            this.database = database;
            this.prepareParameters();
        }

        protected abstract void prepareParameters();

        @Override
        public void process() {
            this.retrieveSchemas();
        }

        private void retrieveSchemas() {
            List<LongIdName> scs = this.listSchemas();
            this.applySchemas(scs);
        }

        protected abstract List<LongIdName> listSchemas();

        private void applySchemas(final @NotNull List<LongIdName> scs) {
            if (scs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scs", "com/intellij/dbm/common/MultiDatabaseIntrospector$DatabaseRetriever", "applySchemas"));
            }
            this.withModel(new BaseIntrospector.SimpleModelWorker<M>(){

                @Override
                public void working(M model) {
                    ModNamingFamily schemas = ((DbmDatabase)DatabaseRetriever.this.database).getSchemas();
                    boolean empty = ((Family)schemas).isEmpty();
                    boolean first = true;
                    ((Family)schemas).markChildrenAsSyncPending();
                    for (LongIdName sc : scs) {
                        DbmSchema schema = (DbmSchema)((Family)schemas).renew(sc.id, sc.name);
                        if (!first) continue;
                        first = false;
                        ((DbmDatabase)DatabaseRetriever.this.database).setCurrentSchema(schema);
                        if (!empty) continue;
                        schema.setVisible(true);
                    }
                    ((Family)schemas).removeSyncPendingChildren();
                }
            });
        }
    }
}

