/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.Contract;

public abstract class Naming {
    private static final Set<Character> symbolsToEscapeOnExport = ImmutableSet.of((Object)Character.valueOf('.'), (Object)Character.valueOf(','), (Object)Character.valueOf('|'), (Object)Character.valueOf('~'), (Object)Character.valueOf(':'), (Object)Character.valueOf(';'), (Object[])new Character[]{Character.valueOf('('), Character.valueOf(')'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('\\')});

    @Contract(value="!null->!null;null->null", pure=true)
    public static String exportName(String name) {
        if (name == null) {
            return null;
        }
        int n = name.length();
        StringBuilder b = new StringBuilder(n * 2);
        for (int i = 0; i < n; ++i) {
            char c = name.charAt(i);
            if (c <= ' ' || symbolsToEscapeOnExport.contains(Character.valueOf(c))) {
                int h;
                b.append('\\').append('u');
                String hex = Integer.toHexString(c).toUpperCase(Locale.ROOT);
                for (int j = h = hex.length(); j < 4; ++j) {
                    b.append(0);
                }
                b.append(hex);
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    @Contract(value="!null->!null;null->null", pure=true)
    public static String importName(String escapedName) {
        if (escapedName == null) {
            return null;
        }
        return StringUtil.replaceUnicodeEscapeSequences((String)escapedName.trim());
    }
}

