/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmRef;
import com.intellij.dbm.common.DbmUtil;
import com.intellij.dbm.common.PropertyHolder;
import com.intellij.dbm.common.ReferenceHolder;
import com.intellij.dbm.common.RelativeReference;
import com.intellij.dbm.common.Resolver;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectsRef<R extends DbmObject, T extends DbmObject>
implements ReferenceHolder<R>,
PropertyHolder {
    @NotNull
    private final R myOwner;

    public ObjectsRef(@NotNull R owner, @NotNull Class<T> aClass) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/dbm/common/ObjectsRef", "<init>"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/dbm/common/ObjectsRef", "<init>"));
        }
        this.myOwner = owner;
    }

    public <TT extends T> DbmRef<TT> add(@NotNull TT target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/dbm/common/ObjectsRef", "add"));
        }
        DbmRef<TT> ref = DbmRef.ref(this, target);
        ConcurrentMap map = (ConcurrentMap)ConcurrencyUtil.cacheOrGet(((DbmObject)this.myOwner).model.objectsRefs, (Object)this, (Object)ContainerUtil.newConcurrentMap());
        DbmRef<TT> prev = map.putIfAbsent(ref, ref);
        return prev == null ? ref : prev;
    }

    public List<DbmRef<? extends T>> getAllRefs() {
        ConcurrentMap map = (ConcurrentMap)((DbmObject)this.myOwner).model.objectsRefs.get(this);
        if (map == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.newArrayList(map.keySet());
    }

    public <TT extends T> Set<TT> getTargetObjects(@NotNull Class<TT> targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/dbm/common/ObjectsRef", "getTargetObjects"));
        }
        ConcurrentMap map = (ConcurrentMap)((DbmObject)this.myOwner).model.objectsRefs.get(this);
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        THashSet result = new THashSet(map.size());
        for (DbmRef ref : map.keySet()) {
            Object targetObject = ref.getResolvedObject();
            if (targetObject == null || !targetClass.isAssignableFrom(targetObject.getClass())) continue;
            result.add(targetObject);
        }
        return result;
    }

    @Override
    @NotNull
    public R getOwner() {
        R r = this.myOwner;
        if (r == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/ObjectsRef", "getOwner"));
        }
        return r;
    }

    @Override
    public void referenceDropped(@NotNull DbmRef.ResolvedRef<? extends DbmObject, ? extends DbmObject> ref) {
        ConcurrentMap map;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/dbm/common/ObjectsRef", "referenceDropped"));
        }
        ConcurrentMap concurrentMap = map = ref.source == this.myOwner ? (ConcurrentMap)((DbmObject)this.myOwner).model.objectsRefs.get(this) : null;
        if (map != null) {
            map.remove(ref);
        }
    }

    @Override
    public String exportState() {
        List<DbmRef<T>> refs = this.getAllRefs();
        if (refs.isEmpty()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (DbmRef<T> r : refs) {
            RelativeReference p = r.getRelativeReference();
            if (p == null) continue;
            String s = p.toString();
            b.append(s).append('\n');
        }
        return b.toString();
    }

    @Override
    public void importState(String text) {
        String[] strings;
        if (text == null) {
            return;
        }
        Resolver<DbmObject> resolver = this.getResolver();
        if (resolver == null) {
            DbmUtil.LOG.warn(this.toString() + ": cannot import state while no resolver.");
            return;
        }
        for (String string : strings = StringUtil.splitByLines((String)text, (boolean)true)) {
            assert (string != null);
            this.importRef(string, resolver);
        }
    }

    void importRef(@NotNull String refString) {
        if (refString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refString", "com/intellij/dbm/common/ObjectsRef", "importRef"));
        }
        String str = refString.trim();
        if (str.length() == 0) {
            return;
        }
        Resolver<DbmObject> resolver = this.getResolver();
        if (resolver == null) {
            DbmUtil.LOG.warn(this.toString() + ": cannot import a reference while no resolver.");
            return;
        }
        this.importRef(refString, resolver);
    }

    private void importRef(@NotNull String refString, @NotNull Resolver<? extends DbmObject> resolver) {
        if (refString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refString", "com/intellij/dbm/common/ObjectsRef", "importRef"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/dbm/common/ObjectsRef", "importRef"));
        }
        String str = refString.trim();
        if (str.length() == 0) {
            return;
        }
        RelativeReference p = RelativeReference.of(refString);
        DbmObject target = resolver.resolve(p);
        if (target == null) {
            DbmUtil.LOG.warn(String.format("The reference of %s to \"%s\" is not resolved.", ((DbmObject)this.myOwner).toString(), refString));
            return;
        }
        Class<?> targetClass = target.getClass();
        if (!DbmObject.class.isAssignableFrom(targetClass)) {
            DbmUtil.LOG.warn(String.format("The reference of %s to \"%s\" is resolved but to an unexpected class %s (when expected %s).", ((DbmObject)this.myOwner).toString(), refString, targetClass, DbmObject.class.getName()));
            return;
        }
        this.add(target);
    }

    @Nullable
    private Resolver<? extends DbmObject> getResolver() {
        return ((DbmObject)this.myOwner).generalResolver();
    }

    @Override
    public void clearState() {
        List<DbmRef<T>> refs = this.getAllRefs();
        ((DbmObject)this.myOwner).model.objectsRefs.remove(this);
        for (DbmRef<T> ref : refs) {
            try {
                ref.drop();
            }
            catch (Exception e) {
                DbmUtil.LOG.warn("Failed to drop reference (" + ref.toString() + "): " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public String toString() {
        return ((DbmObject)this.myOwner).toString() + "-->ObjectsRef";
    }
}

