/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.factories;

import com.intellij.database.introspection.DBIntrospector;
import com.intellij.dbm.common.DBScriptingService;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.factories.RdbmsDefinition;
import com.intellij.dbm.factories.RdbmsRegistry;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.DBFacade;

public class RdbmsServiceFactory {
    private static final RdbmsServiceFactory ourInstance = new RdbmsServiceFactory(RdbmsRegistry.instance());
    private final RdbmsRegistry myRegistry;

    @NotNull
    public static RdbmsServiceFactory instance() {
        RdbmsServiceFactory rdbmsServiceFactory = ourInstance;
        if (rdbmsServiceFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/factories/RdbmsServiceFactory", "instance"));
        }
        return rdbmsServiceFactory;
    }

    private RdbmsServiceFactory(RdbmsRegistry registry) {
        this.myRegistry = registry;
    }

    @NotNull
    public DbmModel createModel(@NotNull Rdbms rdbms) {
        DbmModel dbmModel;
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/dbm/factories/RdbmsServiceFactory", "createModel"));
        }
        RdbmsDefinition definition = this.myRegistry.getDefinitionByRdbms(rdbms);
        try {
            dbmModel = definition.modelClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create Model for RDBMS " + rdbms + ": " + e.getMessage(), e);
        }
        if (dbmModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/factories/RdbmsServiceFactory", "createModel"));
        }
        return dbmModel;
    }

    @NotNull
    public DBIntrospector createIntrospector(@NotNull DBFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/dbm/factories/RdbmsServiceFactory", "createIntrospector"));
        }
        RdbmsDefinition definition = this.myRegistry.getDefinitionByRdbms(facade.rdbms());
        DBIntrospector dBIntrospector = this.createIntrospector(facade, definition.introspectorClass);
        if (dBIntrospector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/factories/RdbmsServiceFactory", "createIntrospector"));
        }
        return dBIntrospector;
    }

    @NotNull
    public DBIntrospector createIntrospector(@NotNull DBFacade facade, @NotNull Class<? extends DBIntrospector> clazz) {
        DBIntrospector dBIntrospector;
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/dbm/factories/RdbmsServiceFactory", "createIntrospector"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/dbm/factories/RdbmsServiceFactory", "createIntrospector"));
        }
        try {
            DBIntrospector introspector;
            Constructor<? extends DBIntrospector> constructor = clazz.getConstructor(DBFacade.class);
            if (constructor == null) {
                throw new IllegalStateException("Constructor for " + clazz.getSimpleName() + " is not found");
            }
            dBIntrospector = introspector = constructor.newInstance(facade);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create Introspector for RDBMS " + facade.rdbms() + ": " + e.getMessage(), e);
        }
        if (dBIntrospector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/factories/RdbmsServiceFactory", "createIntrospector"));
        }
        return dBIntrospector;
    }

    @NotNull
    public DBScriptingService createScriptingService(@NotNull Rdbms rdbms) {
        DBScriptingService dBScriptingService;
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/dbm/factories/RdbmsServiceFactory", "createScriptingService"));
        }
        try {
            dBScriptingService = this.myRegistry.getDefinitionByRdbms((Rdbms)rdbms).myScriptingClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create scripting service for RDBMS " + rdbms + ": " + e.getMessage(), e);
        }
        if (dBScriptingService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/factories/RdbmsServiceFactory", "createScriptingService"));
        }
        return dBScriptingService;
    }
}

