/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.generic.meta;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.JdbcUtil;
import com.intellij.dbm.generic.meta.ClosableIt;
import com.intellij.dbm.generic.meta.MetaDataUtil;
import com.intellij.dbm.generic.meta.RoutineArgumentIt;
import com.intellij.dbm.generic.meta.RoutineIt;
import com.intellij.dbm.generic.meta.SchemaLoader;
import com.intellij.dbm.generic.meta.SybaseRoutineArgumentIt;
import com.intellij.dbm.generic.meta.SybaseRoutineIt;
import com.intellij.dbm.generic.meta.TableColumnIt;
import com.intellij.dbm.generic.meta.TableFKeyColumnIt;
import com.intellij.dbm.generic.meta.TableIndexColumnIt;
import com.intellij.dbm.generic.meta.TableIt;
import com.intellij.dbm.generic.meta.TableKeyColumnIt;
import com.intellij.dbm.generic.meta.TableVersionColumnIt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseMetaDataWrapper {
    private static final Logger LOG = Logger.getInstance(DatabaseMetaDataWrapper.class);
    private final Connection myConnection;
    private final DatabaseMetaData myMetaData;
    private final DatabaseFamilyId myFamilyId;
    private final ErrorHandler myErrorHandler;
    private String myQuote;

    @NotNull
    private Pair<Set<String>, String> getCatalogsToLoad() throws SQLException {
        String currentCatalog = this.myConnection.getCatalog();
        OpenTHashSet catalogs = new OpenTHashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        try (ClosableIt<String> it = SchemaLoader.catalogs(this);){
            it.filter(Conditions.notNull());
            JBIterable.once(it).addAllTo((Collection)catalogs);
            if (currentCatalog != null && catalogs.contains((Object)currentCatalog)) {
                currentCatalog = (String)catalogs.get(catalogs.index((Object)currentCatalog));
            }
        }
        catch (SQLException ignored) {
            ContainerUtil.addIfNotNull((Collection)catalogs, (Object)currentCatalog);
        }
        Pair pair = Pair.create((Object)catalogs, (Object)currentCatalog);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getCatalogsToLoad"));
        }
        return pair;
    }

    @NotNull
    public TreeSet<Schema> listSchemasToLoad(@Nullable PairProcessor<String, String> schemaFilter) throws SQLException {
        TreeSet<Schema> treeSet;
        Pair<Set<String>, String> pair = this.getCatalogsToLoad();
        Set catalogs = (Set)pair.first;
        String currentCatalog = (String)pair.second;
        LOG.debug("loading list schemas from " + StringUtil.join((Collection)catalogs, (String)", "));
        try (ClosableIt<Schema> it = SchemaLoader.schemas(catalogs, currentCatalog, this);){
            TreeSet<Schema> result = new TreeSet<Schema>((s1, s2) -> {
                int res = Comparing.compare((Comparable)((Object)s1.database), (Comparable)((Object)s2.database));
                if (res != 0) {
                    return res;
                }
                return Comparing.compare((Comparable)((Object)s1.schema), (Comparable)((Object)s2.schema));
            });
            for (Schema s : JBIterable.once(it)) {
                if (schemaFilter != null && !schemaFilter.process((Object)s.database, (Object)s.schema)) continue;
                result.add(s);
            }
            TreeSet<Schema> treeSet2 = result;
            treeSet = treeSet2;
        }
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "listSchemasToLoad"));
        }
        return treeSet;
    }

    static String quoteIfNeeded(@Nullable String name, @NotNull DataSource dataSource, @Nullable DatabaseDialect dialect) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "quoteIfNeeded"));
        }
        if (dialect != null) {
            return dialect.quoteIdentifier(name, false, false);
        }
        return dataSource.quoteIdentifierIfNeeded(name);
    }

    public Connection getConnection() {
        return this.myConnection;
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = this.myFamilyId;
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getFamilyId"));
        }
        return databaseFamilyId;
    }

    @NotNull
    public static DatabaseMetaDataWrapper create(@NotNull Connection connection, @NotNull DatabaseMetaData data, @NotNull ErrorHandler handler, @NotNull DatabaseFamilyId familyId) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "create"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "create"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "create"));
        }
        if (familyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyId", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "create"));
        }
        if (familyId.isSybase()) {
            SybaseMetadataWrapper sybaseMetadataWrapper = new SybaseMetadataWrapper(connection, data, handler, familyId);
            if (sybaseMetadataWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "create"));
            }
            return sybaseMetadataWrapper;
        }
        if (familyId.isPostgres()) {
            PostgresMetadataWrapper postgresMetadataWrapper = new PostgresMetadataWrapper(connection, data, handler, familyId);
            if (postgresMetadataWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "create"));
            }
            return postgresMetadataWrapper;
        }
        if (familyId.isOracle()) {
            OracleMetadataWrapper oracleMetadataWrapper = new OracleMetadataWrapper(connection, data, handler, familyId);
            if (oracleMetadataWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "create"));
            }
            return oracleMetadataWrapper;
        }
        DatabaseMetaDataWrapper databaseMetaDataWrapper = new DatabaseMetaDataWrapper(connection, data, handler, familyId);
        if (databaseMetaDataWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "create"));
        }
        return databaseMetaDataWrapper;
    }

    protected DatabaseMetaDataWrapper(@NotNull Connection connection, @NotNull DatabaseMetaData data, @NotNull ErrorHandler handler, @NotNull DatabaseFamilyId familyId) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "<init>"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "<init>"));
        }
        if (familyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyId", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "<init>"));
        }
        this.myConnection = connection;
        this.myMetaData = data;
        this.myErrorHandler = handler;
        this.myFamilyId = familyId;
    }

    @NotNull
    public ClosableIt<Schema> schemas(boolean all) throws SQLException {
        ClosableIt.DelegateIt<Schema, Schema> delegateIt = new ClosableIt.DelegateIt<Schema, Schema>(this.listSchemasToLoad(null).iterator()){

            @Override
            protected Schema calcValue(Schema cur) {
                return cur;
            }
        };
        if (delegateIt == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "schemas"));
        }
        return delegateIt;
    }

    @NotNull
    public ClosableIt<? extends Table> tables(@NotNull Schema schema, @Nullable String namePattern, @NotNull String[] types) throws SQLException {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "tables"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "tables"));
        }
        ClosableIt<? extends Table> tableIt = this.tablesInner(schema, namePattern, types);
        tableIt.filter(tab -> tab.type == null || !StringUtil.containsIgnoreCase((String)tab.type, (String)"TEMPORARY"));
        ClosableIt<? extends Table> closableIt = tableIt;
        if (closableIt == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "tables"));
        }
        return closableIt;
    }

    @NotNull
    public ClosableIt<Routine> routines(@NotNull Schema schema, @Nullable String pkg, @Nullable String namePattern) throws SQLException {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "routines"));
        }
        boolean noCatalog = StringUtil.isEmpty((String)this.myMetaData.getCatalogTerm());
        String requestCatalog = noCatalog ? pkg : StringUtil.notNullize((String)schema.database);
        ClosableIt<Routine> closableIt = this.append(this.getProceduresInner(requestCatalog, schema, namePattern, noCatalog), () -> {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "lambda$routines$2"));
            }
            return this.getFunctionsInner(requestCatalog, schema, namePattern, noCatalog);
        });
        if (closableIt == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "routines"));
        }
        return closableIt;
    }

    @NotNull
    private RoutineIt getProceduresInner(String requestCatalog, @NotNull Schema schema, @Nullable String namePattern, boolean noCatalog) throws SQLException {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getProceduresInner"));
        }
        RoutineIt routineIt = new RoutineIt(this.myMetaData.getProcedures(requestCatalog, schema.schema, namePattern), this.myErrorHandler, this.myFamilyId, schema, noCatalog, true);
        if (routineIt == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getProceduresInner"));
        }
        return routineIt;
    }

    @Nullable
    private RoutineIt getFunctionsInner(String requestCatalog, @NotNull Schema schema, @Nullable String namePattern, boolean noCatalog) throws SQLException {
        ResultSet rs;
        block5: {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getFunctionsInner"));
            }
            rs = null;
            try {
                rs = this.myMetaData.getFunctions(requestCatalog, schema.schema, namePattern);
            }
            catch (AbstractMethodError abstractMethodError) {
            }
            catch (SQLException e) {
                if (DatabaseMetaDataWrapper.isUnimplemented(e)) break block5;
                throw e;
            }
        }
        if (rs == null) {
            return null;
        }
        return new RoutineIt(rs, this.myErrorHandler, this.myFamilyId, schema, noCatalog, false);
    }

    protected <T> ClosableIt<T> append(ClosableIt<T> head, ThrowableComputable<ClosableIt<T>, SQLException> ... tail) {
        ClosableIt<T> res = head;
        for (ThrowableComputable<ClosableIt<T>, SQLException> fac : tail) {
            if (fac == null) continue;
            res = ClosableIt.lazyAppend(res, this.handleExceptions(fac));
        }
        return res;
    }

    private <T> Factory<T> handleExceptions(ThrowableComputable<T, SQLException> fac) {
        return () -> {
            try {
                return fac.compute();
            }
            catch (SQLException e) {
                this.myErrorHandler.addError(null, (Throwable)e);
                return null;
            }
        };
    }

    @NotNull
    public ClosableIt.GroupingIt<TableKey, TableKeyColumn> tableKeys(@NotNull Table table) throws SQLException {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "tableKeys"));
        }
        TableKeyColumnIt.Grouping grouping = new TableKeyColumnIt.Grouping(new TableKeyColumnIt(this.myMetaData.getPrimaryKeys(table.schema.database, table.schema.schema, table.name), this.myErrorHandler, table));
        if (grouping == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "tableKeys"));
        }
        return grouping;
    }

    @NotNull
    public ClosableIt.GroupingIt<Table, TableColumn> tableColumns(@NotNull Schema schema, @Nullable String namePattern, @Nullable Iterable<String> expectedTables) throws SQLException {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "tableColumns"));
        }
        TableColumnIt.Grouping grouping = new TableColumnIt.Grouping(this.getTableColumnsInner(schema, namePattern, expectedTables));
        if (grouping == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "tableColumns"));
        }
        return grouping;
    }

    @NotNull
    protected ClosableIt<TableColumn> getTableColumnsInner(final @NotNull Schema schema, @Nullable String namePattern, final @Nullable Iterable<String> expectedTables) throws SQLException {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getTableColumnsInner"));
        }
        if (namePattern != null || expectedTables == null) {
            assert (expectedTables == null);
            ClosableIt<TableColumn> closableIt = this.getTableColumnsInner2(schema, namePattern);
            if (closableIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getTableColumnsInner"));
            }
            return closableIt;
        }
        ClosableIt<TableColumn> it = null;
        try {
            it = this.getTableColumnsInner2(schema, null);
        }
        catch (SQLException e) {
            LOG.debug((Throwable)e);
        }
        ClosableIt.LazyAppendableClosableIt<TableColumn> lazyAppendableClosableIt = new ClosableIt.LazyAppendableClosableIt<TableColumn>(it){
            private Iterator<String> myTableIt;
            private String myCurrentTable;
            private boolean myExpectedMode;
            {
                super(init);
                this.myTableIt = expectedTables.iterator();
                this.myCurrentTable = null;
            }

            protected void currentChanged() {
                if (this.myTableIt != null && !this.myExpectedMode) {
                    String name;
                    TableColumn current = (TableColumn)this.current();
                    String string = name = current == null ? null : current.table.name;
                    if (!Comparing.equal((String)this.myCurrentTable, (String)name)) {
                        if (this.myCurrentTable == null) {
                            this.myCurrentTable = name;
                        } else {
                            this.myTableIt = null;
                            this.myCurrentTable = null;
                        }
                    }
                }
            }

            @Override
            @Nullable
            protected ClosableIt<? extends TableColumn> nextIt() {
                if (this.myTableIt != null) {
                    this.myExpectedMode = true;
                    while (this.myTableIt.hasNext()) {
                        String table = this.myTableIt.next();
                        if (Comparing.equal((String)table, (String)this.myCurrentTable)) continue;
                        try {
                            return DatabaseMetaDataWrapper.this.getTableColumnsInner2(schema, table);
                        }
                        catch (SQLException e) {
                            DatabaseMetaDataWrapper.this.myErrorHandler.addError("failed to retrieve columns for " + table, (Throwable)e);
                        }
                    }
                }
                return null;
            }
        };
        if (lazyAppendableClosableIt == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getTableColumnsInner"));
        }
        return lazyAppendableClosableIt;
    }

    @NotNull
    private ClosableIt<TableColumn> getTableColumnsInner2(@NotNull Schema schema, @Nullable String namePattern) throws SQLException {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getTableColumnsInner2"));
        }
        TableColumnIt tableColumnIt = new TableColumnIt(this.myMetaData.getColumns(StringUtil.notNullize((String)schema.database), schema.schema, StringUtil.notNullize((String)namePattern, (String)"%"), "%"), this.myErrorHandler, this.myFamilyId, schema);
        if (tableColumnIt == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getTableColumnsInner2"));
        }
        return tableColumnIt;
    }

    @NotNull
    public ClosableIt.GroupingIt<Routine, RoutineArgument> routineArguments(@NotNull Schema schema, @Nullable String namePattern, @NotNull Function<Routine, DasRoutine.Kind> kindProvider) throws SQLException {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "routineArguments"));
        }
        if (kindProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kindProvider", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "routineArguments"));
        }
        RoutineArgumentIt.Grouping grouping = new RoutineArgumentIt.Grouping(this.routineArgumentsInner(schema, namePattern, kindProvider));
        if (grouping == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "routineArguments"));
        }
        return grouping;
    }

    @NotNull
    public ClosableIt<RoutineArgument> routineArgumentsInner(@NotNull Schema schema, @Nullable String namePattern, @NotNull Function<Routine, DasRoutine.Kind> kindProvider) throws SQLException {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "routineArgumentsInner"));
        }
        if (kindProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kindProvider", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "routineArgumentsInner"));
        }
        boolean noCatalog = StringUtil.isEmpty((String)this.myMetaData.getCatalogTerm());
        String requestCatalog = noCatalog ? schema.database : StringUtil.notNullize((String)schema.database);
        ClosableIt<RoutineArgument> closableIt = this.append(this.getProcedureArgumentsInner(requestCatalog, schema, namePattern, kindProvider, noCatalog), () -> {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "lambda$routineArgumentsInner$4"));
            }
            if (kindProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kindProvider", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "lambda$routineArgumentsInner$4"));
            }
            return this.getFunctionArgumentsInner(requestCatalog, schema, namePattern, kindProvider, noCatalog);
        });
        if (closableIt == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "routineArgumentsInner"));
        }
        return closableIt;
    }

    @NotNull
    private ClosableIt<RoutineArgument> getProcedureArgumentsInner(String requestCatalog, @NotNull Schema schema, @Nullable String namePattern, @NotNull Function<Routine, DasRoutine.Kind> kindProvider, boolean noCatalog) throws SQLException {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getProcedureArgumentsInner"));
        }
        if (kindProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kindProvider", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getProcedureArgumentsInner"));
        }
        ResultSet wrapper = this.getRoutineArgumentsWrapper(new Schema(schema.schema, requestCatalog), namePattern);
        if (wrapper == null) {
            ClosableIt<RoutineArgument> closableIt = ClosableIt.empty();
            if (closableIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getProcedureArgumentsInner"));
            }
            return closableIt;
        }
        RoutineArgumentIt routineArgumentIt = new RoutineArgumentIt(wrapper, this.myErrorHandler, this.myFamilyId, schema, noCatalog, kindProvider, true);
        if (routineArgumentIt == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getProcedureArgumentsInner"));
        }
        return routineArgumentIt;
    }

    @Nullable
    private ClosableIt<RoutineArgument> getFunctionArgumentsInner(String requestCatalog, @NotNull Schema schema, @Nullable String namePattern, @NotNull Function<Routine, DasRoutine.Kind> kindProvider, boolean noCatalog) throws SQLException {
        ResultSet rs;
        block6: {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getFunctionArgumentsInner"));
            }
            if (kindProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kindProvider", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getFunctionArgumentsInner"));
            }
            rs = null;
            try {
                rs = this.myMetaData.getFunctionColumns(requestCatalog, schema.schema, namePattern, null);
            }
            catch (AbstractMethodError abstractMethodError) {
            }
            catch (SQLException e) {
                if (DatabaseMetaDataWrapper.isUnimplemented(e)) break block6;
                throw e;
            }
        }
        if (rs == null) {
            return null;
        }
        return new RoutineArgumentIt(rs, this.myErrorHandler, this.myFamilyId, schema, noCatalog, kindProvider, false);
    }

    private static boolean isUnimplemented(SQLException e) {
        String message = e.getMessage();
        return message != null && (message.contains("implemented") || message.contains("not supported"));
    }

    @NotNull
    public ClosableIt.GroupingIt<TableFKey, TableFKeyColumn> tableFKeyColumns(@NotNull Table table) throws SQLException {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "tableFKeyColumns"));
        }
        TableFKeyColumnIt.Grouping grouping = new TableFKeyColumnIt.Grouping(new TableFKeyColumnIt(this.myMetaData.getImportedKeys(table.schema.database, table.schema.schema, table.name), this.myErrorHandler, table));
        if (grouping == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "tableFKeyColumns"));
        }
        return grouping;
    }

    @NotNull
    public ClosableIt.GroupingIt<TableIndex, TableIndexColumn> tableIndexColumns(@NotNull Table table) throws SQLException {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "tableIndexColumns"));
        }
        TableIndexColumnIt.Grouping grouping = new TableIndexColumnIt.Grouping(new TableIndexColumnIt(this.getTableIndexColumnsWrapper(table), this.myErrorHandler, table));
        if (grouping == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "tableIndexColumns"));
        }
        return grouping;
    }

    @NotNull
    public ClosableIt<TableColumn> tableVersionColumns(@NotNull Table table) throws SQLException {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "tableVersionColumns"));
        }
        TableVersionColumnIt tableVersionColumnIt = new TableVersionColumnIt(this.myMetaData.getVersionColumns(table.schema.database, table.schema.schema, table.name), this.myErrorHandler, table);
        if (tableVersionColumnIt == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "tableVersionColumns"));
        }
        return tableVersionColumnIt;
    }

    @Nullable
    private ResultSet getRoutineArgumentsWrapper(@NotNull Schema schema, @Nullable String namePattern) throws SQLException {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getRoutineArgumentsWrapper"));
        }
        try {
            return this.myMetaData.getProcedureColumns(schema.database, schema.schema, StringUtil.notNullize((String)namePattern, (String)"%"), null);
        }
        catch (NullPointerException e) {
            if (this.myFamilyId.isSqlite()) {
                LOG.debug((Throwable)e);
                return null;
            }
            throw e;
        }
        catch (SQLException e) {
            return this.myMetaData.getProcedureColumns(schema.database, schema.schema, "%", null);
        }
    }

    private ResultSet getTableIndexColumnsWrapper(@NotNull Table table) throws SQLException {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getTableIndexColumnsWrapper"));
        }
        try {
            return this.myMetaData.getIndexInfo(table.schema.database, table.schema.schema, table.name, false, true);
        }
        catch (SQLException ex) {
            try {
                String q = this.getQuote();
                return this.myMetaData.getIndexInfo(q + table.schema.database + q, q + table.schema.schema + q, q + table.name + q, false, true);
            }
            catch (SQLException ex2) {
                throw ex;
            }
        }
    }

    public String getQuote() {
        if (this.myQuote == null) {
            try {
                this.myQuote = this.myMetaData.getIdentifierQuoteString();
            }
            catch (SQLException e) {
                this.myQuote = "\"";
                this.myErrorHandler.addError(null, (Throwable)e);
            }
        }
        return this.myQuote;
    }

    public String[] getAllTableTypes() throws SQLException {
        HashSet tableTypes = ContainerUtil.newHashSet();
        for (String type : JdbcUtil.resultSetToListSafe((ResultSet)this.myMetaData.getTableTypes(), (String)"TABLE_TYPE", (ErrorHandler)this.myErrorHandler)) {
            tableTypes.add(StringUtil.notNullize((String)type).trim());
        }
        return tableTypes.isEmpty() ? null : ArrayUtil.toStringArray((Collection)tableTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected ClosableIt<? extends Table> tablesInner(@NotNull Schema schema, @Nullable String namePattern, @Nullable String[] types) throws SQLException {
        boolean hasNext;
        MetaDataUtil.ResultSetWrapper rs;
        block10: {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "tablesInner"));
            }
            rs = null;
            try {
                try {
                    rs = MetaDataUtil.ResultSetWrapper.wrap(this.myMetaData.getTables(schema.database, schema.schema, StringUtil.notNullize((String)namePattern, (String)"%"), types));
                    hasNext = rs.next();
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                    ClosableIt closableIt = types == null ? ClosableIt.empty() : this.tablesInner(schema, namePattern, null);
                    MetaDataUtil.ResultSetWrapper.close(rs);
                    ClosableIt closableIt2 = closableIt;
                    if (closableIt2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "tablesInner"));
                    }
                    return closableIt2;
                }
            }
            catch (Throwable throwable) {
                MetaDataUtil.ResultSetWrapper.close(rs);
                throw throwable;
            }
            if (hasNext || types == null || types.length == 1) break block10;
            ClosableIt<? extends Table> e = this.tablesInner(schema, namePattern, null);
            MetaDataUtil.ResultSetWrapper.close(rs);
            ClosableIt<? extends Table> closableIt = e;
            if (closableIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "tablesInner"));
            }
            return closableIt;
        }
        TableIt it = new TableIt(rs, this.myErrorHandler, hasNext, schema);
        rs = null;
        TableIt tableIt = it;
        MetaDataUtil.ResultSetWrapper.close(rs);
        TableIt tableIt2 = tableIt;
        if (tableIt2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "tablesInner"));
        }
        return tableIt2;
    }

    @NotNull
    public ErrorHandler getErrorHandler() {
        ErrorHandler errorHandler = this.myErrorHandler;
        if (errorHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getErrorHandler"));
        }
        return errorHandler;
    }

    @NotNull
    public DatabaseMetaData getMetaData() {
        DatabaseMetaData databaseMetaData = this.myMetaData;
        if (databaseMetaData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getMetaData"));
        }
        return databaseMetaData;
    }

    @Nullable
    public Casing getCasing() {
        try {
            return DatabaseMetaDataWrapper.getCasing(this.myFamilyId, this.myMetaData);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static Casing getCasing(@NotNull DatabaseFamilyId familyId, @NotNull DatabaseMetaData metaData) throws SQLException {
        if (familyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyId", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getCasing"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getCasing"));
        }
        boolean supportsMixedCase = metaData.supportsMixedCaseIdentifiers();
        boolean storesUpperCase = metaData.storesUpperCaseIdentifiers();
        boolean storesLowerCase = metaData.storesLowerCaseIdentifiers();
        boolean storesMixedCase = metaData.storesMixedCaseIdentifiers();
        boolean supportsMixedCaseQuoted = metaData.supportsMixedCaseQuotedIdentifiers();
        boolean storesUpperCaseQuoted = metaData.storesUpperCaseQuotedIdentifiers();
        boolean storesLowerCaseQuoted = metaData.storesLowerCaseQuotedIdentifiers();
        boolean storesMixedCaseQuoted = metaData.storesMixedCaseQuotedIdentifiers();
        Case plain = DatabaseMetaDataWrapper.getCaseMode(familyId, supportsMixedCase, storesLowerCase, storesUpperCase, storesMixedCase);
        Case quoted = DatabaseMetaDataWrapper.getCaseMode(familyId, supportsMixedCaseQuoted, storesLowerCaseQuoted, storesUpperCaseQuoted, storesMixedCaseQuoted);
        return Casing.create((Case)plain, (Case)quoted);
    }

    private static Case getCaseMode(@NotNull DatabaseFamilyId familyId, boolean sensitive, boolean forceLower, boolean forceUpper, boolean asIs) {
        if (familyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyId", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper", "getCaseMode"));
        }
        if (sensitive && asIs) {
            return familyId.isSqlite() || familyId.isMicrosoft() ? Case.MIXED : Case.EXACT;
        }
        return asIs && familyId.isSybase() || sensitive ? Case.EXACT : (forceLower ? Case.LOWER : (forceUpper ? Case.UPPER : Case.MIXED));
    }

    private static class OracleMetadataWrapper
    extends DatabaseMetaDataWrapper {
        public static final List<String> BAD_PREFIXES = Arrays.asList("BIN$", "CREATE$", "JAVA$", "DR$", "XDB$", "DRV$", "RUPD$", "MLOG$");

        protected OracleMetadataWrapper(@NotNull Connection connection, @NotNull DatabaseMetaData data, @NotNull ErrorHandler handler, @NotNull DatabaseFamilyId familyId) {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$OracleMetadataWrapper", "<init>"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$OracleMetadataWrapper", "<init>"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$OracleMetadataWrapper", "<init>"));
            }
            if (familyId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyId", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$OracleMetadataWrapper", "<init>"));
            }
            super(connection, data, handler, familyId);
        }

        @Override
        @NotNull
        public ClosableIt<? extends Table> tables(@NotNull Schema schema, @Nullable String namePattern, @NotNull String[] types) throws SQLException {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$OracleMetadataWrapper", "tables"));
            }
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$OracleMetadataWrapper", "tables"));
            }
            ClosableIt<? extends Table> tableIt = super.tables(schema, namePattern, types);
            tableIt.filter(OracleMetadataWrapper::isValidTable);
            ClosableIt<? extends Table> closableIt = tableIt;
            if (closableIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$OracleMetadataWrapper", "tables"));
            }
            return closableIt;
        }

        @Override
        @NotNull
        public ClosableIt<Routine> routines(@NotNull Schema schema, @Nullable String pkg, @Nullable String namePattern) throws SQLException {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$OracleMetadataWrapper", "routines"));
            }
            ClosableIt<Routine> routineIt = super.routines(schema, pkg, namePattern);
            routineIt.filter(OracleMetadataWrapper::isValidRoutine);
            ClosableIt<Routine> closableIt = routineIt;
            if (closableIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$OracleMetadataWrapper", "routines"));
            }
            return closableIt;
        }

        private static boolean startsWithBadPrefix(@Nullable String s) {
            if (s != null) {
                for (String prefix : BAD_PREFIXES) {
                    if (!StringUtil.startsWithIgnoreCase((String)s, (String)prefix)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isSys(@NotNull Schema schema) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$OracleMetadataWrapper", "isSys"));
            }
            return Comparing.equal((String)"sys", (String)schema.schema, (boolean)false) || Comparing.equal((String)"sys", (String)schema.schema, (boolean)true);
        }

        private static boolean isValidSysName(@Nullable String s) {
            return s == null || !s.contains("$");
        }

        private static boolean isValidRoutine(@NotNull Routine routine) {
            if (routine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$OracleMetadataWrapper", "isValidRoutine"));
            }
            if (OracleMetadataWrapper.isSys(routine.schema)) {
                return OracleMetadataWrapper.isValidSysName(routine.pkg) && OracleMetadataWrapper.isValidSysName(routine.name);
            }
            return !OracleMetadataWrapper.startsWithBadPrefix(routine.pkg) && !OracleMetadataWrapper.startsWithBadPrefix(routine.name);
        }

        private static boolean isValidTable(@NotNull Table table) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$OracleMetadataWrapper", "isValidTable"));
            }
            if (OracleMetadataWrapper.isSys(table.schema)) {
                return OracleMetadataWrapper.isValidSysName(table.name);
            }
            return !OracleMetadataWrapper.startsWithBadPrefix(table.name);
        }
    }

    private static class SybaseMetadataWrapper
    extends DatabaseMetaDataWrapper {
        public SybaseMetadataWrapper(@NotNull Connection connection, @NotNull DatabaseMetaData data, @NotNull ErrorHandler handler, @NotNull DatabaseFamilyId familyId) {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$SybaseMetadataWrapper", "<init>"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$SybaseMetadataWrapper", "<init>"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$SybaseMetadataWrapper", "<init>"));
            }
            if (familyId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyId", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$SybaseMetadataWrapper", "<init>"));
            }
            super(connection, data, handler, familyId);
        }

        @Override
        @NotNull
        public ClosableIt<? extends Table> tables(@NotNull Schema schema, @Nullable String namePattern, @NotNull String[] types) throws SQLException {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$SybaseMetadataWrapper", "tables"));
            }
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$SybaseMetadataWrapper", "tables"));
            }
            ClosableIt<? extends Table> tableIt = super.tables(schema, namePattern, types);
            tableIt.filter(tab -> SybaseRoutineIt.isSybTableName(tab.name, tab.type));
            ClosableIt<? extends Table> closableIt = tableIt;
            if (closableIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$SybaseMetadataWrapper", "tables"));
            }
            return closableIt;
        }

        @Override
        @NotNull
        public ClosableIt<Routine> routines(@NotNull Schema schema, @Nullable String pkg, @Nullable String namePattern) throws SQLException {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$SybaseMetadataWrapper", "routines"));
            }
            ClosableIt<Routine> routineIt = super.routines(schema, pkg, namePattern);
            ClosableIt<Routine> closableIt = this.append(routineIt, () -> {
                if (schema == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$SybaseMetadataWrapper", "lambda$routines$1"));
                }
                return this.sybaseTableRoutines(schema, namePattern);
            });
            if (closableIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$SybaseMetadataWrapper", "routines"));
            }
            return closableIt;
        }

        @Override
        @NotNull
        public ClosableIt<RoutineArgument> routineArgumentsInner(@NotNull Schema schema, @Nullable String namePattern, @NotNull Function<Routine, DasRoutine.Kind> kindProvider) throws SQLException {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$SybaseMetadataWrapper", "routineArgumentsInner"));
            }
            if (kindProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kindProvider", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$SybaseMetadataWrapper", "routineArgumentsInner"));
            }
            ClosableIt<RoutineArgument> argumentIt = super.routineArgumentsInner(schema, namePattern, kindProvider);
            ClosableIt<RoutineArgument> closableIt = this.append(argumentIt, () -> {
                if (schema == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$SybaseMetadataWrapper", "lambda$routineArgumentsInner$2"));
                }
                return this.sybaseRoutineArguments(schema, namePattern);
            });
            if (closableIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$SybaseMetadataWrapper", "routineArgumentsInner"));
            }
            return closableIt;
        }

        @Nullable
        private ClosableIt<Routine> sybaseTableRoutines(@NotNull Schema schema, @Nullable String namePattern) throws SQLException {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$SybaseMetadataWrapper", "sybaseTableRoutines"));
            }
            ClosableIt<? extends Table> tables = this.tablesInner(schema, namePattern, new String[]{"SYSTEM TABLE"});
            tables.filter(tab -> !SybaseRoutineIt.isSybTableName(tab.name, tab.type));
            return new SybaseRoutineIt(schema, (Iterator<? extends Table>)((Object)tables));
        }

        @Nullable
        private ClosableIt<RoutineArgument> sybaseRoutineArguments(@NotNull Schema schema, @Nullable String namePattern) throws SQLException {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$SybaseMetadataWrapper", "sybaseRoutineArguments"));
            }
            return new SybaseRoutineArgumentIt(schema, (Iterator<? extends TableColumn>)((Object)this.getTableColumnsInner(schema, namePattern, null)));
        }
    }

    private static class PostgresMetadataWrapper
    extends DatabaseMetaDataWrapper {
        public PostgresMetadataWrapper(@NotNull Connection connection, @NotNull DatabaseMetaData data, @NotNull ErrorHandler handler, @NotNull DatabaseFamilyId familyId) {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$PostgresMetadataWrapper", "<init>"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$PostgresMetadataWrapper", "<init>"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$PostgresMetadataWrapper", "<init>"));
            }
            if (familyId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyId", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$PostgresMetadataWrapper", "<init>"));
            }
            super(connection, data, handler, familyId);
        }

        @Override
        @NotNull
        public ClosableIt<? extends Table> tables(@NotNull Schema schema, @Nullable String namePattern, @NotNull String[] types) throws SQLException {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$PostgresMetadataWrapper", "tables"));
            }
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$PostgresMetadataWrapper", "tables"));
            }
            ClosableIt<? extends Table> tableIt = super.tables(schema, namePattern, types);
            tableIt.filter(tab -> !"INDEX".equals(tab.type));
            ClosableIt<? extends Table> closableIt = tableIt;
            if (closableIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$PostgresMetadataWrapper", "tables"));
            }
            return closableIt;
        }
    }

    public static class RoutineArgument
    extends Assignable<RoutineArgument> {
        public final Routine routine;
        @Nullable
        public String name;
        public int type;
        @Nullable
        public String typeName;
        @Nullable
        public String comment;
        public int length;
        public int scale;
        public boolean nullable;
        @Nullable
        public String def;
        public int position;
        public DasArgument.Direction direction;

        public RoutineArgument(@NotNull Routine routine) {
            if (routine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$RoutineArgument", "<init>"));
            }
            this.routine = routine;
        }
    }

    public static class Routine
    extends Assignable<Routine> {
        public final Schema schema;
        @Nullable
        public String pkg;
        @NotNull
        public String name;
        @NotNull
        public String specificName;
        @Nullable
        public String comment;
        @NotNull
        public DasRoutine.Kind kind;

        public Routine(@NotNull Schema schema, @Nullable String pkg, @NotNull String name) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$Routine", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$Routine", "<init>"));
            }
            this.name = "";
            this.specificName = "";
            this.kind = DasRoutine.Kind.NONE;
            this.schema = schema;
            this.pkg = pkg;
            this.name = name;
        }
    }

    public static class TableIndexColumn
    extends Assignable<TableIndexColumn> {
        public final TableIndex index;
        @Nullable
        public String name;
        public short position;
        public DasIndex.Sorting sorting;

        public TableIndexColumn(@NotNull TableIndex index) {
            if (index == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$TableIndexColumn", "<init>"));
            }
            this.index = index;
        }
    }

    public static class TableFKeyColumn
    extends Assignable<TableFKeyColumn> {
        public final TableFKey fk;
        @Nullable
        public String name;
        @Nullable
        public String targetName;
        public short position;

        public TableFKeyColumn(@NotNull TableFKey fk) {
            if (fk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fk", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$TableFKeyColumn", "<init>"));
            }
            this.fk = fk;
        }
    }

    public static class TableKeyColumn
    extends Assignable<TableKeyColumn> {
        public final TableKey key;
        @Nullable
        public String name;
        public short position;

        public TableKeyColumn(@NotNull TableKey key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$TableKeyColumn", "<init>"));
            }
            this.key = key;
        }
    }

    public static class TableIndex
    extends Assignable<TableIndex> {
        public final Table table;
        @Nullable
        public String name;
        public boolean nonUnique;
        @Nullable
        public String qualifier;
        public short type;

        public TableIndex(@NotNull Table table, @Nullable String name) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$TableIndex", "<init>"));
            }
            this.table = table;
            this.name = name;
        }
    }

    public static class TableFKey
    extends Assignable<TableFKey> {
        public final Table table;
        public final Table targetTable;
        @Nullable
        public String name;
        public boolean surrogateName;
        public short updateRule;
        public short deleteRule;
        public short deferrability;

        public TableFKey(@NotNull Table table, @NotNull Table targetTable, @Nullable String name) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$TableFKey", "<init>"));
            }
            if (targetTable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetTable", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$TableFKey", "<init>"));
            }
            this.table = table;
            this.targetTable = targetTable;
            this.name = name;
        }
    }

    public static class TableKey
    extends Assignable<TableKey> {
        public final Table table;
        @Nullable
        public String name;
        public boolean primary;

        public TableKey(@NotNull Table table, @Nullable String name) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$TableKey", "<init>"));
            }
            this.table = table;
            this.name = name;
        }
    }

    public static class TableColumn
    extends Assignable<TableColumn> {
        public final Table table;
        @Nullable
        public String name;
        public int type;
        @Nullable
        public String typeName;
        @Nullable
        public String comment;
        public int length;
        public int scale;
        public boolean nullable;
        @Nullable
        public String def;
        public int position;
        public boolean autoIncrement;

        public TableColumn(@NotNull Table table) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$TableColumn", "<init>"));
            }
            this.table = table;
        }
    }

    public static class Table
    extends Assignable<Table> {
        public final Schema schema;
        @NotNull
        public String name;
        @Nullable
        public String type;
        @Nullable
        public String comment;

        public Table(@NotNull Schema schema, @NotNull String name) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$Table", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$Table", "<init>"));
            }
            this.name = "";
            this.schema = schema;
            this.name = name;
        }
    }

    public static class Schema
    extends Assignable<Schema> {
        @NotNull
        public String schema;
        @Nullable
        public String database;

        public Schema(@NotNull String schema, @Nullable String database) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/DatabaseMetaDataWrapper$Schema", "<init>"));
            }
            this.schema = schema;
            this.database = database;
        }
    }

    public static class Assignable<T extends Assignable> {
        public void assign(T val) {
            try {
                for (Field field : this.getClass().getDeclaredFields()) {
                    if (Assignable.class.isAssignableFrom(field.getType())) {
                        ((Assignable)field.get(this)).assign((Assignable)field.get(val));
                        continue;
                    }
                    if (Modifier.isFinal(field.getModifiers())) continue;
                    field.set(this, field.get(val));
                }
            }
            catch (IllegalAccessException e) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
            }
        }
    }
}

