/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.generic.meta;

import com.intellij.database.model.DasArgument;
import com.intellij.dbm.generic.meta.ClosableIt;
import com.intellij.dbm.generic.meta.DatabaseMetaDataWrapper;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class SybaseRoutineArgumentIt
extends ClosableIt.DelegateMutableIt<DatabaseMetaDataWrapper.TableColumn, DatabaseMetaDataWrapper.RoutineArgument> {
    private final DatabaseMetaDataWrapper.Schema mySchema;

    SybaseRoutineArgumentIt(@NotNull DatabaseMetaDataWrapper.Schema schema, Iterator<? extends DatabaseMetaDataWrapper.TableColumn> it) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/SybaseRoutineArgumentIt", "<init>"));
        }
        super(it);
        this.mySchema = schema;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.RoutineArgument createStorage() {
        DatabaseMetaDataWrapper.RoutineArgument routineArgument = new DatabaseMetaDataWrapper.RoutineArgument(new DatabaseMetaDataWrapper.Routine(this.mySchema, null, ""));
        if (routineArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/SybaseRoutineArgumentIt", "createStorage"));
        }
        return routineArgument;
    }

    @Override
    protected DatabaseMetaDataWrapper.RoutineArgument calcValue(DatabaseMetaDataWrapper.TableColumn cur) {
        if (cur == null) {
            return (DatabaseMetaDataWrapper.RoutineArgument)this.skip();
        }
        DatabaseMetaDataWrapper.RoutineArgument res = (DatabaseMetaDataWrapper.RoutineArgument)this.getStorageToFill();
        res.routine.specificName = res.routine.name = cur.table.name;
        res.routine.pkg = null;
        res.name = cur.name;
        res.direction = "Return Type".equals(res.name) ? DasArgument.Direction.RETURN : DasArgument.Direction.IN;
        res.def = cur.def;
        res.comment = cur.comment;
        res.length = cur.length;
        res.nullable = cur.nullable;
        res.position = cur.position;
        res.scale = cur.scale;
        res.type = cur.type;
        res.typeName = cur.typeName;
        return res;
    }
}

