/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.generic.meta;

import com.intellij.database.util.ErrorHandler;
import com.intellij.dbm.generic.meta.ClosableIt;
import com.intellij.dbm.generic.meta.DatabaseMetaDataWrapper;
import com.intellij.dbm.generic.meta.MetaDataUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.Table> {
    private final DatabaseMetaDataWrapper.Schema mySchema;

    public TableIt(@NotNull MetaDataUtil.ResultSetWrapper rs, @NotNull ErrorHandler handler, @Nullable Boolean initialHasNext, @NotNull DatabaseMetaDataWrapper.Schema schema) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/dbm/generic/meta/TableIt", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/dbm/generic/meta/TableIt", "<init>"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/meta/TableIt", "<init>"));
        }
        super(rs, handler, initialHasNext);
        this.mySchema = schema;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.Table createStorage() {
        DatabaseMetaDataWrapper.Table table = new DatabaseMetaDataWrapper.Table(this.mySchema, "");
        if (table == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/TableIt", "createStorage"));
        }
        return table;
    }

    @Override
    protected DatabaseMetaDataWrapper.Table calcValue() throws SQLException {
        DatabaseMetaDataWrapper.Table res = (DatabaseMetaDataWrapper.Table)this.getStorageToFill();
        try {
            String name = this.myRs.getString("TABLE_NAME", 3);
            if (StringUtil.isEmpty((String)name)) {
                return (DatabaseMetaDataWrapper.Table)this.skip();
            }
            res.name = name;
            res.type = this.myRs.getString("TABLE_TYPE", 4);
            res.comment = this.myRs.getString("REMARKS", 5);
        }
        catch (SQLException e) {
            this.onError(res, e);
            return (DatabaseMetaDataWrapper.Table)this.skip();
        }
        return res;
    }
}

