/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.h2;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmCheck;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmMultiDatabaseModel;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSequence;
import com.intellij.dbm.common.DbmTable;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.common.DbmView;
import com.intellij.dbm.generic.DbmGenericSchema;
import com.intellij.dbm.generic.DbmGenericSingleRoutine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.H2db;
import org.jetbrains.dekaf.Rdbms;

public class H2Model
extends DbmMultiDatabaseModel<DbmDatabase, DbmGenericSchema> {
    public static Casing CASING = Casing.create((Case)Case.UPPER, (Case)Case.EXACT);
    public static final MetaModel<DbmObject> META_MODEL = MetaModel.builder().put(ObjectKind.ROOT, ObjectKind.DATABASE, DbmDatabase.class).put(ObjectKind.DATABASE, ObjectKind.SCHEMA, DbmGenericSchema.class).put(ObjectKind.SCHEMA, ObjectKind.TABLE, DbmTable.class).put(ObjectKind.TABLE, ObjectKind.COLUMN, DbmColumn.class).put(ObjectKind.TABLE, ObjectKind.INDEX, DbmIndex.class).put(ObjectKind.TABLE, ObjectKind.KEY, DbmKey.class).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY, DbmForeignKey.class).put(ObjectKind.TABLE, ObjectKind.CHECK, DbmCheck.class).put(ObjectKind.TABLE, ObjectKind.TRIGGER, DbmTrigger.class).put(ObjectKind.SCHEMA, ObjectKind.VIEW, DbmView.class).put(ObjectKind.VIEW, ObjectKind.COLUMN, DbmColumn.class).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE, DbmGenericSingleRoutine.class).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT, DbmArgument.class).put(ObjectKind.SCHEMA, ObjectKind.SEQUENCE, DbmSequence.class).build();

    public H2Model() {
        super(META_MODEL);
    }

    @Override
    @NotNull
    public Rdbms getRdbms() {
        Rdbms rdbms = H2db.RDBMS;
        if (rdbms == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/h2/H2Model", "getRdbms"));
        }
        return rdbms;
    }

    @Override
    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dbm/h2/H2Model", "getCasing"));
        }
        Casing casing = CASING;
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/h2/H2Model", "getCasing"));
        }
        return casing;
    }
}

