/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.mssql;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum MsRoutineType {
    SCALAR_FUN("FN"),
    TAB_FUN("TF"),
    INLINE_TAB_FUN("IF"),
    PROC("P"),
    EXT_PROC("X"),
    CLR_PROC("PC");

    public final String code;
    public static final Map<String, MsRoutineType> FUNCTION_TYPES;
    public static final Map<String, MsRoutineType> PROCEDURE_TYPES;
    public static final Map<String, MsRoutineType> TYPES;

    private MsRoutineType(String code) {
        this.code = code;
    }

    static {
        FUNCTION_TYPES = ImmutableMap.builder().put((Object)MsRoutineType.SCALAR_FUN.code, (Object)SCALAR_FUN).put((Object)MsRoutineType.TAB_FUN.code, (Object)TAB_FUN).put((Object)MsRoutineType.INLINE_TAB_FUN.code, (Object)TAB_FUN).build();
        PROCEDURE_TYPES = ImmutableMap.builder().put((Object)MsRoutineType.PROC.code, (Object)PROC).put((Object)MsRoutineType.EXT_PROC.code, (Object)EXT_PROC).put((Object)MsRoutineType.CLR_PROC.code, (Object)CLR_PROC).build();
        TYPES = ImmutableMap.builder().putAll(FUNCTION_TYPES).putAll(PROCEDURE_TYPES).build();
    }
}

