/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.mysql;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.dbm.common.CascadeRule;
import com.intellij.dbm.common.DBIntrospectionError;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSingleRoutine;
import com.intellij.dbm.common.DbmTable;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.common.DbmView;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.SingleDatabaseIntrospector;
import com.intellij.dbm.common.TrigEvent;
import com.intellij.dbm.common.TrigTurn;
import com.intellij.dbm.mysql.MysqlIntroQueries;
import com.intellij.dbm.mysql.MysqlModel;
import com.intellij.dbm.mysql.MysqlSchema;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.SmartHashSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBSession;
import org.jetbrains.dekaf.core.DBTransaction;

public class MysqlIntrospector
extends SingleDatabaseIntrospector<MysqlSchema, MysqlModel> {
    private static final SequenceIdentity ourMysqlIdentity = SequenceIdentity.of(1L, null, 1L, null);

    public MysqlIntrospector(@NotNull DBFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/dbm/mysql/MysqlIntrospector", "<init>"));
        }
        super(facade);
    }

    @Override
    protected boolean modelCanBeAccepted(@Nullable DbmModel model) {
        return model instanceof MysqlModel;
    }

    @Override
    @NotNull
    protected MysqlModel createNewModel() {
        MysqlModel mysqlModel = new MysqlModel();
        if (mysqlModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "createNewModel"));
        }
        return mysqlModel;
    }

    @Override
    protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull MysqlSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/mysql/MysqlIntrospector", "isPossibleToIntrospectSchemaIncrementally"));
        }
        return false;
    }

    private void workWithModel(@NotNull Consumer<MysqlModel> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/dbm/mysql/MysqlIntrospector", "workWithModel"));
        }
        ((MysqlModel)this.myModel).startModifications();
        try {
            consumer.accept((MysqlModel)this.myModel);
        }
        finally {
            ((MysqlModel)this.myModel).finishModifications();
        }
    }

    @Override
    protected void introspectNamespaces(@NotNull DBTransaction tran) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector", "introspectNamespaces"));
        }
        String[] names = (String[])tran.query(MysqlIntroQueries.QUERIES.querySchemas).run();
        this.workWithModel(model -> {
            Family schemas = model.schemas();
            schemas.markChildrenAsSyncPending();
            boolean empty = schemas.isEmpty();
            int n = names.length;
            for (int i = 0; i < n; ++i) {
                String name = names[i];
                MysqlSchema schema = (MysqlSchema)schemas.getOrCreate(name);
                if (i != 0) continue;
                model.setCurrentSchema(schema);
                if (!empty) continue;
                schema.setVisible(true);
            }
            schemas.removeSyncPendingChildren();
        });
    }

    @Override
    protected void introspectAuto(@NotNull DBTransaction tran, @NotNull List<MysqlSchema> schemas) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector", "introspectAuto"));
        }
        if (schemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/dbm/mysql/MysqlIntrospector", "introspectAuto"));
        }
        for (MysqlSchema schema : schemas) {
            this.introspectOneSchema(tran, schema);
        }
    }

    private void introspectOneSchema(@NotNull DBTransaction tran, MysqlSchema schema) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector", "introspectOneSchema"));
        }
        SchemaRetriever retriever = new SchemaRetriever(schema);
        retriever.retrieve(tran);
    }

    private static <T> Set<T> newSet() {
        return new SmartHashSet();
    }

    private static void drop(@NotNull Set<String> newNames, @NotNull Family<? extends DbmObject> f) {
        if (newNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNames", "com/intellij/dbm/mysql/MysqlIntrospector", "drop"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/dbm/mysql/MysqlIntrospector", "drop"));
        }
        for (DbmObject dbmObject : f) {
            if (newNames.contains(dbmObject.getName())) continue;
            dbmObject.drop();
        }
    }

    @NotNull
    private static TrigEvent getEvent(@Nullable String manipulation) {
        if ("INSERT".equalsIgnoreCase(manipulation)) {
            TrigEvent trigEvent = TrigEvent.INSERT;
            if (trigEvent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getEvent"));
            }
            return trigEvent;
        }
        if ("DELETE".equalsIgnoreCase(manipulation)) {
            TrigEvent trigEvent = TrigEvent.DELETE;
            if (trigEvent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getEvent"));
            }
            return trigEvent;
        }
        TrigEvent trigEvent = TrigEvent.UPDATE;
        if (trigEvent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getEvent"));
        }
        return trigEvent;
    }

    @NotNull
    private static DasRoutine.Kind getType(@Nullable String type) {
        if ("FUNCTION".equalsIgnoreCase(type)) {
            DasRoutine.Kind kind = DasRoutine.Kind.FUNCTION;
            if (kind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getType"));
            }
            return kind;
        }
        if ("PROCEDURE".equalsIgnoreCase(type)) {
            DasRoutine.Kind kind = DasRoutine.Kind.PROCEDURE;
            if (kind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getType"));
            }
            return kind;
        }
        DasRoutine.Kind kind = DasRoutine.Kind.NONE;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getType"));
        }
        return kind;
    }

    @NotNull
    private static DasArgument.Direction getDirection(@Nullable String mode) {
        if ("INOUT".equalsIgnoreCase(mode)) {
            DasArgument.Direction direction = DasArgument.Direction.INOUT;
            if (direction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getDirection"));
            }
            return direction;
        }
        if ("OUT".equalsIgnoreCase(mode)) {
            DasArgument.Direction direction = DasArgument.Direction.OUT;
            if (direction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getDirection"));
            }
            return direction;
        }
        DasArgument.Direction direction = DasArgument.Direction.IN;
        if (direction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getDirection"));
        }
        return direction;
    }

    @NotNull
    public static DasArgument.Direction getDirection(int id) {
        if (id == 4) {
            DasArgument.Direction direction = DasArgument.Direction.OUT;
            if (direction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getDirection"));
            }
            return direction;
        }
        if (id == 2) {
            DasArgument.Direction direction = DasArgument.Direction.INOUT;
            if (direction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getDirection"));
            }
            return direction;
        }
        DasArgument.Direction direction = DasArgument.Direction.IN;
        if (direction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getDirection"));
        }
        return direction;
    }

    private final class SchemaRetriever {
        final MysqlSchema mySchema;
        boolean myWithSources;

        SchemaRetriever(MysqlSchema schema) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "<init>"));
            }
            this.mySchema = schema;
            this.myWithSources = false;
        }

        private void work(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "work"));
            }
            ((DbmModel)this.mySchema.getModel()).startModifications();
            try {
                runnable.run();
            }
            finally {
                ((DbmModel)this.mySchema.getModel()).finishModifications();
            }
        }

        private void progress(@NotNull String what) {
            if (what == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "progress"));
            }
            String mode = "completely";
            MysqlIntrospector.this.updateStatus(String.format("Introspecting schema %s (%s)", this.mySchema.getName(), mode), what);
        }

        void retrieve(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieve"));
            }
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "lambda$retrieve$0"));
                }
                this.retrieveTables(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "lambda$retrieve$1"));
                }
                this.retrieveColumns(tran);
            });
            if (this.mySchema.getName().equalsIgnoreCase("information_schema")) {
                return;
            }
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "lambda$retrieve$2"));
                }
                this.retrieveIndices(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "lambda$retrieve$3"));
                }
                this.retrieveRoutines(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "lambda$retrieve$4"));
                }
                this.retrieveRoutineParameters(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "lambda$retrieve$5"));
                }
                this.retrieveTableConstraints(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "lambda$retrieve$6"));
                }
                this.retrieveTriggers(tran);
            });
            if (this.myWithSources) {
                this.work(() -> {
                    if (tran == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "lambda$retrieve$7"));
                    }
                    this.retrieveViewSources(tran);
                });
            }
        }

        private void retrieveTables(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveTables"));
            }
            this.progress("tables and views");
            Set newTables = MysqlIntrospector.newSet();
            Set newViews = MysqlIntrospector.newSet();
            for (MysqlIntroQueries.Table t : (List)tran.query(MysqlIntroQueries.QUERIES.queryTablesAndViews).withParams(new Object[]{this.mySchema.getName()}).run()) {
                String type = t.table_type;
                boolean isView = StringUtil.contains((CharSequence)type, (CharSequence)"VIEW");
                (isView ? newViews : newTables).add(t.table_name);
                DbmLikeTable o = (isView ? this.mySchema.getViews() : this.mySchema.getTables()).getOrCreate(t.table_name);
                o.dropChildren();
                o.setIsSystem(StringUtil.containsIgnoreCase((String)type, (String)"SYSTEM"));
                o.setComment(t.table_comment);
            }
            MysqlIntrospector.drop(newTables, this.mySchema.getTables());
            MysqlIntrospector.drop(newViews, this.mySchema.getViews());
        }

        private void retrieveIndices(DBTransaction t) {
            this.progress("indices");
            String schemaName = this.mySchema.getName();
            for (MysqlIntroQueries.Index i : (List)t.query(MysqlIntroQueries.QUERIES.queryIndices).withParams(new Object[]{schemaName, schemaName}).run()) {
                DbmTable table = (DbmTable)this.mySchema.getTables().get(i.table_name);
                if (table == null) continue;
                DbmIndex index = (DbmIndex)((Family)table.getIndices()).getOrCreate(i.index_name);
                index.setUnique(!i.non_unique);
                for (String s : StringUtil.splitByLines((String)StringUtil.notNullize((String)i.column_names))) {
                    index.addColumn(s, DasIndex.Sorting.ASCENDING);
                }
            }
        }

        private CascadeRule asCascadeRule(String val, boolean update) {
            if (val.equalsIgnoreCase("cascade")) {
                return update ? CascadeRule.update : CascadeRule.delete;
            }
            if (val.equalsIgnoreCase("set null")) {
                return CascadeRule.set_null;
            }
            if (val.equalsIgnoreCase("set default")) {
                return CascadeRule.set_default;
            }
            if (val.equalsIgnoreCase("restrict")) {
                return CascadeRule.restrict;
            }
            if (val.equalsIgnoreCase("no action")) {
                return CascadeRule.no_action;
            }
            return CascadeRule.restrict;
        }

        private void retrieveTableConstraints(@NotNull DBTransaction t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveTableConstraints"));
            }
            this.progress("table constraints");
            HashSet<DbmTable> affectedTables = new HashSet<DbmTable>(this.mySchema.getTables().size());
            String schemaName = this.mySchema.getName();
            for (MysqlIntroQueries.Constraint c : (List)t.query(MysqlIntroQueries.QUERIES.queryConstraints).withParams(new Object[]{schemaName, schemaName, schemaName}).run()) {
                DbmTable table = (DbmTable)this.mySchema.getTables().get(c.table_name);
                if (table == null) continue;
                affectedTables.add(table);
                String[] columnNames = StringUtil.splitByLines((String)StringUtil.notNullize((String)c.column_names));
                String name = c.constraint_name;
                if ("PRIMARY KEY".equals(c.constraint_type)) {
                    DbmKey pk = (DbmKey)((Family)table.getKeys()).getOrCreate(name);
                    pk.setPrimary(true);
                    pk.setColumnNames(columnNames);
                    continue;
                }
                if ("FOREIGN KEY".equals(c.constraint_type)) {
                    String[] refColumnNames = StringUtil.splitByLines((String)StringUtil.notNullize((String)c.ref_column_names));
                    DbmForeignKey fk = (DbmForeignKey)((Family)table.getForeignKeys()).getOrCreate(name);
                    fk.setColumnNames(columnNames);
                    String s = c.referenced_table_schema;
                    String tn = c.referenced_table_name;
                    if (s != null && tn != null) {
                        fk.refKey.set(new String[]{s, tn}, refColumnNames);
                    }
                    fk.setCascadeUpdateRule(this.asCascadeRule(c.update_rule, true));
                    fk.setCascadeDeleteRule(this.asCascadeRule(c.delete_rule, false));
                    continue;
                }
                if (!"UNIQUE".equals(c.constraint_type)) continue;
                DbmKey key = (DbmKey)((Family)table.getKeys()).getOrCreate(name);
                key.myColumns.clearState();
                key.setColumnNames(columnNames);
                DbmIndex index = (DbmIndex)((Family)table.getIndices()).get(name);
                if (index == null) {
                    index = (DbmIndex)((Family)table.getIndices()).create(name);
                    index.setUnique(true);
                    for (String s : columnNames) {
                        index.addColumn(s, DasIndex.Sorting.ASCENDING);
                    }
                }
                key.setUnderlyingIndex(index);
            }
            for (DbmTable table : affectedTables) {
                ((Family)table.getKeys()).reorder();
                ((Family)table.getForeignKeys()).reorder();
            }
        }

        private void retrieveRoutines(@NotNull DBTransaction t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveRoutines"));
            }
            this.progress("routines");
            Set newNames = MysqlIntrospector.newSet();
            for (MysqlIntroQueries.Routine r : (List)t.query(MysqlIntroQueries.QUERIES.queryRoutines).withParams(new Object[]{this.mySchema.getName()}).run()) {
                newNames.add(r.specific_name);
                DbmSingleRoutine routine = this.mySchema.getRoutines().getOrCreate(r.specific_name);
                routine.dropChildren();
                if (this.myWithSources) {
                    routine.setSourceText(r.routine_definition);
                }
                DasRoutine.Kind type = MysqlIntrospector.getType(r.routine_type);
                routine.setRoutineKind(type);
                if (type == DasRoutine.Kind.FUNCTION) {
                    DbmArgument returnArgument = routine.getOrCreateReturnArgument();
                    returnArgument.setDataType(DataTypeFactory.of(r.dtd_identifier));
                }
                routine.setComment(r.routine_comment);
            }
            MysqlIntrospector.drop(newNames, this.mySchema.getRoutines());
        }

        private void retrieveRoutineParameters(@NotNull DBTransaction t) {
            boolean withoutParameters;
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveRoutineParameters"));
            }
            this.progress("routine parameters");
            boolean bl = withoutParameters = t.query(MysqlIntroQueries.QUERIES.parametersTableExists).run() == null;
            if (withoutParameters) {
                this.retrieveRoutineParametersFromMetaData(t);
            } else {
                this.retrieveRoutineParametersFromInformationSchema(t);
            }
        }

        private void retrieveRoutineParametersFromInformationSchema(@NotNull DBTransaction t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveRoutineParametersFromInformationSchema"));
            }
            for (MysqlIntroQueries.Parameter p : (List)t.query(MysqlIntroQueries.QUERIES.queryRoutineParams).withParams(new Object[]{this.mySchema.getName()}).run()) {
                DbmSingleRoutine routine = this.mySchema.getRoutines().getOrCreate(p.specific_name);
                DbmArgument arg = (DbmArgument)((Family)routine.getArguments()).getOrCreate(p.parameter_name);
                arg.setDataType(DataTypeFactory.of(p.dtd_identifier));
                arg.setDirection(MysqlIntrospector.getDirection(p.parameter_mode));
            }
        }

        private void retrieveRoutineParametersFromMetaData(@NotNull DBTransaction t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveRoutineParametersFromMetaData"));
            }
            if (!(t instanceof DBSession)) {
                return;
            }
            Connection connection = (Connection)((DBSession)t).getSpecificService(Connection.class, "jdbc-connection");
            if (connection == null) {
                return;
            }
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                ResultSet c = metaData.getProcedureColumns(this.mySchema.getName(), null, null, null);
                while (c.next()) {
                    String name = c.getString("COLUMN_NAME");
                    if (StringUtil.isEmptyOrSpaces((String)name)) continue;
                    DbmSingleRoutine routine = this.mySchema.getRoutines().getOrCreate(c.getString("PROCEDURE_NAME"));
                    DbmArgument arg = (DbmArgument)((Family)routine.getArguments()).getOrCreate(name);
                    arg.setDataType(DataTypeFactory.of(c.getString("TYPE_NAME")));
                    arg.setDirection(MysqlIntrospector.getDirection(c.getShort("COLUMN_TYPE")));
                }
            }
            catch (SQLException e) {
                throw new DBIntrospectionError((Throwable)e){};
            }
        }

        private void retrieveColumns(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveColumns"));
            }
            this.progress("table columns");
            for (MysqlIntroQueries.Column c : (List)tran.query(MysqlIntroQueries.QUERIES.queryColumns).withParams(new Object[]{this.mySchema.getName()}).run()) {
                String tableName = c.table_name;
                DbmLikeTable table = (DbmLikeTable)this.mySchema.getTables().get(tableName);
                if (table == null) {
                    table = (DbmLikeTable)this.mySchema.getViews().get(tableName);
                }
                if (table == null) continue;
                DbmColumn column = (DbmColumn)((Family)table.getColumns()).getOrCreate(c.column_name);
                column.setMandatory(!"YES".equals(c.is_nullable));
                DataType type = DataTypeFactory.of(c.column_type);
                column.setDataType(type);
                column.setComment(c.column_comment);
                String def = c.column_default;
                if (def != null) {
                    boolean noQuote = "bit".equalsIgnoreCase(type.typeName);
                    if (!noQuote) {
                        noQuote = (type.typeName.startsWith("datetime") || type.typeName.startsWith("timestamp")) && def.startsWith("CURRENT_TIMESTAMP");
                    }
                    column.setDefaultExpression(noQuote ? def : "'" + def + "'");
                }
                if (!"auto_increment".equalsIgnoreCase(c.extra)) continue;
                column.setSequenceIdentity(ourMysqlIdentity);
            }
        }

        private void retrieveViewSources(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveViewSources"));
            }
            this.progress("view sources");
            for (MysqlIntroQueries.View t : (List)tran.query(MysqlIntroQueries.QUERIES.queryViews).withParams(new Object[]{this.mySchema.getName()}).run()) {
                DbmView o = this.mySchema.getViews().getOrCreate(t.table_name);
                o.setSourceText(t.view_definition);
            }
        }

        private void retrieveTriggers(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveTriggers"));
            }
            this.progress("triggers");
            for (MysqlIntroQueries.Trigger t : (List)tran.query(MysqlIntroQueries.QUERIES.queryTriggers).withParams(new Object[]{this.mySchema.getName()}).run()) {
                DbmTable table = this.mySchema.getTables().getOrCreate(t.event_object_table);
                DbmTrigger trigger = table.getTriggers().getOrCreate(t.trigger_name);
                trigger.setTrigTurn("before".equalsIgnoreCase(t.action_timing) ? TrigTurn.BEFORE_ROW : TrigTurn.AFTER_ROW);
                trigger.trigEvents.add(MysqlIntrospector.getEvent(t.event_manipulation));
                if (!this.myWithSources) continue;
                trigger.setSourceText(t.action_statement);
            }
        }
    }
}

