/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.oracle;

import com.google.common.collect.ImmutableList;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.SourceError;
import com.intellij.dbm.common.DbmMinor;
import com.intellij.dbm.common.DbmSourceAware;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.oracle.OraModule;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraBody
extends DbmMinor
implements DbmSourceAware {
    @NotNull
    private final OraModule myModule;
    @Nullable
    private String mySourceText;
    @StateProperty
    public boolean myInvalid;
    @NotNull
    private List<SourceError> myErrors;

    public OraBody(@NotNull OraModule module, @Nullable String name) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dbm/oracle/OraBody", "<init>"));
        }
        super(module, name);
        this.myErrors = NO_ERRORS;
        this.myModule = module;
    }

    @Override
    @NotNull
    public OraModule getDbParent() {
        OraModule oraModule = this.myModule;
        if (oraModule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraBody", "getDbParent"));
        }
        return oraModule;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.BODY;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraBody", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public String getSourceText() {
        return this.mySourceText;
    }

    @Override
    public void setSourceText(@Nullable String sourceText) {
        this.mySourceText = sourceText;
    }

    @Override
    public boolean isInvalid() {
        return this.myInvalid;
    }

    @Override
    public void setInvalid(boolean invalid) {
        this.myInvalid = invalid;
    }

    @Override
    @NotNull
    public List<SourceError> getErrors() {
        List<SourceError> list = this.myErrors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraBody", "getErrors"));
        }
        return list;
    }

    @Override
    public void setErrors(@NotNull List<SourceError> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/dbm/oracle/OraBody", "setErrors"));
        }
        boolean bad = !errors.isEmpty();
        this.myErrors = bad ? ImmutableList.copyOf(errors) : NO_ERRORS;
    }
}

