/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.oracle;

import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmTable;
import com.intellij.dbm.oracle.OraSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraForeignKey
extends DbmForeignKey {
    public OraForeignKey(@NotNull DbmTable table, @Nullable String name) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/oracle/OraForeignKey", "<init>"));
        }
        super(table, name);
    }

    @Override
    protected void nameIsChanged(@Nullable String oldName, @Nullable String newName) {
        super.nameIsChanged(oldName, newName);
        OraSchema schema = (OraSchema)this.table.getSchema();
        if (oldName != null) {
            schema.unregisterConstraint(oldName);
        }
        if (newName != null) {
            schema.registerConstraint(this);
        }
    }
}

