/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.oracle;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmCheck;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmInnerRoutine;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSingleDatabaseModel;
import com.intellij.dbm.common.DbmSingleRoutine;
import com.intellij.dbm.common.DbmSynonym;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.oracle.OraBody;
import com.intellij.dbm.oracle.OraCollectionType;
import com.intellij.dbm.oracle.OraColumn;
import com.intellij.dbm.oracle.OraForeignKey;
import com.intellij.dbm.oracle.OraKey;
import com.intellij.dbm.oracle.OraMatView;
import com.intellij.dbm.oracle.OraModuleAttribute;
import com.intellij.dbm.oracle.OraObjectType;
import com.intellij.dbm.oracle.OraPackage;
import com.intellij.dbm.oracle.OraSchema;
import com.intellij.dbm.oracle.OraSequence;
import com.intellij.dbm.oracle.OraTable;
import com.intellij.dbm.oracle.OraView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Rdbms;

public class OraModel
extends DbmSingleDatabaseModel<OraSchema> {
    public static final MetaModel<DbmObject> META_MODEL = MetaModel.builder().put(ObjectKind.ROOT, ObjectKind.SCHEMA, OraSchema.class).put(ObjectKind.SCHEMA, ObjectKind.TABLE, OraTable.class).put(ObjectKind.SCHEMA, ObjectKind.VIEW, OraView.class).put(ObjectKind.SCHEMA, ObjectKind.MAT_VIEW, OraMatView.class).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE, DbmSingleRoutine.class).put(ObjectKind.SCHEMA, ObjectKind.SEQUENCE, OraSequence.class).put(ObjectKind.SCHEMA, ObjectKind.SYNONYM, DbmSynonym.class).put(ObjectKind.SCHEMA, ObjectKind.OBJECT_TYPE, OraObjectType.class).put(ObjectKind.SCHEMA, ObjectKind.COLLECTION_TYPE, OraCollectionType.class).put(ObjectKind.SCHEMA, ObjectKind.PACKAGE, OraPackage.class).put(ObjectKind.TABLE, ObjectKind.COLUMN, OraColumn.class).put(ObjectKind.TABLE, ObjectKind.INDEX, DbmIndex.class).put(ObjectKind.TABLE, ObjectKind.KEY, OraKey.class).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY, OraForeignKey.class).put(ObjectKind.TABLE, ObjectKind.CHECK, DbmCheck.class).put(ObjectKind.TABLE, ObjectKind.TRIGGER, DbmTrigger.class).put(ObjectKind.VIEW, ObjectKind.COLUMN, OraColumn.class).put(ObjectKind.VIEW, ObjectKind.TRIGGER, DbmTrigger.class).put(ObjectKind.OBJECT_TYPE, ObjectKind.BODY, OraBody.class).put(ObjectKind.OBJECT_TYPE, ObjectKind.OBJECT_ATTRIBUTE, OraModuleAttribute.class).put(ObjectKind.OBJECT_TYPE, ObjectKind.ROUTINE, DbmInnerRoutine.class).put(ObjectKind.PACKAGE, ObjectKind.BODY, OraBody.class).put(ObjectKind.PACKAGE, ObjectKind.ROUTINE, DbmInnerRoutine.class).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT, DbmArgument.class).build();
    static final Casing ORACLE_CASING = Casing.create((Case)Case.UPPER, (Case)Case.EXACT);

    public OraModel() {
        super(META_MODEL);
    }

    @Override
    @NotNull
    public Rdbms getRdbms() {
        Rdbms rdbms = Oracle.RDBMS;
        if (rdbms == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraModel", "getRdbms"));
        }
        return rdbms;
    }

    @Override
    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dbm/oracle/OraModel", "getCasing"));
        }
        Casing casing = ORACLE_CASING;
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraModel", "getCasing"));
        }
        return casing;
    }
}

