/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.oracle;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmComplexElement;
import com.intellij.dbm.common.DbmLikeColumn;
import com.intellij.dbm.common.DbmUserDefinedType;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.oracle.OraModule;
import com.intellij.util.Numbers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraModuleAttribute
extends DbmComplexElement
implements DbmLikeColumn {
    @StateProperty
    public DataType myType;
    private short myPosition;

    public OraModuleAttribute(@NotNull OraModule parent, @Nullable String name) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/dbm/oracle/OraModuleAttribute", "<init>"));
        }
        super(parent, name);
    }

    @Override
    public short getPosition() {
        return this.myPosition;
    }

    @Override
    public void setPosition(short position) {
        this.myPosition = position;
    }

    @Override
    @NotNull
    public String calculateDisplayOrder() {
        String string = Numbers.toFixLengthNumber(this.getPosition(), 3);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraModuleAttribute", "calculateDisplayOrder"));
        }
        return string;
    }

    @Override
    @NotNull
    public DataType getDataType() {
        DataType dataType = this.myType;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraModuleAttribute", "getDataType"));
        }
        return dataType;
    }

    public void setType(@Nullable DataType type) {
        this.myType = type;
    }

    @Override
    @Nullable
    public DbmUserDefinedType getCustomType() {
        if (this.myType == null) {
            return null;
        }
        return this.myType.custom ? this.getDbParent().getSchema().resolveCustomType(this.myType) : null;
    }

    @Override
    public boolean isNotNull() {
        return this.isMandatory();
    }

    @Override
    @Nullable
    public String getDefault() {
        return null;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    @Nullable
    public String getDefaultExpression() {
        return null;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.OBJECT_ATTRIBUTE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraModuleAttribute", "getKind"));
        }
        return objectKind;
    }
}

