/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.postgres;

import com.intellij.database.model.DataType;
import com.intellij.dbm.common.DbmOperator;
import com.intellij.dbm.common.ObjectRef;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.postgres.PostgresRoutine;
import com.intellij.dbm.postgres.PostgresSchema;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostgresOperator
extends DbmOperator {
    @StateProperty
    @NotNull
    public OperatorKind myOperatorKind;
    @StateProperty
    @Nullable
    public DataType myLeftType;
    @StateProperty
    @Nullable
    public DataType myRightType;
    @StateProperty
    @Nullable
    public DataType myResultType;
    @StateProperty
    @NotNull
    public final ObjectRef<PostgresOperator, PostgresRoutine> bindFunction;

    public PostgresOperator(@NotNull PostgresSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/postgres/PostgresOperator", "<init>"));
        }
        super(schema, name);
        this.myOperatorKind = OperatorKind.UNKNOWN;
        this.bindFunction = new ObjectRef<PostgresOperator, PostgresRoutine>(this, schema.routineResolver);
    }

    @NotNull
    public OperatorKind getOperatorKind() {
        OperatorKind operatorKind = this.myOperatorKind;
        if (operatorKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresOperator", "getOperatorKind"));
        }
        return operatorKind;
    }

    public void setOperatorKind(@NotNull OperatorKind operatorKind) {
        if (operatorKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operatorKind", "com/intellij/dbm/postgres/PostgresOperator", "setOperatorKind"));
        }
        if (this.myOperatorKind == operatorKind) {
            return;
        }
        this.modifying();
        this.myOperatorKind = operatorKind;
    }

    public void setLeftType(@Nullable DataType leftType) {
        if (Objects.equals(this.myLeftType, leftType)) {
            return;
        }
        this.modifying();
        this.myLeftType = leftType;
    }

    public void setRightType(@Nullable DataType rightType) {
        if (Objects.equals(this.myRightType, rightType)) {
            return;
        }
        this.modifying();
        this.myRightType = rightType;
    }

    public void setResultType(@Nullable DataType resultType) {
        if (Objects.equals(this.myResultType, resultType)) {
            return;
        }
        this.modifying();
        this.myResultType = resultType;
    }

    @Nullable
    public DataType getLeftType() {
        return this.myLeftType;
    }

    @Nullable
    public DataType getRightType() {
        return this.myRightType;
    }

    @Nullable
    public DataType getResultType() {
        return this.myResultType;
    }

    @Override
    public String[] getSpecItems() {
        DataType lt = this.myLeftType;
        DataType rt = this.myRightType;
        return PostgresOperator.formSpecItems(lt, rt);
    }

    public static String[] formSpecItems(DataType a, DataType b) {
        if (a != null && b != null) {
            return new String[]{a.getSpecification(), b.getSpecification()};
        }
        if (a != null) {
            return new String[]{a.getSpecification()};
        }
        if (b != null) {
            return new String[]{b.getSpecification()};
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public void setSpecItems(String[] specItems) {
    }

    @Override
    public boolean isApplicableTo(String[] specItems) {
        return Arrays.equals(this.getSpecItems(), specItems);
    }

    @Override
    @NotNull
    public String description(boolean includeSurrogates) {
        StringBuilder b = new StringBuilder(60);
        switch (this.myOperatorKind) {
            case BINARY: {
                b.append("binary operator (").append(this.getLeftType()).append(", ").append(this.getRightType()).append(") -> ").append(this.getResultType());
                break;
            }
            case PREFIX: {
                b.append("prefix operator (").append(this.getRightType()).append(") -> ").append(this.getResultType());
                break;
            }
            case POSTFIX: {
                b.append("postfix operator (").append(this.getLeftType()).append(") -> ").append(this.getResultType());
                break;
            }
            default: {
                b.append("unknown operator (").append(this.getLeftType()).append(", ").append(this.getRightType()).append(") -> ").append(this.getResultType());
            }
        }
        if (this.bindFunction.exists()) {
            b.append(" [bound to ");
            PostgresRoutine routine = this.bindFunction.resolveObject();
            if (routine != null) {
                b.append(routine.identity(this.getSchema()));
            } else {
                b.append(this.bindFunction.getPathString());
            }
            b.append("]");
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresOperator", "description"));
        }
        return string;
    }

    public static enum OperatorKind {
        UNKNOWN('\u0000'),
        BINARY('b'),
        PREFIX('l'),
        POSTFIX('r');

        public final char code;

        private OperatorKind(char code) {
            this.code = code;
        }

        @NotNull
        public static OperatorKind of(char code) {
            switch (code) {
                case 'B': 
                case 'b': {
                    OperatorKind operatorKind = BINARY;
                    if (operatorKind == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresOperator$OperatorKind", "of"));
                    }
                    return operatorKind;
                }
                case 'L': 
                case 'l': {
                    OperatorKind operatorKind = PREFIX;
                    if (operatorKind == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresOperator$OperatorKind", "of"));
                    }
                    return operatorKind;
                }
                case 'R': 
                case 'r': {
                    OperatorKind operatorKind = POSTFIX;
                    if (operatorKind == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresOperator$OperatorKind", "of"));
                    }
                    return operatorKind;
                }
            }
            OperatorKind operatorKind = UNKNOWN;
            if (operatorKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresOperator$OperatorKind", "of"));
            }
            return operatorKind;
        }
    }
}

