/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.postgres;

import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.common.DbmUtil;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.common.TrigTurn;
import com.intellij.dbm.postgres.PostgresTriggerFireMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostgresRule
extends DbmTrigger {
    @StateProperty
    @NotNull
    public PostgresTriggerFireMode myFireMode;

    public PostgresRule(@NotNull DbmLikeTable table, @Nullable String name) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/postgres/PostgresRule", "<init>"));
        }
        super(table, name);
        this.myFireMode = PostgresTriggerFireMode.ORIGIN;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.RULE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresRule", "getKind"));
        }
        return objectKind;
    }

    @NotNull
    public PostgresTriggerFireMode getFireMode() {
        PostgresTriggerFireMode postgresTriggerFireMode = this.myFireMode;
        if (postgresTriggerFireMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresRule", "getFireMode"));
        }
        return postgresTriggerFireMode;
    }

    public void setFireMode(@NotNull PostgresTriggerFireMode fireMode) {
        if (fireMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fireMode", "com/intellij/dbm/postgres/PostgresRule", "setFireMode"));
        }
        if (this.myFireMode == fireMode) {
            return;
        }
        this.modifying();
        this.myFireMode = fireMode;
    }

    @Override
    @NotNull
    public String description(boolean includeSurrogates) {
        StringBuilder b = new StringBuilder(60);
        b.append("rule");
        TrigTurn turn = this.getTrigTurn();
        if (turn != null) {
            b.append(' ').append(DbmUtil.humanizeEnumName(turn.name()));
        }
        if (this.trigEvents.isNotEmpty()) {
            b.append(" on ").append(this.trigEvents.toString());
        }
        PostgresTriggerFireMode fireMode = this.getFireMode();
        if (!fireMode.byDefault) {
            b.append(" fire ").append(DbmUtil.humanizeEnumName(fireMode.name()));
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresRule", "description"));
        }
        return string;
    }
}

