/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.postgres;

public enum PostgresTriggerFireMode {
    ORIGIN('O', true),
    REPLICA('R', false),
    DISABLED('D', false),
    ALWAYS('A', false);

    public final char code;
    public final boolean byDefault;

    private PostgresTriggerFireMode(char code, boolean byDefault) {
        this.code = code;
        this.byDefault = byDefault;
    }

    public static PostgresTriggerFireMode of(char code) {
        switch (Character.toUpperCase(code)) {
            case 'O': {
                return ORIGIN;
            }
            case 'R': {
                return REPLICA;
            }
            case 'D': {
                return DISABLED;
            }
            case 'A': {
                return ALWAYS;
            }
        }
        return null;
    }
}

