/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.serialization;

import com.intellij.dbm.serialization.DbmObjectMem;
import com.intellij.dbm.serialization.NameAndValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DbmObjectMemBuilder {
    @Nullable
    Integer id;
    @Nullable
    Integer parentId;
    @Nullable
    String kind;
    @Nullable
    String name;
    @NotNull
    List<NameAndValue<String>> properties;

    DbmObjectMemBuilder() {
        this.properties = new ArrayList<NameAndValue<String>>();
    }

    DbmObjectMemBuilder(Integer id, Integer parentId, String kind, String name) {
        this.id = id;
        this.parentId = parentId;
        this.kind = kind;
        this.name = name;
        this.properties = new ArrayList<NameAndValue<String>>();
    }

    DbmObjectMemBuilder(DbmObjectMem mem) {
        this.id = mem.id;
        this.parentId = mem.parentId;
        this.kind = mem.kind;
        this.name = mem.name;
        this.properties = new ArrayList<NameAndValue<String>>(mem.properties);
    }

    @NotNull
    DbmObjectMem build() {
        List<NameAndValue<String>> p;
        assert (this.id != null) : "Id must be specified";
        assert (this.kind != null) : "Kind must be specified";
        int n = this.properties.size();
        switch (n) {
            case 0: {
                p = Collections.emptyList();
                break;
            }
            case 1: {
                p = Collections.singletonList(this.properties.get(0));
                break;
            }
            default: {
                p = this.properties;
            }
        }
        DbmObjectMem dbmObjectMem = new DbmObjectMem(this.id, this.parentId, this.kind, this.name, p);
        if (dbmObjectMem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/serialization/DbmObjectMemBuilder", "build"));
        }
        return dbmObjectMem;
    }

    @Nullable
    public String excludeProperty(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/dbm/serialization/DbmObjectMemBuilder", "excludeProperty"));
        }
        Iterator<NameAndValue<String>> it = this.properties.iterator();
        while (it.hasNext()) {
            NameAndValue<String> p = it.next();
            if (!p.name.equals(propertyName)) continue;
            it.remove();
            return (String)p.value;
        }
        return null;
    }
}

