/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.sybase;

import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmRoot;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.sybase.SybaseSchema;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SybaseDatabase
extends DbmDatabase {
    private final ConcurrentLongObjectMap<DbmObject> myObjectsById;
    @StateProperty
    @Nullable
    public String myCollation;
    private transient boolean myNamingCaseSensitive;

    public SybaseDatabase(@NotNull DbmRoot root, @Nullable String name) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/dbm/sybase/SybaseDatabase", "<init>"));
        }
        super(root, name);
        this.myObjectsById = ContainerUtil.createConcurrentLongObjectMap();
    }

    @Override
    @NotNull
    public Family<SybaseSchema> getSchemas() {
        Family family = this.mySchemas;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/sybase/SybaseDatabase", "getSchemas"));
        }
        return family;
    }

    void justObjectIdChanged(DbmObject object, long oldId, long newId) {
        if (oldId != 0L) {
            this.myObjectsById.remove(oldId, (Object)object);
        }
        if (newId != 0L) {
            this.myObjectsById.put(newId, (Object)object);
        }
    }

    @Nullable
    public DbmObject getObjectById(long id) {
        return (DbmObject)this.myObjectsById.get(id);
    }

    @Nullable
    public <T> T getObjectById(@NotNull Class<T> objectClass, long id) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/dbm/sybase/SybaseDatabase", "getObjectById"));
        }
        DbmObject object = this.getObjectById(id);
        if (object == null) {
            return null;
        }
        return (T)(objectClass.isAssignableFrom(object.getClass()) ? object : null);
    }

    @NotNull
    long[] allObjectIds() {
        long[] lArray = this.myObjectsById.keys();
        if (lArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/sybase/SybaseDatabase", "allObjectIds"));
        }
        return lArray;
    }

    public boolean isNamingCaseSensitive() {
        return this.myNamingCaseSensitive;
    }

    public void setNamingCaseSensitive(boolean caseSensitive) {
        if (this.myNamingCaseSensitive == caseSensitive) {
            return;
        }
        this.modifying();
        this.myNamingCaseSensitive = caseSensitive;
    }

    @Nullable
    public String getCollation() {
        return this.myCollation;
    }

    public void setCollation(@Nullable String collation) {
        if (StringUtil.equalsIgnoreCase((CharSequence)this.myCollation, (CharSequence)collation)) {
            return;
        }
        this.modifying();
        this.myCollation = collation;
    }
}

