/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.sybase;

import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.sybase.SybaseDatabase;
import com.intellij.dbm.sybase.SybaseFunction;
import com.intellij.dbm.sybase.SybaseProcedureGroup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SybaseSchema
extends DbmSchema {
    final Family<SybaseProcedureGroup> myProcedureGroups;

    public SybaseSchema(@NotNull DbmDatabase database, @Nullable String name) {
        if (database == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/sybase/SybaseSchema", "<init>"));
        }
        super(database, name);
        this.myProcedureGroups = Family.of(this, ObjectKind.PACKAGE);
        this.assignFamilies(this.mySequences, this.myTables, this.myViews, this.myProcedureGroups, this.myRoutines);
    }

    @NotNull
    public SybaseDatabase getDatabase() {
        SybaseDatabase sybaseDatabase = (SybaseDatabase)this.myDatabase;
        if (sybaseDatabase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/sybase/SybaseSchema", "getDatabase"));
        }
        return sybaseDatabase;
    }

    @NotNull
    public Family<SybaseFunction> getRoutines() {
        Family family = this.myRoutines;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/sybase/SybaseSchema", "getRoutines"));
        }
        return family;
    }

    @NotNull
    public Family<SybaseProcedureGroup> getProcedureGroups() {
        Family<SybaseProcedureGroup> family = this.myProcedureGroups;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/sybase/SybaseSchema", "getProcedureGroups"));
        }
        return family;
    }

    @Override
    protected void justObjectIdChanged(DbmObject object, long oldId, long newId) {
        this.getDatabase().justObjectIdChanged(object, oldId, newId);
    }

    @Nullable
    public <T> T getObjectById(@NotNull Class<T> objectClass, long id) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/dbm/sybase/SybaseSchema", "getObjectById"));
        }
        DbmObject object = this.getDatabase().getObjectById(id);
        if (object == null) {
            return null;
        }
        if (object.getSchema() != this) {
            return null;
        }
        return (T)(objectClass.isAssignableFrom(object.getClass()) ? object : null);
    }
}

