/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.suppression;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.sql.inspections.suppression.SqlSuppressInspectionFix;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SqlFileSuppressInspectionFix
extends SqlSuppressInspectionFix {
    public SqlFileSuppressInspectionFix(@NotNull String toolId) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/sql/inspections/suppression/SqlFileSuppressInspectionFix", "<init>"));
        }
        super(toolId, SqlFile.class);
    }

    @NotNull
    public String getText() {
        if ("Suppress for file" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/suppression/SqlFileSuppressInspectionFix", "getText"));
        }
        return "Suppress for file";
    }

    @Override
    protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/suppression/SqlFileSuppressInspectionFix", "createSuppression"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/suppression/SqlFileSuppressInspectionFix", "createSuppression"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/inspections/suppression/SqlFileSuppressInspectionFix", "createSuppression"));
        }
        PsiParserFacade parserFacade = PsiParserFacade.SERVICE.getInstance((Project)project);
        String text = SqlFileSuppressInspectionFix.tag(this.myID, true);
        PsiComment comment = parserFacade.createLineOrBlockCommentFromText(element.getContainingFile().getLanguage(), text);
        PsiElement where = file.addBefore((PsiElement)comment, file.getFirstChild());
        PsiElement spaceFromText = PsiParserFacade.SERVICE.getInstance((Project)project).createWhiteSpaceFromText("\n");
        file.addAfter(spaceFromText, where);
    }
}

