/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.srcStorage.DbSrcMapping;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.PsiTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.psi.JdbcProcedureCall;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTypeStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlLabelHolder;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveCache;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.NameChecker;
import com.intellij.sql.psi.impl.SqlCompletionUtil;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.psi.impl.SqlResolveResultImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.OrderedSet;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlReferenceImpl
implements PsiPolyVariantReference,
PsiQualifiedReference {
    static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"sqlTypeCalc");
    @NotNull
    private static final ResolveCache.PolyVariantResolver<SqlReferenceImpl> MY_RESOLVER = new ResolveCache.PolyVariantResolver<SqlReferenceImpl>(){

        @NotNull
        public ResolveResult[] resolve(@NotNull SqlReferenceImpl reference, boolean incompleteCode) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/sql/psi/impl/SqlReferenceImpl$1", "resolve"));
            }
            PsiFile file = reference.getElement().getContainingFile();
            if (file instanceof SqlFileImpl && reference.getQualifier() == null) {
                SqlResolveCache cache = ((SqlFileImpl)file).getResolveCache();
                ResolveResult[] result = cache.getResult((PsiReference)reference);
                if (result != null) {
                    if (result == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl$1", "resolve"));
                    }
                    return result;
                }
                ResolveResult[] computed = reference.resolveInner();
                cache.cacheResult((PsiReference)reference, computed);
                if (computed == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl$1", "resolve"));
                }
                return computed;
            }
            ResolveResult[] resolveResultArray = reference.resolveInner();
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl$1", "resolve"));
            }
            return resolveResultArray;
        }
    };
    @NotNull
    private static final ResolveCache.AbstractResolver<SqlReferenceImpl, SqlType> MY_TYPE_RESOLVER = new ResolveCache.AbstractResolver<SqlReferenceImpl, SqlType>(){

        @NotNull
        public SqlType resolve(@NotNull SqlReferenceImpl reference, boolean incompleteCode) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/sql/psi/impl/SqlReferenceImpl$2", "resolve"));
            }
            SqlType sqlType = reference.getSqlTypeInner();
            if (sqlType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl$2", "resolve"));
            }
            return sqlType;
        }
    };
    private final SqlElement myElement;

    public SqlReferenceImpl(@NotNull SqlElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlReferenceImpl", "<init>"));
        }
        this.myElement = element;
    }

    @Nullable
    public SqlExpression getQualifier() {
        return this.getQualifierExpression();
    }

    @Nullable
    public abstract SqlExpression getQualifierExpression();

    @Nullable
    public abstract String getReferenceName();

    @NotNull
    public SqlType getSqlType() {
        SqlType type = (SqlType)ResolveCache.getInstance((Project)this.getElement().getProject()).resolveWithCaching((PsiReference)this, MY_TYPE_RESOLVER, true, false);
        Object object = type == null ? SqlType.UNKNOWN : type;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getSqlType"));
        }
        return object;
    }

    public boolean resolveStrict() {
        if (SqlCompletionUtil.isDropTarget((PsiElement)this.myElement) || SqlCompletionUtil.isJoinUsingColumn((PsiElement)this.myElement)) {
            return true;
        }
        SqlSetAssignment assignment = (SqlSetAssignment)ObjectUtils.tryCast((Object)this.myElement.getParent(), SqlSetAssignment.class);
        return PsiTreeUtil.getParentOfType((PsiElement)assignment, SqlUpdateStatement.class) != null && assignment.getLValue() == this.myElement;
    }

    @NotNull
    private SqlType getSqlTypeInner() {
        SqlLanguageDialectEx dialect = this.getSqlDialect();
        PsiElement element = this.resolve();
        if (element == this.myElement && "*".equals(this.getReferenceName())) {
            SqlType sqlType = SqlReferenceImpl.getAsteriskType(this.myElement);
            if (sqlType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getSqlTypeInner"));
            }
            return sqlType;
        }
        if (this.getReferenceElementType().getTargetKind() == ObjectKind.SEQUENCE || element instanceof DasObject && ((DasObject)element).getKind() == ObjectKind.SEQUENCE) {
            SqlTableType sqlTableType = dialect.createSequenceType((PsiElement)this.myElement, element);
            if (sqlTableType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getSqlTypeInner"));
            }
            return sqlTableType;
        }
        if (element instanceof PsiTable) {
            SqlTableType sqlTableType = SqlTableTypeBase.createType((PsiTable)element, (PsiElement)this.myElement);
            if (sqlTableType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getSqlTypeInner"));
            }
            return sqlTableType;
        }
        if (element instanceof DasSynonym) {
            DasObject target = DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)element));
            PsiTable info = target instanceof PsiTable ? (PsiTable)target : null;
            Object object = info != null ? SqlTableTypeBase.createType(info, (PsiElement)this.myElement) : SqlType.UNKNOWN;
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getSqlTypeInner"));
            }
            return object;
        }
        if (element instanceof SqlTypedDefinition) {
            SqlExpression initializer;
            SqlTypedDefinition definition = (SqlTypedDefinition)element;
            SqlTypeElement typeElement = definition.getTypeElement();
            if (typeElement != null) {
                SqlType type = typeElement.findSqlType();
                if (type == SqlType.UNKNOWN) {
                    SqlType sqlType = dialect.getDefinitionType(definition, this.getElement().getTextOffset());
                    if (sqlType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getSqlTypeInner"));
                    }
                    return sqlType;
                }
                SqlType sqlType = type;
                if (sqlType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getSqlTypeInner"));
                }
                return sqlType;
            }
            if (element instanceof SqlVariableDefinition && (initializer = ((SqlVariableDefinition)element).getInitializer()) != null) {
                SqlType sqlType = initializer.getSqlType();
                if (sqlType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getSqlTypeInner"));
                }
                return sqlType;
            }
            SqlType sqlType = this.getReservedEntityType(definition.getName(), dialect, (SqlElement)definition);
            if (sqlType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getSqlTypeInner"));
            }
            return sqlType;
        }
        if (element instanceof SqlFileImpl.FakeDefinition && ((SqlFileImpl.FakeDefinition)element).getKind() == ObjectKind.OBJECT_TYPE) {
            SqlCreateTypeStatement o = (SqlCreateTypeStatement)((SqlFileImpl.FakeDefinition)element).delegates().filter(SqlCreateTypeStatement.class).first();
            SqlTableType type = o == null ? null : o.getSqlType();
            SqlTableType sqlTableType = type == null ? SqlTableTypeBase.EMPTY_TABLE : type;
            if (sqlTableType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getSqlTypeInner"));
            }
            return sqlTableType;
        }
        if (element instanceof DasColumn) {
            DasColumn column = (DasColumn)element;
            SqlType type = dialect.getSqlType(column.getDataType().getSpecification());
            Object object = type == SqlType.UNKNOWN ? SqlType.findByJdbcType((int)column.getDataType().jdbcType) : type;
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getSqlTypeInner"));
            }
            return object;
        }
        if (element == this.myElement) {
            SqlType sqlType = this.getReservedEntityType(this.getReferenceName(), dialect, this.myElement);
            if (sqlType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getSqlTypeInner"));
            }
            return sqlType;
        }
        if (element instanceof SqlExpression) {
            SqlType sqlType = ((SqlExpression)element).getSqlType();
            if (sqlType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getSqlTypeInner"));
            }
            return sqlType;
        }
        if (element instanceof SqlDefinition && element.getParent() instanceof SqlSelectIntoClause) {
            SqlSelectClause clause = (SqlSelectClause)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element.getParent(), SqlSelectClause.class);
            if (clause != null) {
                SqlTableType sqlTableType = SqlImplUtil.getSelectType(clause.getExpressions(), element);
                if (sqlTableType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getSqlTypeInner"));
                }
                return sqlTableType;
            }
        } else if (this.getReferenceElementType().getTargetKind() == ObjectKind.TABLE) {
            SqlTableType sqlTableType = SqlTableTypeBase.createUnresolvedTableType((PsiReference)this);
            if (sqlTableType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getSqlTypeInner"));
            }
            return sqlTableType;
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getSqlTypeInner"));
        }
        return sqlPrimitiveType;
    }

    private SqlType getReservedEntityType(@Nullable String name, @NotNull SqlLanguageDialectEx dialect, @NotNull SqlElement element) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getReservedEntityType"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getReservedEntityType"));
        }
        final Ref ref = Ref.create();
        dialect.processReservedEntitiesWithType(name, (PsiElement)element, true, new SqlScopeProcessor(true, dialect, (Iterable)JBIterable.empty()){

            @Override
            public boolean isResultEmpty() {
                return ref.isNull();
            }

            @Override
            public boolean executeTarget(@Nullable DasObject target, @NotNull PsiElement element, @Nullable SqlType sqlType, Boolean forcedCaseSens, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlReferenceImpl$3", "executeTarget"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlReferenceImpl$3", "executeTarget"));
                }
                if (sqlType != null) {
                    ref.set((Object)sqlType);
                }
                return sqlType != null;
            }
        });
        return !ref.isNull() ? (SqlType)ref.get() : (this.getReferenceElementType().getTargetKind() == ObjectKind.TABLE ? SqlTableTypeBase.EMPTY_TABLE : SqlType.UNKNOWN);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        SqlExpression qual;
        SqlIdentifier id = this.myElement instanceof SqlReferenceExpression ? ((SqlReferenceExpression)this.myElement).getIdentifier() : null;
        SqlExpression sqlExpression = qual = this.myElement instanceof SqlReferenceExpression ? ((SqlReferenceExpression)this.myElement).getQualifierExpression() : null;
        if (id != null && "*".equals(id.getText())) {
            SqlResolveResult[] sqlResolveResultArray = SqlResolveResultImpl.createSingleSqlResults(qual instanceof SqlReferenceExpression ? ((SqlReferenceExpression)qual).resolve() : null, (PsiElement)this.myElement);
            if (sqlResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "multiResolve"));
            }
            return sqlResolveResultArray;
        }
        PsiElement parent = this.myElement.getParent();
        if (parent instanceof DummyHolder) {
            parent = parent.getContext();
        }
        if (parent instanceof SqlDefinition && ((SqlDefinition)parent).getNameElement() == this.myElement) {
            SqlResolveResult[] sqlResolveResultArray = SqlResolveResultImpl.createSingleSqlResults(null, parent);
            if (sqlResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "multiResolve"));
            }
            return sqlResolveResultArray;
        }
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getElement().getProject()).resolveWithCaching((PsiPolyVariantReference)this, MY_RESOLVER, true, incompleteCode);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "multiResolve"));
        }
        return resolveResultArray;
    }

    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 0 ? null : results[0].getElement();
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myElement.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlReferenceImpl", "bindToElement"));
        }
        if (this.isReferenceTo(element)) {
            return this.myElement;
        }
        if (element instanceof PsiNamedElement) {
            return this.handleElementRename(((PsiNamedElement)element).getName());
        }
        return this.myElement;
    }

    public boolean isReferenceTo(PsiElement e1) {
        if (SqlReferenceImpl.isEmptyReferenceTo((PsiElement)this.myElement, e1)) {
            return true;
        }
        SqlReferenceElementType refType = this.getReferenceElementType();
        for (ResolveResult result : this.multiResolve(false)) {
            PsiElement e2 = result.getElement();
            if (this.myElement.getManager().areElementsEquivalent(e1, e2)) {
                return true;
            }
            if (refType != SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE || !(e2 instanceof SqlDefinition) || !SqlReferenceImpl.isEmptyReferenceTo((PsiElement)((SqlDefinition)e2).getNameElement(), e1)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEmptyReferenceTo(PsiElement element, PsiElement e1) {
        PsiElement lastChild;
        PsiElement psiElement = lastChild = element instanceof SqlReferenceExpression ? element.getLastChild() : null;
        if (element.getFirstChild() == lastChild && lastChild instanceof SqlReferenceExpression) {
            SqlReferenceExpression refExpression = (SqlReferenceExpression)lastChild;
            return refExpression.getReference().isReferenceTo(e1);
        }
        return false;
    }

    @NotNull
    public SqlReferenceElementType getReferenceElementType() {
        ASTNode astNode = this.myElement.getNode();
        IElementType elementType = astNode != null ? astNode.getElementType() : null;
        SqlReferenceElementType sqlReferenceElementType = elementType instanceof SqlReferenceElementType ? (SqlReferenceElementType)elementType : SqlCompositeElementTypes.SQL_REFERENCE;
        if (sqlReferenceElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getReferenceElementType"));
        }
        return sqlReferenceElementType;
    }

    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getVariants"));
        }
        return EMPTY_ARRAY;
    }

    public boolean processCompletionVariants(final @NotNull Consumer<LookupElement> resultSet) {
        SqlExpression qualifierExpression;
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/sql/psi/impl/SqlReferenceImpl", "processCompletionVariants"));
        }
        SqlLanguageDialectEx dialect = this.getSqlDialect();
        List<DbDataSource> dataSources = SqlImplUtil.getDataSources((PsiElement)SqlImplUtil.getContainingFile(this.myElement));
        final Set<ObjectKind> expectedTypesStrict = this.getExpectedTargetTypesStrict(dialect);
        final boolean[] isEmpty = new boolean[]{true};
        final boolean addColumns = this.shouldAddMissingColumns();
        SqlScopeProcessor processor = new SqlScopeProcessor(false, dialect, dataSources){

            @Override
            public boolean isResultEmpty() {
                return isEmpty[0];
            }

            @Override
            public boolean executeTarget(@Nullable DasObject target, @NotNull PsiElement element, @Nullable SqlType sqlType, @Nullable Boolean forcedCaseSens, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlReferenceImpl$4", "executeTarget"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlReferenceImpl$4", "executeTarget"));
                }
                if (SqlFileImpl.isEmptyFakeNamespace(target)) {
                    return true;
                }
                if (addColumns && target instanceof DasTable) {
                    for (DasColumn column : DasUtil.getColumns((DasObject)target)) {
                        isEmpty[0] = SqlCompletionUtil.addLookupElement(this.dialect, column, (Consumer<LookupElement>)resultSet, false, 0.0) && isEmpty[0];
                    }
                }
                if (!this.checkType(ObjectUtils.notNull((Object)target, (Object)element), sqlType)) {
                    return true;
                }
                if (target instanceof ReservedEntity && sqlType != null) {
                    resultSet.consume((Object)SqlCompletionUtil.createEntityLookupItem(SqlReferenceImpl.this.myElement.getProject(), target.getName(), sqlType));
                    isEmpty[0] = false;
                } else {
                    Object delegate = target instanceof DbElement ? ((DbElement)target).getDelegate() : null;
                    boolean addDot = !this.checkType(element, sqlType, expectedTypesStrict, true);
                    isEmpty[0] = SqlCompletionUtil.addLookupElement(this.dialect, delegate instanceof PsiElement ? delegate : element, SqlImplUtil.getQualifier(state), (Consumer<LookupElement>)resultSet, addDot, 0.0, SqlReferenceImpl.this.getElement()) && isEmpty[0];
                }
                return true;
            }
        };
        if (this.initExpectedTargetTypes(processor)) {
            this.processResolveVariants(processor);
        }
        dialect.processReservedEntitiesWithType(null, (PsiElement)this.myElement, false, processor);
        if (isEmpty[0] && addColumns && (qualifierExpression = this.getQualifierExpression()) instanceof SqlReferenceExpression && ((SqlReferenceExpression)qualifierExpression).resolve() == null) {
            Set<ObjectKind> expectedTypes = Collections.singleton(this.getReferenceElementType().getTargetKind());
            processor.handleEvent(SqlScopeProcessor.EXPECTED_TYPE, expectedTypes);
            this.processUnqualifiedResolveVariants(processor, ResolveState.initial());
        }
        return true;
    }

    private boolean shouldAddMissingColumns() {
        if (this.getReferenceElementType().getTargetKind() != ObjectKind.COLUMN) {
            return false;
        }
        SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), SqlQueryExpression.class);
        if (query == null) {
            return false;
        }
        if (!PsiTreeUtil.isAncestor((PsiElement)query.getSelectClause(), (PsiElement)this.getElement(), (boolean)true)) {
            return false;
        }
        SqlTableExpression tableExpression = query.getTableExpression();
        SqlFromClause fromClause = tableExpression != null ? tableExpression.getFromClause() : null;
        return fromClause == null || fromClause.getFromExpression() == null;
    }

    private ResolveResult[] resolveInner() {
        DbSrcMapping srcMapping;
        boolean dontCheckName;
        NameChecker nameChecker;
        OrderedSet result;
        List<DbDataSource> dataSources;
        String referenceName = this.getReferenceName();
        SqlLanguageDialectEx dialect = this.getSqlDialect();
        SqlScopeProcessor processor = new SqlScopeProcessor(true, dialect, dataSources = SqlImplUtil.getDataSources((PsiElement)SqlImplUtil.getContainingFile(this.myElement)), (Collection)(result = new OrderedSet()), nameChecker = (dontCheckName = StringUtil.isEmpty((String)referenceName) && this.getQualifierExpression() != null) ? null : new NameChecker(this, dialect, SqlImplUtil.getCasingProvider(dialect, dataSources)), srcMapping = DbSrcMapping.getInstance()){
            final /* synthetic */ Collection val$result;
            final /* synthetic */ NameChecker val$nameChecker;
            final /* synthetic */ DbSrcMapping val$srcMapping;
            {
                this.val$result = collection;
                this.val$nameChecker = nameChecker;
                this.val$srcMapping = dbSrcMapping;
                super(resolve, dialect, dataSources);
            }

            @Override
            public boolean isResultEmpty() {
                return this.val$result.isEmpty();
            }

            @Override
            public boolean executeTarget(@Nullable DasObject target, @NotNull PsiElement t, @Nullable SqlType sqlType, Boolean forcedCaseSens, @NotNull ResolveState state) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/sql/psi/impl/SqlReferenceImpl$5", "executeTarget"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlReferenceImpl$5", "executeTarget"));
                }
                Object named = ObjectUtils.chooseNotNull((Object)target, (Object)ObjectUtils.tryCast((Object)t, SqlReferenceExpression.class));
                if (this.val$nameChecker != null && !this.val$nameChecker.checkName(named, forcedCaseSens)) {
                    return true;
                }
                if (!this.checkType(ObjectUtils.notNull((Object)target, (Object)t), sqlType)) {
                    return true;
                }
                PsiElement qualifier = SqlImplUtil.getQualifier(state);
                if (!(target instanceof DbElement) || !this.val$srcMapping.processSources((DbElement)target, (Consumer<PsiElement>)((Consumer)el -> this.val$result.add(Pair.create((Object)qualifier, (Object)el))))) {
                    this.val$result.add(Pair.create((Object)qualifier, (Object)t));
                }
                return sqlType == null;
            }
        };
        if (this.initExpectedTargetTypes(processor)) {
            this.processResolveVariants(processor);
        } else {
            result.add(Pair.create(null, (Object)this.myElement));
        }
        if (result.isEmpty()) {
            dialect.processReservedEntitiesWithType(referenceName, (PsiElement)this.myElement, true, processor);
        }
        if (result.isEmpty()) {
            SqlElement setLValue;
            PsiElement parent = this.myElement.getParent();
            SqlElement sqlElement = setLValue = parent instanceof SqlSetAssignment ? ((SqlSetAssignment)parent).getLValue() : null;
            if (setLValue instanceof SqlReferenceExpression && ((SqlReferenceExpression)setLValue).getReferenceElementType() == SqlCompositeElementTypes.SQL_SYSTEM_REFERENCE) {
                result.add(Pair.create(null, (Object)this.getElement()));
            }
        }
        return SqlResolveResultImpl.createSqlResults((Collection<Pair<PsiElement, PsiElement>>)result);
    }

    public boolean isSoft() {
        return false;
    }

    public boolean processResolveVariants(@NotNull SqlScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlReferenceImpl", "processResolveVariants"));
        }
        ResolveState state = ResolveState.initial();
        if (this.getReferenceElementType() == SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE) {
            SqlElement def = (SqlElement)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, (Class[])new Class[]{SqlProcedureDefinitionImpl.class, SqlCreateStatement.class});
            return this.processLabels(processor) && (def == null || processor.execute((PsiElement)def, state));
        }
        SqlExpression qualifierExpression = this.getQualifierExpression();
        if (qualifierExpression == null) {
            return this.processUnqualifiedResolveVariants(processor, state);
        }
        if (qualifierExpression instanceof SqlReferenceExpression) {
            return SqlImplUtil.processQualifier((SqlReferenceExpression)qualifierExpression, (PsiScopeProcessor)processor, state, (PsiElement)this.myElement);
        }
        if (this.myElement.getParent() instanceof SqlFunctionCallExpression) {
            return this.processFunctionVariants(processor);
        }
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)qualifierExpression.getSqlType(), SqlTableType.class);
        if (type != null) {
            return SqlImplUtil.processDeclarationsInType(type, (PsiScopeProcessor)processor, state);
        }
        return true;
    }

    public boolean initExpectedTargetTypes(@NotNull SqlScopeProcessor processor) {
        boolean strict;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlReferenceImpl", "initExpectedTargetTypes"));
        }
        PsiFile containingFile = this.myElement.getContainingFile();
        int maxLev = processor.resolve && containingFile == containingFile.getOriginalFile() ? 0 : -1;
        Set<ObjectKind> set = this.getExpectedTargetTypes(processor.resolve, processor.dialect, -1, maxLev, strict = this.resolveStrict());
        if (this.shouldNotBeChecked(set)) {
            return false;
        }
        processor.handleEvent(SqlScopeProcessor.EXPECTED_TYPE, set);
        processor.handleEvent(SqlScopeProcessor.STRICT_TYPE, strict);
        return true;
    }

    @NotNull
    private static SqlType getAsteriskType(@NotNull SqlElement element) {
        SqlQueryExpression queryExpression;
        SqlTableExpression tableExpression;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getAsteriskType"));
        }
        PsiElement parent = element.getParent();
        SqlExpression qualifier = element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).getQualifierExpression() : null;
        SqlExpression targetExpr = (SqlExpression)ObjectUtils.chooseNotNull((Object)qualifier, (Object)(tableExpression = (queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlQueryExpression.class, (boolean)true)) == null ? null : queryExpression.getTableExpression()));
        if (targetExpr == null) {
            SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
            if (sqlTableType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getAsteriskType"));
            }
            return sqlTableType;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)element);
        DatabaseFamilyId familyId = dialect.getFamilyId();
        if (parent instanceof SqlExpressionList && parent.getParent() instanceof SqlFunctionCallExpression) {
            if (familyId.isPostgres() && qualifier != null) {
                SqlType sqlType = targetExpr.getSqlType();
                if (sqlType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getAsteriskType"));
                }
                return sqlType;
            }
            BuiltinFunction definition = ((SqlFunctionCallExpression)parent.getParent()).getFunctionDefinition();
            if (definition == null) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getAsteriskType"));
                }
                return sqlPrimitiveType;
            }
            if (qualifier != null && !dialect.getDatabaseDialect().supportsQualifiedAsteriskInCalls() || !Comparing.strEqual((String)definition.getName(), (String)"count", (boolean)false) && (!familyId.isMicrosoft() || !Comparing.strEqual((String)definition.getName(), (String)"count_big", (boolean)false))) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getAsteriskType"));
                }
                return sqlPrimitiveType;
            }
        } else {
            PsiElement curParent = parent;
            while (curParent instanceof SqlReferenceExpression) {
                curParent = curParent.getParent();
            }
            if (familyId.isPostgres() || familyId.isHsqldb() || familyId.isH2()) {
                while (curParent instanceof SqlParenthesizedExpression) {
                    curParent = curParent.getParent();
                }
            }
            if (!(curParent instanceof SqlSelectClause || curParent instanceof SqlDmlInstruction || curParent instanceof SqlFromClause && curParent.getParent() instanceof SqlDmlInstruction)) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getAsteriskType"));
                }
                return sqlPrimitiveType;
            }
        }
        SqlType sqlType = targetExpr.getSqlType();
        if (sqlType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getAsteriskType"));
        }
        return sqlType;
    }

    private boolean shouldNotBeChecked(@NotNull Set<ObjectKind> expectedTypes) {
        DatabaseFamilyId familyId;
        if (expectedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedTypes", "com/intellij/sql/psi/impl/SqlReferenceImpl", "shouldNotBeChecked"));
        }
        SqlLanguageDialectEx dialect = this.getSqlDialect();
        PsiElement parent = this.myElement.getParent();
        if (expectedTypes.contains(ObjectKind.ROUTINE) && parent != null && parent.getParent() instanceof JdbcProcedureCall) {
            return true;
        }
        if (expectedTypes.contains(ObjectKind.OBJECT_TYPE) && parent instanceof SqlTypeElement && this.getQualifierExpression() == null && PsiTreeUtil.getDeepestFirst((PsiElement)this.myElement).getNode().getElementType() == SqlTokens.SQL_IDENT_DELIMITED && ((familyId = dialect.getDatabaseDialect().getFamilyId()).isTransactSql() || familyId.isPostgres())) {
            String name = this.getReferenceName();
            return name == null || !dialect.shouldQuotedTypeReferenceBeChecked(name);
        }
        return false;
    }

    private boolean processFunctionVariants(@NotNull SqlScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlReferenceImpl", "processFunctionVariants"));
        }
        SqlLanguageDialectEx dialect = processor.dialect;
        if (!processor.resolve || !this.shouldProcessFunctionVariants()) {
            return true;
        }
        PsiElement parent = this.myElement.getParent();
        PsiElement target = parent instanceof SqlFunctionCallExpression ? parent : this.myElement;
        SqlFunctionDefinition builtin = dialect.getSupportedFunctions().get(this.getReferenceName());
        if (builtin != null) {
            if (this.getQualifier() != null && builtin.getDialectAttribute("postfix") == null) {
                return true;
            }
            if (!processor.executeTarget((DasObject)builtin, target, null, dialect.getFamilyId().isMysql() ? Boolean.valueOf(false) : null, ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    private SqlLanguageDialectEx getSqlDialect() {
        return SqlImplUtil.getSqlDialectSafe((PsiElement)this.myElement);
    }

    protected boolean shouldProcessFunctionVariants() {
        return false;
    }

    private boolean processUnqualifiedResolveVariants(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlReferenceImpl", "processUnqualifiedResolveVariants"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlReferenceImpl", "processUnqualifiedResolveVariants"));
        }
        if (!this.myElement.isValid()) {
            return true;
        }
        PsiElement maxScope = SqlImplUtil.getResolveScope(this.myElement.getContainingFile());
        boolean callableExpected = processor.getExpectedTypes().contains(ObjectKind.ROUTINE);
        if (callableExpected && !this.processFunctionVariants(processor) || !PsiTreeUtil.treeWalkUp((PsiScopeProcessor)processor, (PsiElement)this.myElement, (PsiElement)maxScope, (ResolveState)state)) {
            return false;
        }
        ObjectKind targetType = this.getReferenceElementType().getTargetKind();
        if (targetType == SqlDbElementType.LABEL && !processor.dialect.getFamilyId().isMysql() && !this.processLabels(processor)) {
            return false;
        }
        if (targetType == ObjectKind.VARIABLE || targetType == SqlDbElementType.LABEL) {
            return true;
        }
        if (!(callableExpected || processor.resolve && !(this.myElement.getParent() instanceof SqlFunctionCallExpression) || this.processFunctionVariants(processor))) {
            return false;
        }
        PsiFile containingFile = SqlImplUtil.getContainingFile(this.myElement);
        PsiFile psiFile = containingFile.getOriginalFile();
        SqlImportState importChecker = psiFile instanceof SqlFile ? SqlDialectImplUtil.getImportCheckerAt((SqlFile)psiFile, (PsiElement)this.myElement) : null;
        for (DbDataSource dataSource : processor.dataSources) {
            DatabaseSystem d = dataSource.getDelegate();
            if (d instanceof SqlDataSource) {
                for (SqlFile file : ((SqlDataSource)d).getSqlFiles()) {
                    if (file.processDeclarations((PsiScopeProcessor)processor, state, (PsiElement)containingFile, (PsiElement)this.myElement)) continue;
                    return false;
                }
                continue;
            }
            Condition<DasObject> condition = psiFile instanceof SqlFile ? SqlFileImpl.importedCondition(importChecker, dataSource) : Conditions.alwaysTrue();
            if (SqlFileImpl.processDeclarationsImpl((PsiScopeProcessor)processor, state, (PsiObject)dataSource, condition)) continue;
            return false;
        }
        return true;
    }

    private boolean processLabels(@NotNull SqlScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlReferenceImpl", "processLabels"));
        }
        SqlLabelHolder block = (SqlLabelHolder)PsiTreeUtil.getTopmostParentOfType((PsiElement)this.myElement, SqlLabelHolder.class);
        if (block != null) {
            for (SqlDefinition label : block.getLabels()) {
                if (processor.execute((PsiElement)label, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private Set<ObjectKind> getExpectedTargetTypes(boolean resolve, SqlLanguageDialectEx dialect, int minLev, int maxLev, boolean strict) {
        Set<ObjectKind> expectedStrict = this.getExpectedTargetTypesStrict(dialect);
        boolean addCallable = false;
        PsiElement parent = this.myElement.getParent();
        if (!strict && dialect.getDatabaseDialect().getFamilyId().isPostgres() && parent instanceof SqlExpressionList && parent.getParent() instanceof SqlFunctionCallExpression && expectedStrict.contains(ObjectKind.COLUMN)) {
            expectedStrict = SqlReferenceImpl.makeMutable(expectedStrict);
            expectedStrict.add(ObjectKind.TABLE);
        }
        if (!resolve && !strict && (expectedStrict.contains(ObjectKind.COLUMN) || expectedStrict.contains(ObjectKind.TABLE))) {
            PsiElement info = this.myElement.getNextSibling();
            while (info instanceof PsiWhiteSpace || info instanceof PsiComment) {
                info = info.getNextSibling();
            }
            Object value = SqlInfoElementType.getValue(info);
            boolean bl = addCallable = !(value instanceof SqlFunctionDefinition.ReferenceParameter);
        }
        if (maxLev == 0) {
            if (addCallable) {
                expectedStrict = SqlReferenceImpl.makeMutable(expectedStrict);
                expectedStrict.add(ObjectKind.ROUTINE);
            }
            Set<ObjectKind> set = expectedStrict;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getExpectedTargetTypes"));
            }
            return set;
        }
        THashSet parents = new THashSet();
        if (addCallable) {
            parents.add((Object)ObjectKind.ROUTINE);
        }
        for (ObjectKind type : expectedStrict) {
            this.getParentTypes(dialect, type, minLev, maxLev, (Set<ObjectKind>)parents);
        }
        THashSet tHashSet = parents;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getExpectedTargetTypes"));
        }
        return tHashSet;
    }

    @NotNull
    private static Set<ObjectKind> makeMutable(Set<ObjectKind> expectedStrict) {
        if (!(expectedStrict instanceof THashSet)) {
            THashSet result = new THashSet();
            result.addAll(expectedStrict);
            expectedStrict = result;
        }
        THashSet tHashSet = expectedStrict;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "makeMutable"));
        }
        return tHashSet;
    }

    private int getParentTypes(@NotNull SqlLanguageDialectEx dialect, ObjectKind type, int minLevel, int maxLevel, Set<ObjectKind> result) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getParentTypes"));
        }
        Set<ObjectKind> ignored = dialect.getIgnoredParentKinds((PsiElement)this.myElement, this.getReferenceElementType().getTargetKind());
        return SqlImplUtil.getParentTypes(dialect, type, minLevel, maxLevel, ignored, result);
    }

    @NotNull
    private Set<ObjectKind> getExpectedTargetTypesStrict(@NotNull SqlLanguageDialectEx dialect) {
        ObjectKind realLastRefType;
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getExpectedTargetTypesStrict"));
        }
        ObjectKind thisTargetType = this.getReferenceElementType().getTargetKind();
        SqlElement lastRefElement = this.myElement;
        SqlReferenceImpl lastRef = this;
        int inParentLevel = 0;
        int starCount = 0;
        boolean linkReached = false;
        PsiElement parent = this.myElement.getParent();
        while (parent instanceof SqlElement && parent.getReference() instanceof SqlReferenceImpl) {
            lastRefElement = (SqlElement)parent;
            lastRef = (SqlReferenceImpl)parent.getReference();
            if (!linkReached) {
                ++inParentLevel;
                if (Comparing.equal((String)"*", (String)lastRef.getReferenceName())) {
                    ++starCount;
                }
            }
            linkReached |= TreeUtil.findSibling((ASTNode)lastRefElement.getNode(), (IElementType)SqlCompositeElementTypes.SQL_GENERIC_AT_REFERENCE) != null;
            parent = parent.getParent();
        }
        if (thisTargetType == ObjectKind.OBJECT_TYPE) {
            Set set = ContainerUtil.immutableSet((Object[])new ObjectKind[]{ObjectKind.OBJECT_TYPE, ObjectKind.COLLECTION_TYPE, ObjectKind.ALIAS_TYPE, ObjectKind.TABLE_TYPE});
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getExpectedTargetTypesStrict"));
            }
            return set;
        }
        if (thisTargetType != SqlDbElementType.ANY) {
            Set<ObjectKind> set = Collections.singleton(thisTargetType);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getExpectedTargetTypesStrict"));
            }
            return set;
        }
        ObjectKind lastRefType = lastRef != this ? lastRef.getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
        ObjectKind objectKind = realLastRefType = lastRefType != SqlDbElementType.ANY || !(parent instanceof SqlCompositeElementImpl) ? lastRefType : ((SqlCompositeElementImpl)parent).getExpectedReferenceTargetType(lastRefElement);
        if (lastRefType != SqlDbElementType.ANY) {
            THashSet curType = new THashSet();
            this.getParentTypes(dialect, realLastRefType, inParentLevel - starCount, inParentLevel, (Set<ObjectKind>)curType);
            THashSet tHashSet = curType;
            if (tHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getExpectedTargetTypesStrict"));
            }
            return tHashSet;
        }
        Set<ObjectKind> set = Collections.singleton(SqlDbElementType.ANY);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceImpl", "getExpectedTargetTypesStrict"));
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlReferenceImpl that = (SqlReferenceImpl)o;
        return this.myElement.equals(that.myElement);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }
}

