/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;

public class SqlGenericDefinitionStub<T extends SqlDefinition>
extends SqlNamedElementStub<T> {
    protected final StringRef myRefName;
    private SqlReferenceElementType myReferenceType;

    public SqlGenericDefinitionStub(StubElement parent, @NotNull IStubElementType elementType, StringRef name, StringRef refName) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/sql/psi/stubs/SqlGenericDefinitionStub", "<init>"));
        }
        super(parent, elementType, name);
        this.myRefName = refName;
    }

    public String getReferenceTypeName() {
        return this.myRefName == null ? null : this.myRefName.getString();
    }

    public SqlReferenceElementType getReferenceType() {
        if (this.myReferenceType == null) {
            String typeName = this.getReferenceTypeName();
            IElementType type = typeName == null ? null : SqlTokenRegistry.findCompositeType((String)typeName);
            this.myReferenceType = type instanceof SqlReferenceElementType ? (SqlReferenceElementType)type : SqlCompositeElementTypes.SQL_REFERENCE;
        }
        return this.myReferenceType;
    }
}

