/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlInheritedTableDefinition;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.stubs.SqlStubElementType;
import com.intellij.sql.psi.stubs.SqlTableNameIndex;
import com.intellij.sql.psi.stubs.SqlTableStub;
import com.intellij.util.NotNullFunction;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTableElementType
extends SqlStubElementType<SqlTableStub, SqlTableDefinition> {
    public static final NotNullFunction<String, SqlTableElementType> FACTORY = SqlTableElementType::new;

    public SqlTableElementType(@NonNls @NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/psi/stubs/SqlTableElementType", "<init>"));
        }
        super(debugName);
    }

    @NotNull
    public SqlTableStub createStub(@NotNull SqlTableDefinition psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/sql/psi/stubs/SqlTableElementType", "createStub"));
        }
        StringRef[][] ancestorRefs = null;
        if (psi instanceof SqlInheritedTableDefinition) {
            SqlInheritedTableDefinition inherited = (SqlInheritedTableDefinition)psi;
            Object[] methods = inherited.getInheritanceMethods();
            ancestorRefs = new StringRef[methods.length][];
            for (int i = 0; i < methods.length; ++i) {
                List ancestors = inherited.getAncestors(methods[i]);
                ancestorRefs[i] = ancestors.isEmpty() ? StringRef.EMPTY_ARRAY : new StringRef[ancestors.size()];
                for (int j = 0; j < ancestors.size(); ++j) {
                    ancestorRefs[i][j] = StringRef.fromString((String)((SqlReferenceExpression)ancestors.get(j)).getText());
                }
            }
        }
        SqlExpression expression = psi.getExpression();
        SqlTableStub sqlTableStub = new SqlTableStub(parentStub, this, SqlTableElementType.asStringRef((PsiElement)psi.getNameElement()), expression == null ? null : StringRef.fromString((String)expression.getText()), ancestorRefs);
        if (sqlTableStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlTableElementType", "createStub"));
        }
        return sqlTableStub;
    }

    public void serialize(@NotNull SqlTableStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/stubs/SqlTableElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlTableElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getExpressionText());
        SqlTableElementType.writeStringsArray(dataStream, stub.getAncestorTextRefs());
    }

    @NotNull
    public SqlTableStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlTableElementType", "deserialize"));
        }
        SqlTableStub sqlTableStub = new SqlTableStub(parentStub, this, dataStream.readName(), dataStream.readName(), SqlTableElementType.readStringsArray(dataStream));
        if (sqlTableStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlTableElementType", "deserialize"));
        }
        return sqlTableStub;
    }

    @Override
    public void indexStub(@NotNull SqlTableStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/stubs/SqlTableElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/sql/psi/stubs/SqlTableElementType", "indexStub"));
        }
        SqlTableElementType.indexNamedStub(stub, SqlTableNameIndex.KEY, sink);
    }

    private static void writeStringsArray(@NotNull StubOutputStream dataStream, @Nullable StringRef[][] refs) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlTableElementType", "writeStringsArray"));
        }
        if (refs == null) {
            dataStream.writeVarInt(0);
        } else {
            dataStream.writeVarInt(refs.length);
            for (StringRef[] ref : refs) {
                SqlTableElementType.writeStrings(dataStream, ref);
            }
        }
    }

    private static void writeStrings(@NotNull StubOutputStream dataStream, @NotNull StringRef[] refs) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlTableElementType", "writeStrings"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/sql/psi/stubs/SqlTableElementType", "writeStrings"));
        }
        dataStream.writeVarInt(refs.length);
        for (StringRef ref : refs) {
            dataStream.writeName(ref.getString());
        }
    }

    @NotNull
    private static StringRef[] readStrings(@NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlTableElementType", "readStrings"));
        }
        int len = dataStream.readVarInt();
        if (len == 0) {
            if (StringRef.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlTableElementType", "readStrings"));
            }
            return StringRef.EMPTY_ARRAY;
        }
        StringRef[] res = new StringRef[len];
        for (int i = 0; i < res.length; ++i) {
            res[i] = dataStream.readName();
        }
        if (res == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlTableElementType", "readStrings"));
        }
        return res;
    }

    @Nullable
    private static StringRef[][] readStringsArray(@NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlTableElementType", "readStringsArray"));
        }
        int len = dataStream.readVarInt();
        if (len == 0) {
            return null;
        }
        StringRef[][] res = new StringRef[len][];
        for (int i = 0; i < res.length; ++i) {
            res[i] = SqlTableElementType.readStrings(dataStream);
        }
        return res;
    }
}

