/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.database.util.Case;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Names {
    @NotNull
    public static String[] unpackName(@Nullable String name, @NotNull Case caseChangeMode) {
        if (caseChangeMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caseChangeMode", "com/intellij/util/Names", "unpackName"));
        }
        if (name == null || name.length() == 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Names", "unpackName"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] parts = name.trim().split("\\.");
        int n = parts.length;
        if (n == 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Names", "unpackName"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        for (int i = 0; i < n; ++i) {
            String part = parts[i];
            if (part != null) {
                boolean changeCase;
                int len = part.length();
                boolean bl = changeCase = caseChangeMode != Case.EXACT && len > 0;
                if (len >= 2) {
                    char c1 = part.charAt(0);
                    char c9 = part.charAt(len - 1);
                    if (c1 == '\"' && c9 == '\"') {
                        part = part.substring(1, len - 1);
                        changeCase = false;
                    }
                }
                if (changeCase) {
                    if (caseChangeMode == Case.LOWER) {
                        part = StringUtil.toLowerCase((String)part);
                    }
                    if (caseChangeMode == Case.UPPER) {
                        part = StringUtil.toUpperCase((String)part);
                    }
                }
            } else {
                part = "";
            }
            parts[i] = part;
        }
        if (parts == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Names", "unpackName"));
        }
        return parts;
    }

    @NotNull
    public static String[] headArray(String ... array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/Names", "headArray"));
        }
        String[] stringArray = array.length > 1 ? Arrays.copyOf(array, array.length - 1) : new String[]{};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Names", "headArray"));
        }
        return stringArray;
    }
}

