/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AtomicConversionRule
extends TypeConversionRule {
    private static final Logger LOG = Logger.getInstance((String)("#" + AtomicConversionRule.class.getName()));

    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        if (to instanceof PsiClassType && AtomicConversionRule.isAtomicTypeMigration(from, (PsiClassType)to, context)) {
            return AtomicConversionRule.findDirectConversion((PsiElement)context, to, from);
        }
        if (from instanceof PsiClassType && AtomicConversionRule.isAtomicTypeMigration(to, (PsiClassType)from, context)) {
            return AtomicConversionRule.findReverseConversion((PsiElement)context);
        }
        return null;
    }

    private static boolean isAtomicTypeMigration(PsiType from, PsiClassType to, PsiExpression context) {
        if (PsiType.INT.equals((Object)from) && to.getCanonicalText().equals(AtomicInteger.class.getName())) {
            return true;
        }
        if (from.equals(PsiType.INT.createArrayType()) && to.getCanonicalText().equals(AtomicIntegerArray.class.getName())) {
            return true;
        }
        if (PsiType.LONG.equals((Object)from) && to.getCanonicalText().equals(AtomicLong.class.getName())) {
            return true;
        }
        if (from.equals(PsiType.LONG.createArrayType()) && to.getCanonicalText().equals(AtomicLongArray.class.getName())) {
            return true;
        }
        if (PsiType.BOOLEAN.equals((Object)from) && to.getCanonicalText().equals(AtomicBoolean.class.getName())) {
            return true;
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)to);
        PsiClass atomicClass = resolveResult.getElement();
        if (atomicClass != null) {
            String typeQualifiedName = atomicClass.getQualifiedName();
            if (!Comparing.strEqual((String)typeQualifiedName, (String)AtomicReference.class.getName()) && !Comparing.strEqual((String)typeQualifiedName, (String)AtomicReferenceArray.class.getName())) {
                return false;
            }
            PsiTypeParameter[] typeParameters = atomicClass.getTypeParameters();
            if (typeParameters.length != 1) {
                return false;
            }
            PsiType toTypeParameterValue = resolveResult.getSubstitutor().substitute(typeParameters[0]);
            if (toTypeParameterValue != null) {
                if (from.getDeepComponentType() instanceof PsiPrimitiveType) {
                    PsiPrimitiveType unboxedInitialType = PsiPrimitiveType.getUnboxedType((PsiType)toTypeParameterValue);
                    if (unboxedInitialType != null) {
                        return TypeConversionUtil.areTypesConvertible((PsiType)from.getDeepComponentType(), (PsiType)unboxedInitialType);
                    }
                } else {
                    return TypeConversionUtil.isAssignable((PsiType)from.getDeepComponentType(), (PsiType)PsiUtil.captureToplevelWildcards((PsiType)toTypeParameterValue, (PsiElement)context));
                }
            }
        }
        return false;
    }

    @Nullable
    public static TypeConversionDescriptor findDirectConversion(PsiElement context, PsiType to, PsiType from) {
        PsiClass toTypeClass = PsiUtil.resolveClassInType((PsiType)to);
        LOG.assertTrue(toTypeClass != null);
        String qualifiedName = toTypeClass.getQualifiedName();
        if (qualifiedName != null) {
            if (qualifiedName.equals(AtomicInteger.class.getName()) || qualifiedName.equals(AtomicLong.class.getName())) {
                if (context instanceof PsiPostfixExpression) {
                    IElementType operationSign = ((PsiPostfixExpression)context).getOperationTokenType();
                    if (operationSign == JavaTokenType.MINUSMINUS) {
                        return new TypeConversionDescriptor("$qualifier$--", "$qualifier$.getAndDecrement()");
                    }
                    if (operationSign == JavaTokenType.PLUSPLUS) {
                        return new TypeConversionDescriptor("$qualifier$++", "$qualifier$.getAndIncrement()");
                    }
                } else if (context instanceof PsiPrefixExpression) {
                    IElementType operationSign = ((PsiPrefixExpression)context).getOperationTokenType();
                    if (operationSign == JavaTokenType.MINUSMINUS) {
                        return new TypeConversionDescriptor("--$qualifier$", "$qualifier$.decrementAndGet()");
                    }
                    if (operationSign == JavaTokenType.PLUSPLUS) {
                        return new TypeConversionDescriptor("++$qualifier$", "$qualifier$.incrementAndGet()");
                    }
                } else if (context instanceof PsiAssignmentExpression) {
                    PsiJavaToken signToken = ((PsiAssignmentExpression)context).getOperationSign();
                    IElementType operationSign = signToken.getTokenType();
                    String sign = signToken.getText();
                    if (operationSign == JavaTokenType.PLUSEQ || operationSign == JavaTokenType.MINUSEQ) {
                        return new TypeConversionDescriptor("$qualifier$ " + sign + " $val$", "$qualifier$.addAndGet(" + (operationSign == JavaTokenType.MINUSEQ ? "-($val$))" : "$val$)")){

                            @Override
                            public PsiExpression replace(PsiExpression expression, TypeEvaluator evaluator) {
                                PsiExpression operand;
                                PsiExpression striped;
                                PsiMethodCallExpression result = (PsiMethodCallExpression)super.replace(expression, evaluator);
                                PsiExpression argument = result.getArgumentList().getExpressions()[0];
                                if (argument instanceof PsiPrefixExpression && (striped = ParenthesesUtils.stripParentheses((PsiExpression)(operand = ((PsiPrefixExpression)argument).getOperand()))) != null && operand != striped) {
                                    operand.replace((PsiElement)striped);
                                }
                                return result;
                            }
                        };
                    }
                }
            } else if (qualifiedName.equals(AtomicIntegerArray.class.getName()) || qualifiedName.equals(AtomicLongArray.class.getName())) {
                PsiElement parentExpression = context.getParent();
                if (parentExpression instanceof PsiPostfixExpression) {
                    IElementType operationSign = ((PsiPostfixExpression)parentExpression).getOperationTokenType();
                    if (operationSign == JavaTokenType.MINUSMINUS) {
                        return new TypeConversionDescriptor("$qualifier$[$idx$]--", "$qualifier$.getAndDecrement($idx$)", (PsiExpression)parentExpression);
                    }
                    if (operationSign == JavaTokenType.PLUSPLUS) {
                        return new TypeConversionDescriptor("$qualifier$[$idx$]++", "$qualifier$.getAndIncrement($idx$)", (PsiExpression)parentExpression);
                    }
                } else if (parentExpression instanceof PsiPrefixExpression) {
                    IElementType operationSign = ((PsiPrefixExpression)parentExpression).getOperationTokenType();
                    if (operationSign == JavaTokenType.MINUSMINUS) {
                        return new TypeConversionDescriptor("--$qualifier$[$idx$]", "$qualifier$.decrementAndGet($idx$)", (PsiExpression)parentExpression);
                    }
                    if (operationSign == JavaTokenType.PLUSPLUS) {
                        return new TypeConversionDescriptor("++$qualifier$[$idx$]", "$qualifier$.incrementAndGet($idx$)", (PsiExpression)parentExpression);
                    }
                } else if (parentExpression instanceof PsiAssignmentExpression) {
                    PsiJavaToken signToken = ((PsiAssignmentExpression)parentExpression).getOperationSign();
                    IElementType operationSign = signToken.getTokenType();
                    String sign = signToken.getText();
                    if (operationSign == JavaTokenType.PLUSEQ || operationSign == JavaTokenType.MINUSEQ) {
                        return new TypeConversionDescriptor("$qualifier$[$idx$] " + sign + " $val$", "$qualifier$.getAndAdd($idx$, " + (operationSign == JavaTokenType.MINUSEQ ? "-" : "") + "($val$))", (PsiExpression)parentExpression);
                    }
                }
            }
        }
        return from instanceof PsiArrayType ? AtomicConversionRule.findDirectConversionForAtomicReferenceArray(context, to, from) : AtomicConversionRule.findDirectConversionForAtomicReference(context, to, from);
    }

    @Nullable
    private static TypeConversionDescriptor findDirectConversionForAtomicReference(PsiElement context, PsiType to, PsiType from) {
        IElementType operationSign;
        PsiElement parent = context.getParent();
        if (parent instanceof PsiAssignmentExpression && (operationSign = ((PsiAssignmentExpression)parent).getOperationTokenType()) == JavaTokenType.EQ) {
            return new TypeConversionDescriptor("$qualifier$ = $val$", "$qualifier$.set($val$)", (PsiExpression)((PsiAssignmentExpression)parent));
        }
        if (context instanceof PsiReferenceExpression) {
            PsiExpression qualifierExpression = ((PsiReferenceExpression)context).getQualifierExpression();
            PsiExpression expression = context.getParent() instanceof PsiMethodCallExpression && qualifierExpression != null ? qualifierExpression : (PsiExpression)context;
            return new TypeConversionDescriptor("$qualifier$", "$qualifier$.get()", expression);
        }
        if (context instanceof PsiAssignmentExpression) {
            PsiJavaToken signToken = ((PsiAssignmentExpression)context).getOperationSign();
            IElementType operationSign2 = signToken.getTokenType();
            String sign = signToken.getText();
            if (parent instanceof PsiExpressionStatement) {
                if (operationSign2 == JavaTokenType.EQ) {
                    PsiElement element;
                    PsiExpression lExpression = ((PsiAssignmentExpression)context).getLExpression();
                    if (lExpression instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiVariable && ((PsiVariable)element).hasModifierProperty("final")) {
                        return AtomicConversionRule.wrapWithNewExpression(to, from, ((PsiAssignmentExpression)context).getRExpression(), element);
                    }
                    return new TypeConversionDescriptor("$qualifier$ = $val$", "$qualifier$.set($val$)");
                }
                if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)context)) {
                    String name = JavaCodeStyleManager.getInstance((Project)context.getProject()).suggestUniqueVariableName("v", context, false);
                    return new TypeConversionDescriptor("$qualifier$" + sign + "$val$", "$qualifier$.updateAndGet(" + name + " -> " + name + " " + sign.charAt(0) + " $val$)");
                }
                if (context.getParent() instanceof PsiStatement) {
                    return new TypeConversionDescriptor("$qualifier$" + sign + "$val$", "$qualifier$.set(" + AtomicConversionRule.getBoxedWrapper(from, to, "$qualifier$.get() " + sign.charAt(0) + " $val$") + ")");
                }
                return null;
            }
        } else {
            String sign;
            if (context instanceof PsiPostfixExpression) {
                sign = ((PsiPostfixExpression)context).getOperationSign().getText();
                return new TypeConversionDescriptor("$qualifier$" + sign, "$qualifier$.getAndSet(" + AtomicConversionRule.getBoxedWrapper(from, to, "$qualifier$.get() " + sign.charAt(0) + " 1") + ")");
            }
            if (context instanceof PsiPrefixExpression) {
                operationSign = ((PsiPrefixExpression)context).getOperationSign();
                if (operationSign.getTokenType() == JavaTokenType.EXCL) {
                    return new TypeConversionDescriptor("!$qualifier$", "!$qualifier$.get()");
                }
                String sign2 = operationSign.getText();
                return new TypeConversionDescriptor(sign2 + "$qualifier$", "$qualifier$.set(" + AtomicConversionRule.getBoxedWrapper(from, to, "$qualifier$.get() " + sign2.charAt(0) + " 1") + ")");
            }
            if (context instanceof PsiBinaryExpression) {
                sign = ((PsiBinaryExpression)context).getOperationSign().getText();
                return new TypeConversionDescriptor("$qualifier$" + sign + "$val$", "$qualifier$.get() " + sign + " $val$");
            }
        }
        if (parent instanceof PsiVariable) {
            return AtomicConversionRule.wrapWithNewExpression(to, from, null, parent);
        }
        return null;
    }

    public static TypeConversionDescriptor wrapWithNewExpression(PsiType to, PsiType from, @Nullable PsiExpression expression, PsiElement context) {
        PsiType initial;
        PsiPrimitiveType unboxedInitialType;
        String typeText = PsiDiamondTypeUtil.getCollapsedType((PsiType)to, (PsiElement)context);
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)to);
        PsiClass atomicClass = resolveResult.getElement();
        LOG.assertTrue(atomicClass != null);
        PsiTypeParameter[] typeParameters = atomicClass.getTypeParameters();
        if (typeParameters.length == 1 && (unboxedInitialType = PsiPrimitiveType.getUnboxedType((PsiType)(initial = resolveResult.getSubstitutor().substitute(typeParameters[0])))) != null) {
            LOG.assertTrue(initial != null);
            if (from instanceof PsiPrimitiveType) {
                PsiClassType boxedFromType = ((PsiPrimitiveType)from).getBoxedType((PsiElement)atomicClass);
                LOG.assertTrue(boxedFromType != null);
                if (!TypeConversionUtil.isAssignable((PsiType)initial, (PsiType)boxedFromType)) {
                    return new TypeConversionDescriptor("$val$", "new " + typeText + "((" + unboxedInitialType.getCanonicalText() + ")$val$)", expression);
                }
            }
        }
        return new TypeConversionDescriptor("$val$", "new " + typeText + "($val$)", expression);
    }

    @Nullable
    private static TypeConversionDescriptor findDirectConversionForAtomicReferenceArray(PsiElement context, PsiType to, PsiType from) {
        LOG.assertTrue(from instanceof PsiArrayType);
        from = ((PsiArrayType)from).getComponentType();
        PsiElement parent = context.getParent();
        PsiElement parentParent = parent.getParent();
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            IElementType operationSign = assignmentExpression.getOperationTokenType();
            String sign = assignmentExpression.getOperationSign().getText();
            if (context instanceof PsiArrayAccessExpression) {
                if (parentParent instanceof PsiExpressionStatement && assignmentExpression.getLExpression() == context) {
                    if (operationSign == JavaTokenType.EQ) {
                        return new TypeConversionDescriptor("$qualifier$[$idx$] = $val$", "$qualifier$.set($idx$, $val$)", (PsiExpression)assignmentExpression);
                    }
                    return new TypeConversionDescriptor("$qualifier$[$idx$]" + sign + "$val$", "$qualifier$.set($idx$, " + AtomicConversionRule.getBoxedWrapper(from, to, "$qualifier$.get($idx$) " + sign.charAt(0) + " $val$") + ")", (PsiExpression)assignmentExpression);
                }
            } else {
                PsiExpression rExpression = assignmentExpression.getRExpression();
                if (rExpression == context && operationSign == JavaTokenType.EQ) {
                    return AtomicConversionRule.wrapWithNewExpression(to, from, rExpression, context);
                }
            }
        } else if (parent instanceof PsiVariable && ((PsiVariable)parent).getInitializer() == context) {
            return AtomicConversionRule.wrapWithNewExpression(to, from, (PsiExpression)context, context);
        }
        if (parentParent instanceof PsiExpressionStatement) {
            String sign;
            if (parent instanceof PsiPostfixExpression) {
                sign = ((PsiPostfixExpression)parent).getOperationSign().getText();
                return new TypeConversionDescriptor("$qualifier$[$idx$]" + sign, "$qualifier$.getAndSet($idx$, " + AtomicConversionRule.getBoxedWrapper(from, to, "$qualifier$.get($idx$) " + sign.charAt(0) + " 1") + ")", (PsiExpression)parent);
            }
            if (parent instanceof PsiPrefixExpression) {
                sign = ((PsiPrefixExpression)parent).getOperationSign().getText();
                return new TypeConversionDescriptor(sign + "$qualifier$[$idx$]", "$qualifier$.set($idx$, " + AtomicConversionRule.getBoxedWrapper(from, to, "$qualifier$.get($idx$) " + sign.charAt(0) + " 1") + ")", (PsiExpression)parent);
            }
            if (parent instanceof PsiBinaryExpression) {
                sign = ((PsiBinaryExpression)parent).getOperationSign().getText();
                return new TypeConversionDescriptor("$qualifier$[$idx$]" + sign + "$val$", "$qualifier$.set($idx$, " + AtomicConversionRule.getBoxedWrapper(from, to, "$qualifier$.get($idx$) " + sign + " $val$)") + ")", (PsiExpression)parent);
            }
        }
        if (context instanceof PsiArrayAccessExpression) {
            return new TypeConversionDescriptor("$qualifier$[$idx$]", "$qualifier$.get($idx$)", (PsiExpression)context);
        }
        return null;
    }

    private static String getBoxedWrapper(PsiType from, PsiType to, @NotNull String arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/intellij/refactoring/typeMigration/rules/AtomicConversionRule", "getBoxedWrapper"));
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)to);
        PsiClass atomicClass = resolveResult.getElement();
        LOG.assertTrue(atomicClass != null);
        PsiTypeParameter[] typeParameters = atomicClass.getTypeParameters();
        if (typeParameters.length == 1) {
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            LOG.assertTrue(substitutor.isValid());
            PsiType initial = substitutor.substitute(typeParameters[0]);
            PsiPrimitiveType unboxedInitialType = PsiPrimitiveType.getUnboxedType((PsiType)initial);
            if (unboxedInitialType != null) {
                LOG.assertTrue(initial != null);
                if (from instanceof PsiPrimitiveType) {
                    PsiClassType boxedFromType = ((PsiPrimitiveType)from).getBoxedType((PsiElement)atomicClass);
                    LOG.assertTrue(boxedFromType != null);
                    return "new " + initial.getPresentableText() + "((" + unboxedInitialType.getCanonicalText() + ")(" + arg + "))";
                }
            }
        }
        return arg;
    }

    @Nullable
    private static TypeConversionDescriptor findReverseConversion(PsiElement context) {
        if (context instanceof PsiReferenceExpression) {
            if (context.getParent() instanceof PsiMethodCallExpression) {
                return AtomicConversionRule.findReverseConversionForMethodCall(context);
            }
        } else {
            if (context instanceof PsiNewExpression) {
                return new TypeConversionDescriptor("new $type$($qualifier$)", "$qualifier$");
            }
            if (context instanceof PsiMethodCallExpression) {
                return AtomicConversionRule.findReverseConversionForMethodCall((PsiElement)((PsiMethodCallExpression)context).getMethodExpression());
            }
        }
        return null;
    }

    @Nullable
    private static TypeConversionDescriptor findReverseConversionForMethodCall(PsiElement context) {
        PsiElement resolved = ((PsiReferenceExpression)context).resolve();
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            int parametersCount = method.getParameterList().getParametersCount();
            String resolvedName = method.getName();
            if (Comparing.strEqual((String)resolvedName, (String)"get")) {
                return parametersCount == 0 ? new TypeConversionDescriptor("$qualifier$.get()", "$qualifier$") : new TypeConversionDescriptor("$qualifier$.get($idx$)", "$qualifier$[$idx$]");
            }
            if (Comparing.strEqual((String)resolvedName, (String)"set")) {
                return parametersCount == 1 ? new TypeConversionDescriptor("$qualifier$.set($val$)", "$qualifier$ = $val$") : new TypeConversionDescriptor("$qualifier$.set($idx$, $val$)", "$qualifier$[$idx$] = $val$");
            }
            if (Comparing.strEqual((String)resolvedName, (String)"addAndGet")) {
                return parametersCount == 1 ? new TypeConversionDescriptor("$qualifier$.addAndGet($delta$)", "$qualifier$ + $delta$") : new TypeConversionDescriptor("$qualifier$.addAndGet($idx$, $delta$)", "$qualifier$[$idx$] + $delta$");
            }
            if (Comparing.strEqual((String)resolvedName, (String)"incrementAndGet")) {
                return parametersCount == 0 ? new TypeConversionDescriptor("$qualifier$.incrementAndGet()", "++$qualifier$") : new TypeConversionDescriptor("$qualifier$.incrementAndGet($idx$)", "++$qualifier$[$idx$]");
            }
            if (Comparing.strEqual((String)resolvedName, (String)"decrementAndGet")) {
                return parametersCount == 0 ? new TypeConversionDescriptor("$qualifier$.decrementAndGet()", "--$qualifier$") : new TypeConversionDescriptor("$qualifier$.decrementAndGet($idx$)", "--$qualifier$[$idx$]");
            }
            if (Comparing.strEqual((String)resolvedName, (String)"getAndIncrement")) {
                return parametersCount == 0 ? new TypeConversionDescriptor("$qualifier$.getAndIncrement()", "$qualifier$++") : new TypeConversionDescriptor("$qualifier$.getAndIncrement($idx$)", "$qualifier$[$idx$]++");
            }
            if (Comparing.strEqual((String)resolvedName, (String)"getAndDecrement")) {
                return parametersCount == 0 ? new TypeConversionDescriptor("$qualifier$.getAndDecrement()", "$qualifier$--") : new TypeConversionDescriptor("$qualifier$.getAndDecrement($idx$)", "$qualifier$[$idx$]--");
            }
            if (Comparing.strEqual((String)resolvedName, (String)"getAndAdd")) {
                return parametersCount == 1 ? new TypeConversionDescriptor("$qualifier$.getAndAdd($val$)", "$qualifier$ += $val$") : new TypeConversionDescriptor("$qualifier$.getAndAdd($idx$, $val$)", "$qualifier$[$idx$] += $val$");
            }
            if (Comparing.strEqual((String)resolvedName, (String)"getAndSet")) {
                return parametersCount == 1 ? new TypeConversionDescriptor("$qualifier$.getAndSet($val$)", "$qualifier$ = $val$") : new TypeConversionDescriptor("$qualifier$.getAndSet($idx$, $val$)", "$qualifier$[$idx$] = $val$");
            }
        }
        return null;
    }
}

