/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.Named;
import com.intellij.zkm.bytecode.Signature;
import com.intellij.zkm.bytecode.Type;
import com.intellij.zkm.bytecode.Utilities;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class Invocation {
    private final Type myOwnerType;
    private final Type myReturnType;
    private final String myName;
    private final List<Type> myParameterTypes;

    Invocation(@NotNull Type ownerType, @NotNull Type returnType, @NotNull String name, @NotNull List<Type> parameterTypes) {
        if (ownerType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerType", "com/intellij/zkm/bytecode/Invocation", "<init>"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/intellij/zkm/bytecode/Invocation", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/zkm/bytecode/Invocation", "<init>"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "com/intellij/zkm/bytecode/Invocation", "<init>"));
        }
        this.myOwnerType = ownerType;
        this.myReturnType = returnType;
        this.myName = name;
        this.myParameterTypes = parameterTypes;
    }

    boolean conforms(String methodName) {
        return this.myName.equals(methodName);
    }

    boolean conforms(Signature signature) {
        return this.myReturnType.conforms(signature.getReturnType()) && this.myName.equals(signature.getName()) && Type.conforms(this.myParameterTypes, signature.getParameterTypes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invocation that = (Invocation)o;
        if (!this.myOwnerType.equals(that.myOwnerType)) {
            return false;
        }
        if (!this.myReturnType.equals(that.myReturnType)) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        return this.myParameterTypes.equals(that.myParameterTypes);
    }

    public int hashCode() {
        int result = this.myOwnerType.hashCode();
        result = 31 * result + this.myReturnType.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + this.myParameterTypes.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s %s.%s(%s)", this.myReturnType, this.myOwnerType, this.myName, Utilities.join(Named.namesOf(this.myParameterTypes)));
    }
}

