/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.metadata.RelaxedNames;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyLookupElementBuilder;
import com.intellij.spring.boot.application.metadata.SpringBootConfigurationMetadataParser;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationMetaConfigKeyImpl
implements SpringBootApplicationMetaConfigKey {
    private final PsiElement myDeclaration;
    private final String myName;
    private final SpringBootApplicationMetaConfigKey.DescriptionText myDescriptionText;
    private final String myDefaultValue;
    private final SpringBootApplicationMetaConfigKey.Deprecation myDeprecation;
    private final PsiType myType;
    private final SpringBootApplicationMetaConfigKey.ItemHint myItemHint;
    private final SpringBootApplicationMetaConfigKey.ItemHint myKeyItemHint;
    private final SpringBootApplicationMetaConfigKey.AccessType myAccessType;
    private final PsiClass myEffectiveValueClass;
    @Nullable
    private final PsiClass myMapKeyType;
    @Nullable
    private final PsiClassType myMapValueType;
    private final SpringBootApplicationMetaConfigKey.MetaConfigKeyPresentation myPresentation;
    private final VolatileNotNullLazyValue<RelaxedNames> myRelaxedNames;

    public SpringBootApplicationMetaConfigKeyImpl(@NotNull PsiElement declaration, @NotNull String name, @NotNull SpringBootApplicationMetaConfigKey.DescriptionText descriptionText, @Nullable String defaultValue, @NotNull SpringBootApplicationMetaConfigKey.Deprecation deprecation, @Nullable PsiType type, @NotNull SpringBootApplicationMetaConfigKey.AccessType accessType, @NotNull SpringBootApplicationMetaConfigKey.ItemHint itemHint, @NotNull SpringBootApplicationMetaConfigKey.ItemHint keyItemHint) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "<init>"));
        }
        if (descriptionText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionText", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "<init>"));
        }
        if (deprecation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deprecation", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "<init>"));
        }
        if (accessType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessType", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "<init>"));
        }
        if (itemHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemHint", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "<init>"));
        }
        if (keyItemHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyItemHint", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "<init>"));
        }
        this.myPresentation = new SpringBootApplicationMetaConfigKey.MetaConfigKeyPresentation(){

            @NotNull
            public Icon getIcon() {
                switch (SpringBootApplicationMetaConfigKeyImpl.this.myAccessType) {
                    case INDEXED: {
                        Icon icon = AllIcons.Nodes.PropertyRead;
                        if (icon == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl$1", "getIcon"));
                        }
                        return icon;
                    }
                    case MAP: {
                        Icon icon = AllIcons.Nodes.PropertyWrite;
                        if (icon == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl$1", "getIcon"));
                        }
                        return icon;
                    }
                    case ENUM_MAP: {
                        Icon icon = AllIcons.Nodes.PropertyWriteStatic;
                        if (icon == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl$1", "getIcon"));
                        }
                        return icon;
                    }
                }
                Icon icon = AllIcons.Nodes.Property;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl$1", "getIcon"));
                }
                return icon;
            }

            public LookupElementBuilder getLookupElement() {
                return this.getLookupElement(SpringBootApplicationMetaConfigKeyImpl.this.getName());
            }

            public LookupElementBuilder getLookupElement(String lookupString) {
                return SpringBootApplicationMetaConfigKeyLookupElementBuilder.create(SpringBootApplicationMetaConfigKeyImpl.this, lookupString);
            }

            public LookupElement tuneLookupElement(LookupElement lookupElement) {
                if (SpringBootApplicationMetaConfigKeyImpl.this.getDeprecation() != SpringBootApplicationMetaConfigKey.Deprecation.NOT_DEPRECATED) {
                    return PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)-1.0);
                }
                return lookupElement;
            }
        };
        this.myRelaxedNames = new VolatileNotNullLazyValue<RelaxedNames>(){

            @NotNull
            protected RelaxedNames compute() {
                int lastDotIdx = SpringBootApplicationMetaConfigKeyImpl.this.myName.lastIndexOf(46);
                if (lastDotIdx == -1) {
                    RelaxedNames relaxedNames = new RelaxedNames(SpringBootApplicationMetaConfigKeyImpl.this.myName);
                    if (relaxedNames == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl$2", "compute"));
                    }
                    return relaxedNames;
                }
                String propertyName = SpringBootConfigurationMetadataParser.dashedPropertyNameToCamelCase(SpringBootApplicationMetaConfigKeyImpl.this.myName);
                String replace = SpringBootApplicationMetaConfigKeyImpl.this.myName.substring(0, lastDotIdx + 1) + propertyName;
                RelaxedNames relaxedNames = new RelaxedNames(replace);
                if (relaxedNames == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl$2", "compute"));
                }
                return relaxedNames;
            }
        };
        this.myDeclaration = declaration;
        assert (!name.isEmpty());
        this.myName = name;
        this.myDescriptionText = descriptionText;
        this.myDefaultValue = defaultValue;
        this.myDeprecation = deprecation;
        this.myType = type;
        this.myItemHint = itemHint;
        this.myKeyItemHint = keyItemHint;
        if (accessType == SpringBootApplicationMetaConfigKey.AccessType.MAP) {
            this.myMapKeyType = PsiTypesUtil.getPsiClass((PsiType)this.getMapTypeParameter(0));
            this.myMapValueType = this.getMapTypeParameter(1);
            boolean isEnumMapKeyType = this.myMapKeyType != null && this.myMapKeyType.isEnum();
            this.myAccessType = isEnumMapKeyType ? SpringBootApplicationMetaConfigKey.AccessType.ENUM_MAP : accessType;
        } else {
            this.myMapKeyType = null;
            this.myMapValueType = null;
            this.myAccessType = accessType;
        }
        this.myEffectiveValueClass = this.calcEffectiveValueClass();
    }

    @Nullable
    private PsiClass calcEffectiveValueClass() {
        switch (this.myAccessType) {
            case INDEXED: {
                if (this.myType instanceof PsiArrayType) {
                    PsiArrayType arrayType = (PsiArrayType)this.myType;
                    return PsiTypesUtil.getPsiClass((PsiType)arrayType.getComponentType());
                }
                PsiType parameter = this.getParameter(0);
                return PsiTypesUtil.getPsiClass((PsiType)parameter);
            }
            case MAP: 
            case ENUM_MAP: {
                return PsiTypesUtil.getPsiClass((PsiType)this.getMapValueType());
            }
        }
        return PsiTypesUtil.getPsiClass((PsiType)this.myType);
    }

    @Nullable
    private PsiClassType getMapTypeParameter(int index) {
        PsiType parameterType = this.getParameter(index);
        if (!(parameterType instanceof PsiClassType)) {
            return null;
        }
        return (PsiClassType)parameterType;
    }

    @Nullable
    private PsiType getParameter(int index) {
        PsiType[] parameters = ((PsiClassType)this.myType).getParameters();
        if (parameters.length < index + 1) {
            return null;
        }
        return parameters[index];
    }

    @NotNull
    public PsiElement getDeclaration() {
        PsiElement psiElement = this.myDeclaration;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "getDeclaration"));
        }
        return psiElement;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public SpringBootApplicationMetaConfigKey.Deprecation getDeprecation() {
        SpringBootApplicationMetaConfigKey.Deprecation deprecation = this.myDeprecation;
        if (deprecation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "getDeprecation"));
        }
        return deprecation;
    }

    @NotNull
    public SpringBootApplicationMetaConfigKey.DescriptionText getDescriptionText() {
        SpringBootApplicationMetaConfigKey.DescriptionText descriptionText = this.myDescriptionText;
        if (descriptionText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "getDescriptionText"));
        }
        return descriptionText;
    }

    @Nullable
    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    @Nullable
    public PsiClass getEffectiveValueClass() {
        return this.myEffectiveValueClass;
    }

    public boolean isAccessType(SpringBootApplicationMetaConfigKey.AccessType ... types) {
        for (SpringBootApplicationMetaConfigKey.AccessType type : types) {
            if (type != this.myAccessType) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public PsiClass getMapKeyType() {
        return this.myMapKeyType;
    }

    @Nullable
    public PsiClassType getMapValueType() {
        return this.myMapValueType;
    }

    @Nullable
    public PsiType getType() {
        return this.myType;
    }

    @NotNull
    public SpringBootApplicationMetaConfigKey.ItemHint getItemHint() {
        SpringBootApplicationMetaConfigKey.ItemHint itemHint = this.myItemHint;
        if (itemHint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "getItemHint"));
        }
        return itemHint;
    }

    @NotNull
    public SpringBootApplicationMetaConfigKey.ItemHint getKeyItemHint() {
        SpringBootApplicationMetaConfigKey.ItemHint itemHint = this.myKeyItemHint;
        if (itemHint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "getKeyItemHint"));
        }
        return itemHint;
    }

    @NotNull
    public SpringBootApplicationMetaConfigKey.MetaConfigKeyPresentation getPresentation() {
        SpringBootApplicationMetaConfigKey.MetaConfigKeyPresentation metaConfigKeyPresentation = this.myPresentation;
        if (metaConfigKeyPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "getPresentation"));
        }
        return metaConfigKeyPresentation;
    }

    public boolean matches(@NotNull String configKey) {
        if (configKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configKey", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "matches"));
        }
        if (!this.matchesFirstChar(configKey)) {
            return false;
        }
        if (this.myName.equalsIgnoreCase(configKey)) {
            return true;
        }
        switch (this.myAccessType) {
            case MAP: 
            case ENUM_MAP: {
                return this.matchesMapType(configKey);
            }
            case INDEXED: {
                return this.matchesIndexedType(configKey);
            }
        }
        return this.matchesRelaxed(configKey);
    }

    public boolean matchesPrefix(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "matchesPrefix"));
        }
        if (!this.matchesFirstChar(prefix)) {
            return false;
        }
        if (StringUtil.startsWith((CharSequence)this.myName, (CharSequence)prefix)) {
            return true;
        }
        for (String value : ((RelaxedNames)this.myRelaxedNames.getValue()).getValues()) {
            if (!value.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesFirstChar(@NotNull String configKey) {
        if (configKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configKey", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "matchesFirstChar"));
        }
        return !configKey.isEmpty() && StringUtil.charsEqualIgnoreCase((char)this.myName.charAt(0), (char)configKey.charAt(0));
    }

    private boolean matchesMapType(String configKey) {
        int mapKeyIndex = configKey.lastIndexOf(46);
        if (mapKeyIndex == -1) {
            return false;
        }
        String mapPropertyName = configKey.substring(0, mapKeyIndex);
        if (this.myName.equalsIgnoreCase(mapPropertyName) || this.matchesRelaxed(mapPropertyName)) {
            return true;
        }
        String multiDotKey = configKey.substring(0, StringUtil.commonPrefixLength((CharSequence)this.myName, (CharSequence)configKey));
        return this.myName.equals(multiDotKey);
    }

    private boolean matchesIndexedType(String configKey) {
        int indexKeyIndex = configKey.indexOf(91);
        String propertyName = indexKeyIndex != -1 ? configKey.substring(0, indexKeyIndex) : configKey;
        return this.myName.equalsIgnoreCase(propertyName) || this.matchesRelaxed(propertyName);
    }

    private boolean matchesRelaxed(String configKey) {
        return ((RelaxedNames)this.myRelaxedNames.getValue()).getValues().contains(configKey);
    }

    public String toString() {
        return "SpringBootApplicationMetaConfigKey{myName='" + this.myName + '\'' + ", myDescriptionText='" + this.myDescriptionText + '\'' + ", myDefaultValue='" + this.myDefaultValue + '\'' + ", myDeprecation=" + this.myDeprecation + ", myType=" + this.myType + ", myAccessType=" + this.myAccessType + ", myMapKeyType=" + this.myMapKeyType + ", myMapValueType=" + this.myMapValueType + ", myItemHint=" + this.myItemHint + ", myKeyItemHint=" + this.myKeyItemHint + '}';
    }
}

