/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.json.psi.JsonFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.metadata.SpringBootConfigurationMetadataParser;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationMetaConfigKeyManagerImpl
extends SpringBootApplicationMetaConfigKeyManager
implements StartupActivity {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "runActivity"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        CompilerManager.getInstance((Project)project).addAfterTask(context -> {
            boolean projectHasSpringBoot;
            if (!context.isAnnotationProcessorsEnabled()) {
                return true;
            }
            DumbService dumbService = DumbService.getInstance((Project)context.getProject());
            boolean bl = projectHasSpringBoot = dumbService.isDumb() || (Boolean)dumbService.runReadActionInSmartMode(() -> SpringBootLibraryUtil.hasSpringBootLibrary(context.getProject())) != false;
            if (!projectHasSpringBoot) {
                return true;
            }
            for (Module module : context.getCompileScope().getAffectedModules()) {
                boolean hasAnnotationProcessor;
                boolean bl2 = hasAnnotationProcessor = dumbService.isDumb() || (Boolean)dumbService.runReadActionInSmartMode(() -> SpringBootLibraryUtil.hasConfigurationMetadataAnnotationProcessor(module)) != false;
                if (!hasAnnotationProcessor) continue;
                DaemonCodeAnalyzer.getInstance((Project)context.getProject()).restart();
                break;
            }
            return true;
        });
    }

    public List<SpringBootApplicationMetaConfigKey> getAllMetaConfigKeys(@Nullable Module module) {
        if (!SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return Collections.emptyList();
        }
        List fromLibraries = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            List metaInfConfigFiles = SpringCommonUtils.findConfigFilesInMetaInf((Module)module, (boolean)false, (String)"spring-configuration-metadata.json", JsonFile.class);
            ArrayList allKeys = new ArrayList();
            for (JsonFile configMetadataFile : metaInfConfigFiles) {
                ArrayList keys = new ArrayList();
                Processor collect = Processors.cancelableCollectProcessor(keys);
                SpringBootConfigurationMetadataParser parser = new SpringBootConfigurationMetadataParser(configMetadataFile);
                parser.processKeys((Processor<SpringBootApplicationMetaConfigKey>)collect);
                allKeys.addAll(keys);
            }
            ArrayList<ProjectRootManager> allDependencies = new ArrayList<ProjectRootManager>(metaInfConfigFiles);
            allDependencies.add(ProjectRootManager.getInstance((Project)module.getProject()));
            return CachedValueProvider.Result.create(allKeys, allDependencies);
        });
        List<SpringBootApplicationMetaConfigKey> localKeys = SpringBootApplicationMetaConfigKeyManagerImpl.getLocalMetaConfigKeys(module);
        return ContainerUtil.concat((List)fromLibraries, localKeys);
    }

    private static List<SpringBootApplicationMetaConfigKey> getLocalMetaConfigKeys(Module localModule) {
        return (List)CachedValuesManager.getManager((Project)localModule.getProject()).getCachedValue((UserDataHolder)localModule, () -> {
            HashSet allModules = new HashSet();
            ModuleUtilCore.getDependencies((Module)localModule, (Set)allModules);
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            if (ContainerUtil.process((Iterable)allModules, module -> !SpringBootLibraryUtil.hasConfigurationMetadataAnnotationProcessor(module))) {
                Key libraryCheckDependency = unitTestMode ? PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT : ProjectRootManager.getInstance((Project)localModule.getProject());
                return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{libraryCheckDependency});
            }
            ArrayList allKeys = new ArrayList();
            for (Module module2 : allModules) {
                File localJsonFile = SpringBootApplicationMetaConfigKeyManagerImpl.findLocalMetadataJsonFile(module2, unitTestMode);
                if (localJsonFile == null) continue;
                ArrayList keys = new ArrayList();
                Processor collect = Processors.cancelableCollectProcessor(keys);
                SpringBootConfigurationMetadataParser parser = new SpringBootConfigurationMetadataParser(module2, localJsonFile);
                parser.processKeys((Processor<SpringBootApplicationMetaConfigKey>)collect);
                allKeys.addAll(keys);
            }
            return CachedValueProvider.Result.create(allKeys, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    private static File findLocalMetadataJsonFile(Module module, boolean unitTestMode) {
        if (!unitTestMode) {
            String outputDir = CompilerPaths.getModuleOutputPath((Module)module, (boolean)false);
            if (outputDir == null) {
                return null;
            }
            String metadataJsonPath = outputDir + "/META-INF/" + "spring-configuration-metadata.json";
            File localJsonFile = new File(metadataJsonPath);
            if (!localJsonFile.exists()) {
                return null;
            }
            return localJsonFile;
        }
        VirtualFile tempFSVirtualFile = TempFileSystem.getInstance().findFileByPath("/src/spring-configuration-metadata.json");
        if (tempFSVirtualFile == null) {
            return null;
        }
        try {
            File localJsonFile = FileUtil.createTempFile((String)"sb-test", (String)"whatever", (boolean)true);
            FileUtil.writeToFile((File)localJsonFile, (String)VfsUtilCore.loadText((VirtualFile)tempFSVirtualFile));
            return localJsonFile;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nullable
    public SpringBootApplicationMetaConfigKey findApplicationMetaConfigKey(@Nullable Module module, @Nullable String configKey) {
        return this.findApplicationMetaConfigKey(module, (Condition<SpringBootApplicationMetaConfigKey>)Conditions.alwaysTrue(), configKey);
    }

    @Nullable
    public SpringBootApplicationMetaConfigKey findApplicationMetaConfigKey(@Nullable Module module, @NotNull Condition<SpringBootApplicationMetaConfigKey> additionalCondition, @Nullable String configKey) {
        List matchingKeys;
        if (additionalCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalCondition", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "findApplicationMetaConfigKey"));
        }
        if (configKey == null || module == null) {
            return null;
        }
        List allKeys = this.getAllMetaConfigKeys(module);
        List list = matchingKeys = additionalCondition == Condition.TRUE ? allKeys : ContainerUtil.filter(allKeys, additionalCondition);
        if (matchingKeys.isEmpty()) {
            return null;
        }
        SpringBootApplicationMetaConfigKey exact = (SpringBootApplicationMetaConfigKey)ContainerUtil.find((Iterable)matchingKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createStrictConfigKeyCondition(configKey));
        if (exact != null) {
            return exact;
        }
        return (SpringBootApplicationMetaConfigKey)ContainerUtil.find((Iterable)matchingKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createRelaxedConfigKeyCondition(configKey));
    }

    @NotNull
    public List<SpringBootApplicationMetaConfigKey> findAllApplicationMetaConfigKeys(PsiElement psiElement, @Nullable String configKey) {
        if (configKey == null) {
            List<SpringBootApplicationMetaConfigKey> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "findAllApplicationMetaConfigKeys"));
            }
            return list;
        }
        List allKeys = this.getAllMetaConfigKeys(psiElement);
        if (allKeys.isEmpty()) {
            List<SpringBootApplicationMetaConfigKey> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "findAllApplicationMetaConfigKeys"));
            }
            return list;
        }
        List exact = ContainerUtil.findAll((Collection)allKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createStrictConfigKeyCondition(configKey));
        if (!exact.isEmpty()) {
            List list = exact;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "findAllApplicationMetaConfigKeys"));
            }
            return list;
        }
        List list = ContainerUtil.findAll((Collection)allKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createRelaxedConfigKeyCondition(configKey));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "findAllApplicationMetaConfigKeys"));
        }
        return list;
    }

    @NotNull
    private static Condition<SpringBootApplicationMetaConfigKey> createStrictConfigKeyCondition(@Nullable String configKey) {
        Condition condition = key -> key.getName().equals(configKey);
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "createStrictConfigKeyCondition"));
        }
        return condition;
    }

    private static Condition<SpringBootApplicationMetaConfigKey> createRelaxedConfigKeyCondition(String configKey) {
        return key -> key.matches(configKey);
    }
}

