/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.google.common.collect.Sets;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.idea.stubindex.StaticFacadeIndexUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.CompositeBindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J,\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013J8\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00182\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0013J.\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J.\u0010'\u001a\u0004\u0018\u00010\u001a2\u0006\u0010#\u001a\u00020$2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020&0\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0005J(\u0010)\u001a\u0004\u0018\u00010\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010*\u001a\u00020&2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0005J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020-H\u0002J@\u0010.\u001a\n\u0012\u0004\u0012\u0002H/\u0018\u00010\u0014\"\u0004\b\u0000\u00100\"\u0004\b\u0001\u0010/*\b\u0012\u0004\u0012\u0002H00\u00142\u0018\u00101\u001a\u0014\u0012\u0004\u0012\u0002H0\u0012\n\u0012\b\u0012\u0004\u0012\u0002H/0\u001402H\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/DebuggerUtils;", "", "()V", "KOTLIN_EXTENSIONS", "Ljava/util/HashSet;", "", "kotlin.jvm.PlatformType", "analyzeElementWithInline", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "bindingContext", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "deep", "", "analyzedElements", "", "analyzeInlineFunctions", "", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "analyzeInlinedFunctions", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "resolutionFacadeForFile", "bindingContextForFile", "file", "analyzeOnlyReifiedInlineFunctions", "findFilesByNameInPackage", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "fileName", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findSourceFileForClass", "scopes", "findSourceFileForClassIncludeLibrarySources", "scope", "hasReifiedTypeParameters", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "findFirstNotEmpty", "R", "T", "predicate", "Lkotlin/Function1;", "idea"})
public final class DebuggerUtils {
    private static final HashSet<String> KOTLIN_EXTENSIONS;
    public static final DebuggerUtils INSTANCE;

    @Nullable
    public final KtFile findSourceFileForClassIncludeLibrarySources(@NotNull Project project, @NotNull GlobalSearchScope scope2, @NotNull JvmClassName className2, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return (KtFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtFile>(project, scope2, className2, fileName){
            final /* synthetic */ Project $project;
            final /* synthetic */ GlobalSearchScope $scope;
            final /* synthetic */ JvmClassName $className;
            final /* synthetic */ String $fileName;

            @Nullable
            public final KtFile invoke() {
                Object[] objectArray = new GlobalSearchScope[2];
                objectArray[0] = this.$scope;
                GlobalSearchScope globalSearchScope = KotlinSourceFilterScope.librarySources(GlobalSearchScope.allScope((Project)this.$project), this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"KotlinSourceFilterScope.\u2026lScope(project), project)");
                objectArray[1] = globalSearchScope;
                return DebuggerUtils.INSTANCE.findSourceFileForClass(this.$project, CollectionsKt.listOf((Object[])objectArray), this.$className, this.$fileName);
            }
            {
                this.$project = project;
                this.$scope = globalSearchScope;
                this.$className = jvmClassName;
                this.$fileName = string;
                super(0);
            }
        });
    }

    @Nullable
    public final KtFile findSourceFileForClass(@NotNull Project project, @NotNull List<? extends GlobalSearchScope> scopes, @NotNull JvmClassName className2, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(scopes, (String)"scopes");
        Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        String extension = FileUtilRt.getExtension((String)fileName);
        if (!KOTLIN_EXTENSIONS.contains(extension)) {
            return null;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            return null;
        }
        Collection collection = this.findFirstNotEmpty((Collection)scopes, (Function1)new Function1<GlobalSearchScope, List<? extends KtFile>>(className2, fileName, project){
            final /* synthetic */ JvmClassName $className;
            final /* synthetic */ String $fileName;
            final /* synthetic */ Project $project;

            @NotNull
            public final List<KtFile> invoke(@NotNull GlobalSearchScope it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return DebuggerUtils.access$findFilesByNameInPackage(DebuggerUtils.INSTANCE, this.$className, this.$fileName, this.$project, it);
            }
            {
                this.$className = jvmClassName;
                this.$fileName = string;
                this.$project = project;
                super(1);
            }
        });
        if (collection == null) {
            return null;
        }
        Collection filesWithExactName2 = collection;
        if (filesWithExactName2.isEmpty()) {
            return null;
        }
        if (filesWithExactName2.size() == 1) {
            return (KtFile)CollectionsKt.single((Iterable)filesWithExactName2);
        }
        FqName partFqName = className2.getFqNameForClassNameWithoutDollars();
        Collection collection2 = this.findFirstNotEmpty((Collection)scopes, (Function1)new Function1<GlobalSearchScope, Collection<? extends KtFile>>(partFqName, project){
            final /* synthetic */ FqName $partFqName;
            final /* synthetic */ Project $project;

            @NotNull
            public final Collection<KtFile> invoke(@NotNull GlobalSearchScope it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                FqName fqName2 = this.$partFqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"partFqName");
                return StaticFacadeIndexUtil.findFilesForFilePart(fqName2, it, this.$project);
            }
            {
                this.$partFqName = fqName2;
                this.$project = project;
                super(1);
            }
        });
        if (collection2 == null) {
            return null;
        }
        Collection filesForPart2 = collection2;
        if (!filesForPart2.isEmpty()) {
            for (KtFile file2 : filesForPart2) {
                if (!Intrinsics.areEqual((Object)file2.getName(), (Object)fileName)) continue;
                return file2;
            }
            return null;
        }
        return (KtFile)CollectionsKt.first((Iterable)filesWithExactName2);
    }

    private final <T, R> Collection<R> findFirstNotEmpty(@NotNull Collection<? extends T> $receiver, Function1<? super T, ? extends Collection<? extends R>> predicate) {
        Collection result2 = CollectionsKt.emptyList();
        for (T e : $receiver) {
            Collection collection = result2 = (Collection)predicate.invoke(e);
            if (!(!collection.isEmpty())) continue;
            break;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtFile> findFilesByNameInPackage(JvmClassName className2, String fileName, Project project, GlobalSearchScope searchScope) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        FqName fqName2 = className2.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"className.packageFqName");
        Iterable iterable = PackageIndexUtil.findFilesWithExactPackage(fqName2, searchScope, project);
        void var6_6 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Pair<BindingContext, List<KtFile>> analyzeInlinedFunctions(@NotNull ResolutionFacade resolutionFacadeForFile, @NotNull BindingContext bindingContextForFile, @NotNull KtFile file2, boolean analyzeOnlyReifiedInlineFunctions) {
        Intrinsics.checkParameterIsNotNull((Object)resolutionFacadeForFile, (String)"resolutionFacadeForFile");
        Intrinsics.checkParameterIsNotNull((Object)bindingContextForFile, (String)"bindingContextForFile");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        HashSet analyzedElements = new HashSet();
        BindingContext context = this.analyzeElementWithInline(resolutionFacadeForFile, bindingContextForFile, file2, 1, analyzedElements, !analyzeOnlyReifiedInlineFunctions);
        LinkedHashSet<KtFile> toProcess = new LinkedHashSet<KtFile>();
        toProcess.add(file2);
        for (KtElement collectedElement : analyzedElements) {
            KtFile containingFile = collectedElement.getContainingKtFile();
            toProcess.add(containingFile);
        }
        return new Pair((Object)context, new ArrayList(toProcess));
    }

    @NotNull
    public final Collection<KtElement> analyzeElementWithInline(@NotNull ResolutionFacade resolutionFacade2, @NotNull BindingContext bindingContext2, @NotNull KtNamedFunction function2, boolean analyzeInlineFunctions) {
        Intrinsics.checkParameterIsNotNull((Object)resolutionFacade2, (String)"resolutionFacade");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        HashSet analyzedElements = new HashSet();
        this.analyzeElementWithInline(resolutionFacade2, bindingContext2, function2, 1, analyzedElements, !analyzeInlineFunctions);
        return analyzedElements;
    }

    private final BindingContext analyzeElementWithInline(ResolutionFacade resolutionFacade2, BindingContext bindingContext2, KtElement element2, int deep, Set<KtElement> analyzedElements, boolean analyzeInlineFunctions) {
        Project project = element2.getProject();
        HashSet collectedElements = new HashSet();
        element2.accept(new KtTreeVisitorVoid(bindingContext2, analyzeInlineFunctions, project, analyzedElements, collectedElements){
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ boolean $analyzeInlineFunctions;
            final /* synthetic */ Project $project;
            final /* synthetic */ Set $analyzedElements;
            final /* synthetic */ HashSet $collectedElements;

            public void visitExpression(@NotNull KtExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitExpression(expression2);
                Call call = (Call)this.$bindingContext.get(BindingContext.CALL, expression2);
                if (call == null) {
                    return;
                }
                Call call2 = call;
                ResolvedCall resolvedCall2 = (ResolvedCall)this.$bindingContext.get(BindingContext.RESOLVED_CALL, call2);
                this.checkResolveCall(resolvedCall2);
            }

            public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
                Intrinsics.checkParameterIsNotNull((Object)destructuringDeclaration, (String)"destructuringDeclaration");
                super.visitDestructuringDeclaration(destructuringDeclaration);
                for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                    ResolvedCall resolvedCall2 = (ResolvedCall)this.$bindingContext.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                    this.checkResolveCall(resolvedCall2);
                }
            }

            public void visitForExpression(@NotNull KtForExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitForExpression(expression2);
                this.checkResolveCall((ResolvedCall)this.$bindingContext.get(BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, expression2.getLoopRange()));
                this.checkResolveCall((ResolvedCall)this.$bindingContext.get(BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, expression2.getLoopRange()));
                this.checkResolveCall((ResolvedCall)this.$bindingContext.get(BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, expression2.getLoopRange()));
            }

            private final void checkResolveCall(ResolvedCall<?> resolvedCall2) {
                block6: {
                    ? descriptor2;
                    block7: {
                        if (resolvedCall2 == null) {
                            return;
                        }
                        descriptor2 = resolvedCall2.getResultingDescriptor();
                        if (descriptor2 instanceof DeserializedSimpleFunctionDescriptor) {
                            return;
                        }
                        if (!InlineUtil.isInline((DeclarationDescriptor)descriptor2)) break block6;
                        if (this.$analyzeInlineFunctions) break block7;
                        ? obj = descriptor2;
                        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"descriptor");
                        if (!DebuggerUtils.access$hasReifiedTypeParameters(DebuggerUtils.INSTANCE, obj)) break block6;
                    }
                    Project project = this.$project;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                    DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)descriptor2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor");
                    PsiElement declaration = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, declarationDescriptor);
                    if (declaration != null && declaration instanceof KtNamedFunction && !this.$analyzedElements.contains(declaration)) {
                        this.$collectedElements.add(declaration);
                    }
                }
            }
            {
                this.$bindingContext = $captured_local_variable$0;
                this.$analyzeInlineFunctions = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                this.$analyzedElements = $captured_local_variable$3;
                this.$collectedElements = $captured_local_variable$4;
            }
        });
        analyzedElements.add(element2);
        if (!collectedElements.isEmpty() && deep < 10) {
            ArrayList<BindingContext> innerContexts = new ArrayList<BindingContext>();
            for (KtNamedFunction inlineFunctions : collectedElements) {
                KtExpression body2 = inlineFunctions.getBodyExpression();
                if (body2 == null) continue;
                BindingContext bindingContextForFunction = resolutionFacade2.analyze(body2, BodyResolveMode.FULL);
                KtElement ktElement = inlineFunctions;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"inlineFunctions");
                innerContexts.add(this.analyzeElementWithInline(resolutionFacade2, bindingContextForFunction, ktElement, deep + 1, analyzedElements, analyzeInlineFunctions));
            }
            innerContexts.add(bindingContext2);
            analyzedElements.addAll(collectedElements);
            return CompositeBindingContext.Companion.create((List<? extends BindingContext>)innerContexts);
        }
        return bindingContext2;
    }

    private final boolean hasReifiedTypeParameters(CallableDescriptor descriptor2) {
        boolean bl;
        block1: {
            Iterable $receiver$iv = descriptor2.getTypeParameters();
            for (Object element$iv : $receiver$iv) {
                TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                if (!it.isReified()) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private DebuggerUtils() {
        INSTANCE = this;
        KOTLIN_EXTENSIONS = Sets.newHashSet((Object[])new String[]{"kt", "kts"});
    }

    static {
        new DebuggerUtils();
    }

    @NotNull
    public static final /* synthetic */ List access$findFilesByNameInPackage(DebuggerUtils $this, @NotNull JvmClassName className2, @NotNull String fileName, @NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        return $this.findFilesByNameInPackage(className2, fileName, project, searchScope);
    }

    public static final /* synthetic */ boolean access$hasReifiedTypeParameters(DebuggerUtils $this, @NotNull CallableDescriptor descriptor2) {
        return $this.hasReifiedTypeParameters(descriptor2);
    }
}

