/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RemoveToStringFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
public final class RemoveToStringFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        return "Remove 'toString()' call";
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement templateEntry;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement().getParent();
        if (!(psiElement instanceof KtDotQualifiedExpression)) {
            psiElement = null;
        }
        KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement;
        if (ktDotQualifiedExpression == null) {
            return;
        }
        KtDotQualifiedExpression element2 = ktDotQualifiedExpression;
        KtExpression receiverExpression = element2.getReceiverExpression();
        if (receiverExpression instanceof KtNameReferenceExpression && (templateEntry = ((KtNameReferenceExpression)receiverExpression).getParent().getParent()) instanceof KtBlockStringTemplateEntry && KtPsiUtilKt.canPlaceAfterSimpleNameEntry(((KtBlockStringTemplateEntry)templateEntry).getNextSibling())) {
            KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory(templateEntry);
            templateEntry.replace((PsiElement)factory2.createSimpleNameStringTemplateEntry(((KtNameReferenceExpression)receiverExpression).getReferencedName()));
            return;
        }
        element2.replace((PsiElement)receiverExpression);
    }
}

