/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveBracesIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "handleComments", "construct", "Lorg/jetbrains/kotlin/psi/KtExpression;", "block", "isApplicableTo", "", "caretOffset", "", "idea"})
public final class RemoveBracesIntention
extends SelfTargetingIntention<KtBlockExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtBlockExpression element2, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull(element2.getStatements());
        if (ktExpression == null) {
            return false;
        }
        KtExpression singleStatement = ktExpression;
        PsiElement psiElement = element2.getParent();
        if (!(psiElement instanceof KtContainerNode)) {
            psiElement = null;
        }
        KtContainerNode ktContainerNode = (KtContainerNode)psiElement;
        if (ktContainerNode == null) {
            return false;
        }
        KtContainerNode containerNode = ktContainerNode;
        if (singleStatement instanceof KtIfExpression && containerNode.getParent() instanceof KtIfExpression) {
            return false;
        }
        PsiElement psiElement2 = element2.getLBrace();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement lBrace = psiElement2;
        PsiElement psiElement3 = element2.getRBrace();
        if (psiElement3 == null) {
            return false;
        }
        PsiElement rBrace = psiElement3;
        if (!lBrace.getTextRange().containsOffset(caretOffset) && !rBrace.getTextRange().containsOffset(caretOffset)) {
            return false;
        }
        String string = UtilsKt.description(containerNode);
        if (string == null) {
            return false;
        }
        String description = string;
        this.setText("Remove braces from '" + description + "' statement");
        return true;
    }

    @Override
    public void applyTo(@NotNull KtBlockExpression element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression statement2 = (KtExpression)CollectionsKt.single(element2.getStatements());
        PsiElement psiElement = element2.getParent();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtContainerNode");
        }
        KtContainerNode containerNode = (KtContainerNode)psiElement;
        PsiElement psiElement2 = containerNode.getParent();
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        }
        KtExpression construct = (KtExpression)psiElement2;
        this.handleComments(construct, element2);
        PsiElement psiElement3 = statement2.copy();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"statement.copy()");
        PsiElement newElement = element2.replace(psiElement3);
        if (construct instanceof KtDoWhileExpression) {
            PsiElement psiElement4 = newElement.getParent();
            if (psiElement4 == null) {
                Intrinsics.throwNpe();
            }
            psiElement4.addAfter(KtPsiFactoryKt.KtPsiFactory((PsiElement)element2).createNewLine(), newElement);
        }
    }

    private final void handleComments(KtExpression construct, KtBlockExpression block) {
        PsiElement sibling;
        PsiElement psiElement = block.getFirstChild();
        Object object = sibling = psiElement != null ? psiElement.getNextSibling() : null;
        while (sibling != null) {
            if (sibling instanceof PsiComment) {
                KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)construct);
                if (construct.getPrevSibling() instanceof PsiWhiteSpace) {
                    PsiElement psiElement2 = construct.getPrevSibling();
                    if (psiElement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    psiElement2.replace(psiFactory.createNewLine());
                }
                PsiElement psiElement3 = construct.getParent();
                if (psiElement3 == null) {
                    Intrinsics.throwNpe();
                }
                PsiElement commentElement = psiElement3.addBefore(sibling, construct.getPrevSibling());
                PsiElement psiElement4 = construct.getParent();
                if (psiElement4 == null) {
                    Intrinsics.throwNpe();
                }
                psiElement4.addBefore(psiFactory.createNewLine(), commentElement);
            }
            sibling = sibling.getNextSibling();
        }
    }

    public RemoveBracesIntention() {
        super(KtBlockExpression.class, "Remove braces", null, 4, null);
    }
}

