/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.codeInsight.navigation.MethodImplementationsSearch;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;

public class KotlinDefinitionsSearcher
implements QueryExecutor<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    public boolean execute(@NotNull DefinitionsScopedSearch.SearchParameters queryParameters, @NotNull Processor<PsiElement> consumer2) {
        KtParameter parameter;
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "execute"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "execute"));
        }
        PsiElement element2 = queryParameters.getElement();
        SearchScope scope2 = queryParameters.getScope();
        consumer2 = KotlinDefinitionsSearcher.skipDelegatedMethodsConsumer(consumer2);
        if (element2 instanceof KtClass) {
            return KotlinDefinitionsSearcher.processClassImplementations((KtClass)element2, consumer2);
        }
        if (element2 instanceof KtNamedFunction || element2 instanceof KtSecondaryConstructor) {
            return KotlinDefinitionsSearcher.processFunctionImplementations((KtFunction)element2, scope2, consumer2);
        }
        if (element2 instanceof KtProperty) {
            return KotlinDefinitionsSearcher.processPropertyImplementations((KtProperty)element2, scope2, consumer2);
        }
        if (element2 instanceof KtParameter && KotlinDefinitionsSearcher.isFieldParameter(parameter = (KtParameter)element2)) {
            return KotlinDefinitionsSearcher.processPropertyImplementations((KtParameter)element2, scope2, consumer2);
        }
        return true;
    }

    @NotNull
    private static Processor<PsiElement> skipDelegatedMethodsConsumer(final @NotNull Processor<PsiElement> baseConsumer) {
        if (baseConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseConsumer", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "skipDelegatedMethodsConsumer"));
        }
        Processor<PsiElement> processor2 = new Processor<PsiElement>(){

            public boolean process(PsiElement element2) {
                if (KotlinDefinitionsSearcher.isDelegated(element2)) {
                    return true;
                }
                return baseConsumer.process((Object)element2);
            }
        };
        if (processor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "skipDelegatedMethodsConsumer"));
        }
        return processor2;
    }

    private static boolean isDelegated(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "isDelegated"));
        }
        return element2 instanceof KtLightMethod && ((KtLightMethod)element2).isDelegated();
    }

    private static boolean isFieldParameter(final KtParameter parameter) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return KtPsiUtil.getClassIfParameterIsProperty(parameter) != null;
            }
        });
    }

    private static boolean processClassImplementations(final @NotNull KtClass klass2, Processor<PsiElement> consumer2) {
        if (klass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "processClassImplementations"));
        }
        PsiClass psiClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                return LightClassUtilsKt.toLightClass(klass2);
            }
        });
        if (psiClass != null) {
            return ContainerUtil.process((Iterable)ClassInheritorsSearch.search((PsiClass)psiClass, (boolean)true), consumer2);
        }
        return true;
    }

    private static boolean processFunctionImplementations(final KtFunction function2, SearchScope scope2, Processor<PsiElement> consumer2) {
        PsiMethod psiMethod = (PsiMethod)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiMethod>(){

            public PsiMethod compute() {
                return LightClassUtil.INSTANCE.getLightClassMethod(function2);
            }
        });
        if (psiMethod != null) {
            MethodImplementationsSearch.processImplementations((PsiMethod)psiMethod, consumer2, (SearchScope)scope2);
        }
        return true;
    }

    private static boolean processPropertyImplementations(final @NotNull KtParameter parameter, @NotNull SearchScope scope2, @NotNull Processor<PsiElement> consumer2) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "processPropertyImplementations"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "processPropertyImplementations"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "processPropertyImplementations"));
        }
        LightClassUtil.PropertyAccessorsPsiMethods accessorsPsiMethods = (LightClassUtil.PropertyAccessorsPsiMethods)ApplicationManager.getApplication().runReadAction((Computable)new Computable<LightClassUtil.PropertyAccessorsPsiMethods>(){

            public LightClassUtil.PropertyAccessorsPsiMethods compute() {
                return LightClassUtil.INSTANCE.getLightClassPropertyMethods(parameter);
            }
        });
        return KotlinDefinitionsSearcher.processPropertyImplementationsMethods(accessorsPsiMethods, scope2, consumer2);
    }

    private static boolean processPropertyImplementations(final @NotNull KtProperty property2, @NotNull SearchScope scope2, @NotNull Processor<PsiElement> consumer2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "processPropertyImplementations"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "processPropertyImplementations"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "processPropertyImplementations"));
        }
        LightClassUtil.PropertyAccessorsPsiMethods accessorsPsiMethods = (LightClassUtil.PropertyAccessorsPsiMethods)ApplicationManager.getApplication().runReadAction((Computable)new Computable<LightClassUtil.PropertyAccessorsPsiMethods>(){

            public LightClassUtil.PropertyAccessorsPsiMethods compute() {
                return LightClassUtil.INSTANCE.getLightClassPropertyMethods(property2);
            }
        });
        return KotlinDefinitionsSearcher.processPropertyImplementationsMethods(accessorsPsiMethods, scope2, consumer2);
    }

    public static boolean processPropertyImplementationsMethods(LightClassUtil.PropertyAccessorsPsiMethods accessors, @NotNull SearchScope scope2, @NotNull Processor<PsiElement> consumer2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "processPropertyImplementationsMethods"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "processPropertyImplementationsMethods"));
        }
        for (PsiMethod method : accessors) {
            ArrayList implementations = new ArrayList();
            MethodImplementationsSearch.getOverridingMethods((PsiMethod)method, implementations, (SearchScope)scope2);
            for (PsiMethod implementation : implementations) {
                KtDeclaration mirrorElement;
                if (KotlinDefinitionsSearcher.isDelegated((PsiElement)implementation)) continue;
                KtDeclaration ktDeclaration = mirrorElement = implementation instanceof KtLightMethod ? (KtDeclaration)((KtLightMethod)implementation).getKotlinOrigin() : null;
                if (!(mirrorElement instanceof KtProperty || mirrorElement instanceof KtParameter ? !consumer2.process((Object)mirrorElement) : (mirrorElement instanceof KtPropertyAccessor && mirrorElement.getParent() instanceof KtProperty ? !consumer2.process((Object)mirrorElement.getParent()) : !consumer2.process((Object)implementation)))) continue;
                return false;
            }
        }
        return true;
    }
}

