/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightClassMarker;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.load.java.JavaClassFinder;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaPackage;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaPackageImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JavaClassFinderPostConstruct;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;

public class JavaClassFinderImpl
implements JavaClassFinder {
    private Project project;
    private GlobalSearchScope baseScope;
    private GlobalSearchScope javaSearchScope;
    private KotlinJavaPsiFacade javaFacade;

    @Inject
    public void setProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/load/java/JavaClassFinderImpl", "setProject"));
        }
        this.project = project;
    }

    @Inject
    public void setScope(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/load/java/JavaClassFinderImpl", "setScope"));
        }
        this.baseScope = scope2;
    }

    @Inject
    public void setComponentPostConstruct(@NotNull JavaClassFinderPostConstruct finderPostConstruct) {
        if (finderPostConstruct == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finderPostConstruct", "org/jetbrains/kotlin/load/java/JavaClassFinderImpl", "setComponentPostConstruct"));
        }
    }

    @PostConstruct
    public void initialize() {
        this.javaSearchScope = new DelegatingGlobalSearchScope(this.baseScope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/load/java/JavaClassFinderImpl$1", "contains"));
                }
                return this.myBaseScope.contains(file2) && (file2.isDirectory() || file2.getFileType() != KotlinFileType.INSTANCE);
            }

            @NotNull
            public Project getProject() {
                Project project = JavaClassFinderImpl.this.project;
                if (project == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/JavaClassFinderImpl$1", "getProject"));
                }
                return project;
            }

            public String toString() {
                return "JCFI: " + JavaClassFinderImpl.this.baseScope;
            }
        };
        this.javaFacade = KotlinJavaPsiFacade.getInstance(this.project);
    }

    @Override
    @Nullable
    public JavaClass findClass(@NotNull ClassId classId) {
        if (classId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/kotlin/load/java/JavaClassFinderImpl", "findClass"));
        }
        PsiClass psiClass = this.javaFacade.findClass(classId, this.javaSearchScope);
        if (psiClass == null) {
            return null;
        }
        JavaClassImpl javaClass = new JavaClassImpl(psiClass);
        FqName fqName2 = classId.asSingleFqName();
        if (!fqName2.equals(javaClass.getFqName())) {
            throw new IllegalStateException("Requested " + fqName2 + ", got " + javaClass.getFqName());
        }
        if (psiClass instanceof KtLightClassMarker) {
            throw new IllegalStateException("Kotlin light classes should not be found by JavaPsiFacade, resolving: " + fqName2);
        }
        return javaClass;
    }

    @Override
    @Nullable
    public JavaPackage findPackage(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/load/java/JavaClassFinderImpl", "findPackage"));
        }
        PsiPackage psiPackage = this.javaFacade.findPackage(fqName2.asString(), this.javaSearchScope);
        return psiPackage == null ? null : new JavaPackageImpl(psiPackage, this.javaSearchScope);
    }

    @Override
    @Nullable
    public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/load/java/JavaClassFinderImpl", "knownClassNamesInPackage"));
        }
        return this.javaFacade.knownClassNamesInPackage(packageFqName);
    }
}

