/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.CreatePropertyFix;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.LocalAnnotationModelImpl;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringPropertySource;
import com.intellij.spring.model.jam.stereotype.SpringPropertySources;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.values.PlaceholderInfo;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.context.PropertyPlaceholder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.xml.DomElement;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderPropertyReference
extends PropertyReference
implements LocalQuickFixProvider {
    private final PlaceholderInfo myInfo;
    @Nullable
    private final String myDefaultValue;

    private PlaceholderPropertyReference(@NotNull String key, PsiElement element, TextRange textRange, PlaceholderInfo info, @Nullable String defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/model/values/PlaceholderPropertyReference", "<init>"));
        }
        super(key, element, null, true, textRange);
        this.myInfo = info;
        this.myDefaultValue = defaultValue;
    }

    @Nullable
    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    public static PlaceholderPropertyReference create(PsiElement element, TextRange textRange, PlaceholderInfo info) {
        String text = info.text;
        if (text.contains(":")) {
            int offset = textRange.getStartOffset();
            int endOffset = text.indexOf(":");
            String key = text.substring(0, endOffset);
            String defaultValue = text.substring(endOffset + 1);
            return new PlaceholderPropertyReference(key, element, TextRange.from((int)offset, (int)endOffset), info, defaultValue){

                public boolean isSoft() {
                    return true;
                }
            };
        }
        return new PlaceholderPropertyReference(text, element, textRange, info, null);
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderPropertyReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    private static Properties getValueProperties(SpringProperty property) {
        Properties props = new Properties();
        String value = property.getValue().getStringValue();
        if (!StringUtil.isEmptyOrSpaces((String)value)) {
            try {
                props.load(new StringReader(value));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Properties properties = props;
        if (properties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderPropertyReference", "getValueProperties"));
        }
        return properties;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        HashSet properties = new HashSet();
        Processor processor = propertiesFile -> {
            properties.addAll(propertiesFile.findPropertiesByKey(this.myKey));
            return true;
        };
        HashSet<DomElement> configurerProperties = new HashSet<DomElement>();
        CommonSpringModel springModel = SpringModelUtils.getInstance().getSpringModel(this.myElement);
        List<SpringBeanPointer> placeholders = this.getPlaceholders(springModel);
        PlaceholderPropertyReference.processXmlProperties((Processor<PropertiesFile>)processor, placeholders);
        this.processAllPropertiesIfNeed((Processor<PropertiesFile>)processor, springModel);
        configurerProperties.addAll(this.getPlaceholderConfigurerProperties(this.myKey, placeholders));
        PlaceholderPropertyReference.processEmbeddedPropertySources((Processor<PropertiesFile>)processor, springModel);
        if (springModel instanceof SpringModel) {
            SpringFileSet fileSet = ((SpringModel)springModel).getFileSet();
            if (fileSet != null) {
                Project project = this.myElement.getProject();
                PlaceholderPropertyReference.processFilesetCustomPropertiesFiles((Processor<PropertiesFile>)processor, fileSet, project);
            }
            for (CommonSpringModel model : ((SpringModel)springModel).getModelsToProcess()) {
                if (!(model instanceof LocalAnnotationModelImpl)) continue;
                PlaceholderPropertyReference.processConfigurationProperties((Processor<PropertiesFile>)processor, (LocalAnnotationModelImpl)model);
            }
        }
        ResolveResult[] result = new ResolveResult[properties.size() + configurerProperties.size()];
        if (properties.size() > 0 || configurerProperties.size() > 0) {
            int i = 0;
            for (IProperty property : properties) {
                result[i++] = new PsiElementResolveResult(property instanceof PsiElement ? (PsiElement)property : PomService.convertToPsi((PsiTarget)((PsiTarget)property)));
            }
            for (DomElement configurerProperty : configurerProperties) {
                result[i++] = new PsiElementResolveResult((PsiElement)configurerProperty.getXmlElement());
            }
        } else if (System.getProperties().getProperty(this.myKey) != null) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult(this.getElement())};
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderPropertyReference", "multiResolve"));
            }
            return resolveResultArray;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderPropertyReference", "multiResolve"));
        }
        return result;
    }

    void processAllPropertiesIfNeed(final @NotNull Processor<PropertiesFile> processor, @NotNull CommonSpringModel model) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/values/PlaceholderPropertyReference", "processAllPropertiesIfNeed"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/values/PlaceholderPropertyReference", "processAllPropertiesIfNeed"));
        }
        Module module = model.getModule();
        if (module == null) {
            return;
        }
        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
        if (springFacet == null) {
            return;
        }
        CustomSetting setting = springFacet.findSetting("process_all_properties");
        if (setting != null && ((CustomSetting.BOOLEAN)setting).getBooleanValue()) {
            PropertiesFileProcessor propertiesFileProcessor = new PropertiesFileProcessor(){

                public boolean process(String baseName, PropertiesFile propertiesFile) {
                    return processor.process((Object)propertiesFile);
                }
            };
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            PropertiesReferenceManager.getInstance((Project)this.myElement.getProject()).processPropertiesFiles(scope, propertiesFileProcessor, BundleNameEvaluator.DEFAULT);
        }
    }

    private static void processFilesetCustomPropertiesFiles(Processor<PropertiesFile> processor, SpringFileSet fileSet, Project project) {
        Set files = fileSet.getPropertiesFiles();
        for (VirtualFilePointer pointer : files) {
            PsiFile psiFile;
            VirtualFile virtualFile = pointer.getFile();
            if (virtualFile == null || !((psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile)) instanceof PropertiesFile)) continue;
            processor.process((Object)((PropertiesFile)psiFile));
        }
    }

    static void processEmbeddedPropertySources(@NotNull Processor<PropertiesFile> processor, @NotNull CommonSpringModel model) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/values/PlaceholderPropertyReference", "processEmbeddedPropertySources"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/values/PlaceholderPropertyReference", "processEmbeddedPropertySources"));
        }
        List<SpringPropertySource> propertySources = PlaceholderPropertyReference.getPropertySources(model);
        for (SpringPropertySource propertySource : propertySources) {
            for (PropertiesFile file : propertySource.getPropertiesFiles()) {
                processor.process((Object)file);
            }
        }
    }

    @Nullable
    private static List<SpringPropertySource> getPropertySources(CommonSpringModel model) {
        return ContainerUtil.filter(PlaceholderPropertyReference.getPropertySources(model.getModule()), source -> {
            PsiClass psiClass = source.getPsiElement();
            return psiClass.isValid() && SpringModelSearchers.doesBeanExist((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)psiClass));
        });
    }

    @NotNull
    private static List<SpringPropertySource> getPropertySources(@Nullable Module module) {
        if (module == null || DumbService.isDumb((Project)module.getProject())) {
            List<SpringPropertySource> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderPropertyReference", "getPropertySources"));
            }
            return list;
        }
        List list = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            List propertySources = ContainerUtil.newSmartList();
            JamService jamService = JamService.getJamService((Project)module.getProject());
            propertySources.addAll(jamService.getJamClassElements((JamMemberMeta)SpringPropertySource.META, "org.springframework.context.annotation.PropertySource", scope));
            for (SpringPropertySources springPropertySources : jamService.getJamClassElements((JamMemberMeta)SpringPropertySources.META, "org.springframework.context.annotation.PropertySources", scope)) {
                propertySources.addAll(springPropertySources.getPropertySources());
            }
            return CachedValueProvider.Result.create((Object)propertySources, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderPropertyReference", "getPropertySources"));
        }
        return list;
    }

    static boolean processConfigurationProperties(@NotNull Processor<PropertiesFile> processor, @NotNull LocalAnnotationModelImpl model) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/values/PlaceholderPropertyReference", "processConfigurationProperties"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/values/PlaceholderPropertyReference", "processConfigurationProperties"));
        }
        SpringConfiguration configuration = model.getConfiguration();
        if (configuration == null) {
            return true;
        }
        for (PropertiesFile file : PlaceholderPropertyReference.getProperties(configuration, model.getAllCommonBeans())) {
            if (processor.process((Object)file)) continue;
            return false;
        }
        return true;
    }

    private static Set<PropertiesFile> getProperties(@NotNull SpringConfiguration configuration, @NotNull Collection<? extends SpringBeanPointer> beans) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/model/values/PlaceholderPropertyReference", "getProperties"));
        }
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/values/PlaceholderPropertyReference", "getProperties"));
        }
        HashSet<PropertiesFile> files = new HashSet<PropertiesFile>();
        PlaceholderPropertyReference.addPropertiesFiles(configuration, files);
        for (SpringBeanPointer springBeanPointer : beans) {
            CommonSpringBean bean = springBeanPointer.getSpringBean();
            if (bean instanceof DomSpringBean && InheritanceUtil.isInheritor((PsiClass)PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType()), (String)"org.springframework.beans.factory.config.PropertyPlaceholderConfigurer")) {
                for (Pair pair : PlaceholderUtils.getInstance().getLocations(bean)) {
                    files.addAll(PlaceholderUtils.getInstance().getPropertiesFile(pair));
                }
            }
            if (!(bean instanceof SpringConfiguration)) continue;
            PlaceholderPropertyReference.addPropertiesFiles((SpringConfiguration)bean, files);
        }
        return files;
    }

    private static void addPropertiesFiles(@NotNull SpringConfiguration bean, @NotNull Set<PropertiesFile> files) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/values/PlaceholderPropertyReference", "addPropertiesFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/spring/model/values/PlaceholderPropertyReference", "addPropertiesFiles"));
        }
        for (SpringPropertySource source : bean.getPropertySources()) {
            files.addAll(source.getPropertiesFiles());
        }
    }

    static void processXmlProperties(@NotNull Processor<PropertiesFile> processor, @NotNull List<SpringBeanPointer> placeholders) {
        PropertiesFile resource;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/values/PlaceholderPropertyReference", "processXmlProperties"));
        }
        if (placeholders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeholders", "com/intellij/spring/model/values/PlaceholderPropertyReference", "processXmlProperties"));
        }
        Iterator iterator = PlaceholderUtils.getInstance().getResources(placeholders).iterator();
        while (iterator.hasNext() && processor.process((Object)(resource = (PropertiesFile)iterator.next()))) {
        }
    }

    @NotNull
    private Set<DomElement> getPlaceholderConfigurerProperties(@NotNull String key, @NotNull List<SpringBeanPointer> placeholders) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/model/values/PlaceholderPropertyReference", "getPlaceholderConfigurerProperties"));
        }
        if (placeholders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeholders", "com/intellij/spring/model/values/PlaceholderPropertyReference", "getPlaceholderConfigurerProperties"));
        }
        Set set = (Set)RecursionManager.doPreventingRecursion((Object)((Object)this), (boolean)true, () -> {
            if (placeholders == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeholders", "com/intellij/spring/model/values/PlaceholderPropertyReference", "lambda$getPlaceholderConfigurerProperties$3"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/model/values/PlaceholderPropertyReference", "lambda$getPlaceholderConfigurerProperties$3"));
            }
            return PlaceholderPropertyReference.getAllPlaceholderConfigurerProperties(placeholders).get(key);
        });
        Set set2 = set == null ? Collections.emptySet() : set;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderPropertyReference", "getPlaceholderConfigurerProperties"));
        }
        return set2;
    }

    @NotNull
    static Map<String, Set<DomElement>> getAllPlaceholderConfigurerProperties(List<SpringBeanPointer> placeholders) {
        HashMap all = new HashMap();
        for (SpringBeanPointer placeholder : placeholders) {
            PropertyPlaceholder propertyPlaceholder;
            SpringBeanPointer propertyBeanHolder;
            CommonSpringBean placeholderBean = placeholder.getSpringBean();
            PlaceholderPropertyReference.addProperties((Map<String, Set<DomElement>>)all, placeholderBean);
            if (!(placeholderBean instanceof PropertyPlaceholder) || (propertyBeanHolder = (SpringBeanPointer)(propertyPlaceholder = (PropertyPlaceholder)placeholderBean).getPropertiesRef().getValue()) == null) continue;
            PlaceholderPropertyReference.addProperties((Map<String, Set<DomElement>>)all, propertyBeanHolder.getSpringBean());
        }
        HashMap hashMap = all;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderPropertyReference", "getAllPlaceholderConfigurerProperties"));
        }
        return hashMap;
    }

    private static void addProperties(Map<String, Set<DomElement>> all, CommonSpringBean bean) {
        SpringPropertyDefinition propertyDefinition = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)"properties");
        if (propertyDefinition instanceof SpringProperty) {
            for (Prop prop : ((SpringProperty)propertyDefinition).getProps().getProps()) {
                String propKey = prop.getKey().getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)propKey)) continue;
                if (!all.containsKey(propKey)) {
                    all.put(propKey, new HashSet());
                }
                all.get(propKey).add((DomElement)prop);
            }
            for (Prop prop : ((SpringProperty)propertyDefinition).getMap().getEntries()) {
                String keyAttr = prop.getKeyAttr().getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)keyAttr)) continue;
                if (!all.containsKey(keyAttr)) {
                    all.put(keyAttr, new HashSet());
                }
                all.get(keyAttr).add((DomElement)prop);
            }
            for (Object propName : PlaceholderPropertyReference.getValueProperties((SpringProperty)propertyDefinition).keySet()) {
                if (!(propName instanceof String)) continue;
                if (!all.containsKey(propName)) {
                    all.put((String)propName, new HashSet());
                }
                all.get(propName).add((DomElement)((SpringProperty)propertyDefinition).getValue());
            }
        }
    }

    public LocalQuickFix[] getQuickFixes() {
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel(this.myElement);
        List<SpringBeanPointer> placeholders = this.getPlaceholders(model);
        Set resources = PlaceholderUtils.getInstance().getResources(placeholders);
        return new LocalQuickFix[]{new CreatePropertyFix(this.getElement(), this.myKey, new ArrayList(resources))};
    }

    public List<SpringBeanPointer> getPlaceholders(@NotNull CommonSpringModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/values/PlaceholderPropertyReference", "getPlaceholders"));
        }
        SmartList placeholders = new SmartList();
        for (SpringBeanPointer pointer : model.getPlaceholderConfigurers()) {
            Pair pair = PlaceholderUtils.getInstance().getPlaceholderPrefixAndSuffixInner(pointer);
            if (!this.myInfo.prefixAndSuffix.equals((Object)pair)) continue;
            placeholders.add(pointer);
        }
        return placeholders;
    }

    public TextRange getFullTextRange() {
        return this.myInfo.fullTextRange;
    }
}

