/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.annotation;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.htmlInspections.HtmlNonExistentInternetResourceInspection;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.paths.WebReferencesAnnotatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlNonExistentInternetResourcesAnnotator
extends WebReferencesAnnotatorBase {
    public static boolean ourEnableInTestMode = false;

    @NotNull
    protected WebReference[] collectWebReferences(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/annotation/HtmlNonExistentInternetResourcesAnnotator", "collectWebReferences"));
        }
        if (!ourEnableInTestMode && ApplicationManager.getApplication().isUnitTestMode()) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/HtmlNonExistentInternetResourcesAnnotator", "collectWebReferences"));
            }
            return EMPTY_ARRAY;
        }
        HtmlNonExistentInternetResourceInspection inspection = HtmlNonExistentInternetResourcesAnnotator.getInspection((PsiElement)file);
        if (inspection == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/HtmlNonExistentInternetResourcesAnnotator", "collectWebReferences"));
            }
            return EMPTY_ARRAY;
        }
        final ArrayList result = new ArrayList();
        file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                if (!(element instanceof XmlAttributeValue)) {
                    return;
                }
                WebReference webReference = HtmlNonExistentInternetResourcesAnnotator.lookForWebReference((PsiElement)element);
                if (webReference != null) {
                    result.add(webReference);
                }
            }
        });
        WebReference[] webReferenceArray = result.toArray(new WebReference[result.size()]);
        if (webReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/HtmlNonExistentInternetResourcesAnnotator", "collectWebReferences"));
        }
        return webReferenceArray;
    }

    @Nullable
    public static HtmlNonExistentInternetResourceInspection getInspection(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/annotation/HtmlNonExistentInternetResourcesAnnotator", "getInspection"));
        }
        String shortName = "HtmlNonExistentInternetResource";
        HighlightDisplayKey key = HighlightDisplayKey.find((String)"HtmlNonExistentInternetResource");
        if (key == null) {
            return null;
        }
        InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)context.getProject()).getCurrentProfile();
        if (!profile.isToolEnabled(key, context)) {
            return null;
        }
        return (HtmlNonExistentInternetResourceInspection)profile.getUnwrappedTool("HtmlNonExistentInternetResource", context);
    }

    @NotNull
    protected IntentionAction[] getQuickFixes() {
        IntentionAction[] intentionActionArray = new IntentionAction[]{new MyDisableInspectionFix()};
        if (intentionActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/HtmlNonExistentInternetResourcesAnnotator", "getQuickFixes"));
        }
        return intentionActionArray;
    }

    @NotNull
    protected HighlightDisplayLevel getHighlightDisplayLevel(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/annotation/HtmlNonExistentInternetResourcesAnnotator", "getHighlightDisplayLevel"));
        }
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance((Project)context.getProject()).getCurrentProfile();
        HighlightDisplayKey displayKey = HighlightDisplayKey.find((String)"HtmlNonExistentInternetResource");
        HighlightDisplayLevel highlightDisplayLevel = inspectionProfile.getErrorLevel(displayKey, context);
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/HtmlNonExistentInternetResourcesAnnotator", "getHighlightDisplayLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    protected String getErrorMessage(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/lang/annotation/HtmlNonExistentInternetResourcesAnnotator", "getErrorMessage"));
        }
        String string = XmlBundle.message((String)"html.annotators.non.existent.internet.resource", (Object[])new Object[]{url});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/HtmlNonExistentInternetResourcesAnnotator", "getErrorMessage"));
        }
        return string;
    }

    private static class MyDisableInspectionFix
    implements IntentionAction {
        private final DisableInspectionToolAction myDisableInspectionToolAction;

        private MyDisableInspectionFix() {
            HighlightDisplayKey key = HighlightDisplayKey.find((String)"HtmlNonExistentInternetResource");
            assert (key != null);
            this.myDisableInspectionToolAction = new DisableInspectionToolAction(key);
        }

        @NotNull
        public String getText() {
            if ("Disable validation of web links" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/HtmlNonExistentInternetResourcesAnnotator$MyDisableInspectionFix", "getText"));
            }
            return "Disable validation of web links";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/HtmlNonExistentInternetResourcesAnnotator$MyDisableInspectionFix", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/annotation/HtmlNonExistentInternetResourcesAnnotator$MyDisableInspectionFix", "isAvailable"));
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/annotation/HtmlNonExistentInternetResourcesAnnotator$MyDisableInspectionFix", "invoke"));
            }
            this.myDisableInspectionToolAction.invoke(project, editor, file);
        }

        public boolean startInWriteAction() {
            return this.myDisableInspectionToolAction.startInWriteAction();
        }
    }
}

