/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.dependencies;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.seam.dependencies.SeamDependenciesFileEditor;
import com.intellij.seam.dependencies.SeamDependenciesVirtualFileSystem;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SeamDependenciesEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/seam/dependencies/SeamDependenciesEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/seam/dependencies/SeamDependenciesEditorProvider", "accept"));
        }
        return file.getFileSystem() instanceof SeamDependenciesVirtualFileSystem;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/seam/dependencies/SeamDependenciesEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/seam/dependencies/SeamDependenciesEditorProvider", "createEditor"));
        }
        String moduleName = file.getName();
        Module moduleByName = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
        SeamDependenciesFileEditor seamDependenciesFileEditor = new SeamDependenciesFileEditor(moduleByName);
        if (seamDependenciesFileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/dependencies/SeamDependenciesEditorProvider", "createEditor"));
        }
        return seamDependenciesFileEditor;
    }

    @NotNull
    @NonNls
    public String getEditorTypeId() {
        if ("SeamDependenciesFileEditor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/dependencies/SeamDependenciesEditorProvider", "getEditorTypeId"));
        }
        return "SeamDependenciesFileEditor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.NONE;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/dependencies/SeamDependenciesEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }
}

