/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesList;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PropertiesInspectionSuppressor
implements InspectionSuppressor {
    private static final Logger LOG = Logger.getInstance(PropertiesInspectionSuppressor.class);

    @NotNull
    public SuppressQuickFix[] getSuppressActions(PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/PropertiesInspectionSuppressor", "getSuppressActions"));
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new SuppressSinglePropertyFix(toolId), new SuppressForFile(toolId)};
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PropertiesInspectionSuppressor", "getSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        String text;
        PropertiesFile file;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/PropertiesInspectionSuppressor", "isSuppressedFor"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/PropertiesInspectionSuppressor", "isSuppressedFor"));
        }
        Property property = (Property)PsiTreeUtil.getParentOfType((PsiElement)element, Property.class, (boolean)false);
        if (property == null) {
            PsiFile containingFile = element.getContainingFile();
            if (!(containingFile instanceof PropertiesFile)) return false;
            file = (PropertiesFile)containingFile;
        } else {
            PsiElement prev = property.getPrevSibling();
            while (prev instanceof PsiWhiteSpace || prev instanceof PsiComment) {
                if (prev instanceof PsiComment && (text = prev.getText()).contains("suppress") && text.contains("\"" + toolId + "\"")) {
                    return true;
                }
                prev = prev.getPrevSibling();
            }
            file = property.getPropertiesFile();
        }
        PsiElement leaf = file.getContainingFile().findElementAt(0);
        while (leaf instanceof PsiWhiteSpace) {
            leaf = leaf.getNextSibling();
        }
        while (leaf instanceof PsiComment) {
            text = leaf.getText();
            if (text.contains("suppress") && text.contains("\"" + toolId + "\"") && text.contains("file")) {
                return true;
            }
            if ((leaf = leaf.getNextSibling()) instanceof PsiWhiteSpace) {
                leaf = leaf.getNextSibling();
            }
            if (!(leaf instanceof PropertiesList) || leaf.getFirstChild() != property || !text.contains("suppress") || !text.contains("\"" + toolId + "\"")) continue;
            return true;
        }
        return false;
    }

    private static class SuppressForFile
    implements SuppressQuickFix {
        private final String shortName;

        private SuppressForFile(String shortName) {
            this.shortName = shortName;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PropertiesInspectionSuppressor$SuppressForFile", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PropertiesBundle.message("unused.property.suppress.for.file", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PropertiesInspectionSuppressor$SuppressForFile", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/PropertiesInspectionSuppressor$SuppressForFile", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/PropertiesInspectionSuppressor$SuppressForFile", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            PsiFile file = element.getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            LOG.assertTrue(doc != null, (Object)file);
            doc.insertString(0, (CharSequence)("# suppress inspection \"" + this.shortName + "\" for whole file\n"));
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/PropertiesInspectionSuppressor$SuppressForFile", "isAvailable"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/PropertiesInspectionSuppressor$SuppressForFile", "isAvailable"));
            }
            return context.isValid() && context.getContainingFile() instanceof PropertiesFile;
        }

        public boolean isSuppressAll() {
            return false;
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    private static class SuppressSinglePropertyFix
    implements SuppressQuickFix {
        private final String shortName;

        private SuppressSinglePropertyFix(String shortName) {
            this.shortName = shortName;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PropertiesInspectionSuppressor$SuppressSinglePropertyFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PropertiesBundle.message("unused.property.suppress.for.property", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PropertiesInspectionSuppressor$SuppressSinglePropertyFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/PropertiesInspectionSuppressor$SuppressSinglePropertyFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/PropertiesInspectionSuppressor$SuppressSinglePropertyFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            PsiFile file = element.getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            Property property = (Property)PsiTreeUtil.getParentOfType((PsiElement)element, Property.class);
            LOG.assertTrue(property != null);
            int start = property.getTextRange().getStartOffset();
            Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            LOG.assertTrue(doc != null);
            int line = doc.getLineNumber(start);
            int lineStart = doc.getLineStartOffset(line);
            doc.insertString(lineStart, (CharSequence)("# suppress inspection \"" + this.shortName + "\"\n"));
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/PropertiesInspectionSuppressor$SuppressSinglePropertyFix", "isAvailable"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/PropertiesInspectionSuppressor$SuppressSinglePropertyFix", "isAvailable"));
            }
            Property property = (Property)PsiTreeUtil.getParentOfType((PsiElement)context, Property.class);
            return property != null && property.isValid();
        }

        public boolean isSuppressAll() {
            return false;
        }
    }
}

