/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesInspectionBase;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrailingSpacesInPropertyInspection
extends PropertiesInspectionBase {
    public boolean myIgnoreVisibleSpaces;

    @NotNull
    public String getDisplayName() {
        String string = PropertiesBundle.message("trail.spaces.property.inspection.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrailingSpacesInPropertyInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("TrailingSpacesInProperty" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrailingSpacesInPropertyInspection", "getShortName"));
        }
        return "TrailingSpacesInProperty";
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/TrailingSpacesInPropertyInspection", "writeSettings"));
        }
        if (this.myIgnoreVisibleSpaces) {
            node.setAttribute("ignoreVisibleSpaces", Boolean.TRUE.toString());
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/TrailingSpacesInPropertyInspection", "readSettings"));
        }
        String attributeValue = node.getAttributeValue("ignoreVisibleSpaces");
        if (attributeValue != null) {
            this.myIgnoreVisibleSpaces = Boolean.valueOf(attributeValue);
        }
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(PropertiesBundle.message("trailing.spaces.in.property.inspection.ignore.visible.spaces", new Object[0]), (InspectionProfileEntry)this, "myIgnoreVisibleSpaces");
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/TrailingSpacesInPropertyInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/TrailingSpacesInPropertyInspection", "checkFile"));
        }
        if (!(file instanceof PropertiesFile)) {
            return null;
        }
        List<IProperty> properties = ((PropertiesFile)file).getProperties();
        SmartList descriptors = new SmartList();
        for (IProperty property : properties) {
            ProgressManager.checkCanceled();
            PropertyImpl propertyImpl = (PropertyImpl)property;
            for (ASTNode node : (ASTNode[])ContainerUtil.ar((Object[])new ASTNode[]{propertyImpl.getKeyNode(), propertyImpl.getValueNode()})) {
                PsiElement key;
                TextRange textRange;
                if (node == null || (textRange = TrailingSpacesInPropertyInspection.getTrailingSpaces(key = node.getPsi(), this.myIgnoreVisibleSpaces)) == null) continue;
                descriptors.add(manager.createProblemDescriptor(key, textRange, "Trailing spaces", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[]{new RemoveTrailingSpacesFix(this.myIgnoreVisibleSpaces)}));
            }
        }
        return descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    @Nullable
    private static TextRange getTrailingSpaces(PsiElement element, boolean ignoreVisibleTrailingSpaces) {
        String key = element.getText();
        if (ignoreVisibleTrailingSpaces) {
            for (int i = key.length() - 1; i > -1; --i) {
                if (key.charAt(i) == ' ' || key.charAt(i) == '\t') continue;
                return i == key.length() - 1 ? null : new TextRange(i + 1, key.length());
            }
            return element.getTextRange();
        }
        return PropertyImpl.trailingSpaces(key);
    }

    private static class RemoveTrailingSpacesFix
    implements LocalQuickFix {
        private final boolean myIgnoreVisibleSpaces;

        private RemoveTrailingSpacesFix(boolean ignoreVisibleSpaces) {
            this.myIgnoreVisibleSpaces = ignoreVisibleSpaces;
        }

        @NotNull
        public String getName() {
            if ("Remove Trailing Spaces" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrailingSpacesInPropertyInspection$RemoveTrailingSpacesFix", "getName"));
            }
            return "Remove Trailing Spaces";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrailingSpacesInPropertyInspection$RemoveTrailingSpacesFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement parent;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/TrailingSpacesInPropertyInspection$RemoveTrailingSpacesFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/TrailingSpacesInPropertyInspection$RemoveTrailingSpacesFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            PsiElement psiElement = parent = element == null ? null : element.getParent();
            if (!(parent instanceof PropertyImpl)) {
                return;
            }
            TextRange textRange = TrailingSpacesInPropertyInspection.getTrailingSpaces(element, this.myIgnoreVisibleSpaces);
            if (textRange != null) {
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(element.getContainingFile());
                TextRange docRange = textRange.shiftRight(element.getTextRange().getStartOffset());
                document.deleteString(docRange.getStartOffset(), docRange.getEndOffset());
            }
        }
    }
}

