/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unused;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.unused.ImplicitPropertyUsageProvider;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesInspectionBase;
import com.intellij.lang.properties.PropertiesQuickFixFactory;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorInspection;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorProblemDescriptor;
import com.intellij.lang.properties.findUsages.PropertySearcher;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedPropertyInspection
extends PropertiesInspectionBase
implements ResourceBundleEditorInspection {
    private static final Logger LOG = Logger.getInstance(UnusedPropertyInspection.class);

    @NotNull
    public String getDisplayName() {
        String string = PropertiesBundle.message("unused.property.inspection.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("UnusedProperty" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "getShortName"));
        }
        return "UnusedProperty";
    }

    @Nullable
    private static GlobalSearchScope getWidestUseScope(@Nullable String key, @NotNull Project project, @NotNull Module ownModule) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "getWidestUseScope"));
        }
        if (ownModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownModule", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "getWidestUseScope"));
        }
        if (key == null) {
            return null;
        }
        LinkedHashSet modules = ContainerUtil.newLinkedHashSet();
        for (IProperty property : PropertiesImplUtil.findPropertiesByKey(project, key)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)property.getPsiElement());
            if (module == null) {
                return GlobalSearchScope.allScope((Project)project);
            }
            if (module == ownModule) continue;
            modules.add(module);
        }
        if (modules.isEmpty()) {
            return null;
        }
        ArrayList list = ContainerUtil.newArrayList((Iterable)modules);
        GlobalSearchScope result = GlobalSearchScope.moduleWithDependentsScope((Module)((Module)list.get(0)));
        for (int i = 1; i < list.size(); ++i) {
            result = result.uniteWith(GlobalSearchScope.moduleWithDependentsScope((Module)((Module)list.get(i))));
        }
        return result;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "buildVisitor"));
        }
        PsiFile file = session.getFile();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        final UnusedPropertiesSearchHelper helper = new UnusedPropertiesSearchHelper(module);
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (!(element instanceof Property)) {
                    return;
                }
                Property property = (Property)element;
                if (UnusedPropertyInspection.isPropertyUsed(property, helper, isOnTheFly)) {
                    return;
                }
                ASTNode propertyNode = property.getNode();
                assert (propertyNode != null);
                ASTNode[] nodes = propertyNode.getChildren(null);
                Property key = nodes.length == 0 ? property : nodes[0].getPsi();
                LocalQuickFix fix = PropertiesQuickFixFactory.getInstance().createRemovePropertyLocalFix();
                holder.registerProblem((PsiElement)key, PropertiesBundle.message("unused.property.problem.descriptor.name", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{fix});
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    @Override
    @NotNull
    public Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> buildPropertyGroupVisitor(@NotNull ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceBundle", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "buildPropertyGroupVisitor"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)resourceBundle.getDefaultPropertiesFile().getContainingFile());
        if (module == null) {
            Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> function = x -> null;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "buildPropertyGroupVisitor"));
            }
            return function;
        }
        UnusedPropertiesSearchHelper helper = new UnusedPropertiesSearchHelper(module);
        Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> function = properties -> {
            ResourceBundleEditorProblemDescriptor[] resourceBundleEditorProblemDescriptorArray;
            if (!UnusedPropertyInspection.isPropertyUsed((Property)properties[0], helper, true)) {
                ResourceBundleEditorProblemDescriptor[] resourceBundleEditorProblemDescriptorArray2 = new ResourceBundleEditorProblemDescriptor[1];
                resourceBundleEditorProblemDescriptorArray = resourceBundleEditorProblemDescriptorArray2;
                resourceBundleEditorProblemDescriptorArray2[0] = new ResourceBundleEditorProblemDescriptor(ProblemHighlightType.LIKE_UNUSED_SYMBOL, PropertiesBundle.message("unused.property.problem.descriptor.name", new Object[0]), new RemovePropertiesFromAllLocalesFix((Property)properties[0]));
            } else {
                resourceBundleEditorProblemDescriptorArray = null;
            }
            return resourceBundleEditorProblemDescriptorArray;
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "buildPropertyGroupVisitor"));
        }
        return function;
    }

    private static boolean isPropertyUsed(@NotNull Property property, @NotNull UnusedPropertiesSearchHelper helper, boolean isOnTheFly) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "isPropertyUsed"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "isPropertyUsed"));
        }
        ProgressIndicator original = ProgressManager.getInstance().getProgressIndicator();
        if (original != null) {
            if (original.isCanceled()) {
                return true;
            }
            original.setText(PropertiesBundle.message("searching.for.property.key.progress.text", property.getUnescapedKey()));
        }
        if (ImplicitPropertyUsageProvider.isImplicitlyUsed(property)) {
            return true;
        }
        String name = property.getName();
        if (name == null) {
            return true;
        }
        if (helper.getSearcher() != null && (name = helper.getSearcher().getKeyToSearch(name, property.getProject())) == null) {
            return true;
        }
        PsiSearchHelper searchHelper = helper.getSearchHelper();
        if (UnusedPropertyInspection.mayHaveUsages((PsiElement)property, name, searchHelper, helper.getOwnUseScope(), isOnTheFly, original)) {
            return true;
        }
        GlobalSearchScope widerScope = UnusedPropertyInspection.getWidestUseScope(property.getKey(), property.getProject(), helper.getModule());
        return widerScope != null && UnusedPropertyInspection.mayHaveUsages((PsiElement)property, name, searchHelper, widerScope, isOnTheFly, original);
    }

    private static boolean mayHaveUsages(@NotNull PsiElement property, @NotNull String name, @NotNull PsiSearchHelper psiSearchHelper, @NotNull GlobalSearchScope searchScope, boolean onTheFly, @Nullable ProgressIndicator indicator) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "mayHaveUsages"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "mayHaveUsages"));
        }
        if (psiSearchHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiSearchHelper", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "mayHaveUsages"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "mayHaveUsages"));
        }
        PsiSearchHelper.SearchCostResult cheapEnough = psiSearchHelper.isCheapEnoughToSearch(name, searchScope, null, indicator);
        if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
            return false;
        }
        if (onTheFly && cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
            return true;
        }
        return ReferencesSearch.search((PsiElement)property, (SearchScope)searchScope, (boolean)false).findFirst() != null;
    }

    private static class RemovePropertiesFromAllLocalesFix
    implements QuickFix<ResourceBundleEditorProblemDescriptor> {
        private final SmartPsiElementPointer<Property> myRepresentativePointer;

        private RemovePropertiesFromAllLocalesFix(Property property) {
            this.myRepresentativePointer = SmartPointerManager.getInstance((Project)property.getProject()).createSmartPsiElementPointer((PsiElement)property);
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unused/UnusedPropertyInspection$RemovePropertiesFromAllLocalesFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PropertiesBundle.message("remove.property.intention.text", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unused/UnusedPropertyInspection$RemovePropertiesFromAllLocalesFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ResourceBundleEditorProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/unused/UnusedPropertyInspection$RemovePropertiesFromAllLocalesFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/unused/UnusedPropertyInspection$RemovePropertiesFromAllLocalesFix", "applyFix"));
            }
            Property element = (Property)this.myRepresentativePointer.getElement();
            if (element == null) {
                return;
            }
            String key = element.getKey();
            if (key == null) {
                return;
            }
            PropertiesFile file = PropertiesImplUtil.getPropertiesFile(this.myRepresentativePointer.getContainingFile());
            LOG.assertTrue(file != null);
            file.getResourceBundle().getPropertiesFiles().stream().flatMap(f -> f.findPropertiesByKey(key).stream()).filter(Objects::nonNull).map(IProperty::getPsiElement).filter(arg_0 -> ((FileModificationService)FileModificationService.getInstance()).preparePsiElementForWrite(arg_0)).forEach(PsiElement::delete);
        }
    }

    private static class UnusedPropertiesSearchHelper {
        private final GlobalSearchScope myOwnUseScope;
        private final Module myModule;
        private final PropertySearcher mySearcher;
        private final PsiSearchHelper mySearchHelper;

        UnusedPropertiesSearchHelper(Module module) {
            this.myOwnUseScope = GlobalSearchScope.moduleWithDependentsScope((Module)module);
            this.myModule = module;
            this.mySearcher = (PropertySearcher)ContainerUtil.find((Object[])Extensions.getExtensions((String)"com.intellij.referencesSearch"), (Condition)new FilteringIterator.InstanceOf(PropertySearcher.class));
            this.mySearchHelper = PsiSearchHelper.SERVICE.getInstance((Project)module.getProject());
        }

        public Module getModule() {
            return this.myModule;
        }

        GlobalSearchScope getOwnUseScope() {
            return this.myOwnUseScope;
        }

        public PropertySearcher getSearcher() {
            return this.mySearcher;
        }

        PsiSearchHelper getSearchHelper() {
            return this.mySearchHelper;
        }
    }
}

