/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.CustomResourceBundle;
import com.intellij.lang.properties.EmptyResourceBundle;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyKeyIndex;
import com.intellij.lang.properties.xml.XmlPropertiesFileImpl;
import com.intellij.lang.properties.xml.XmlPropertiesIndex;
import com.intellij.lang.properties.xml.XmlProperty;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesImplUtil
extends PropertiesUtil {
    @NotNull
    public static ResourceBundleWithCachedFiles getResourceBundleWithCachedFiles(@NotNull PropertiesFile representative) {
        if (representative == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "representative", "com/intellij/lang/properties/PropertiesImplUtil", "getResourceBundleWithCachedFiles"));
        }
        final PsiFile containingFile = representative.getContainingFile();
        if (!containingFile.isValid()) {
            ResourceBundleWithCachedFiles resourceBundleWithCachedFiles = ResourceBundleWithCachedFiles.EMPTY;
            if (resourceBundleWithCachedFiles == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesImplUtil", "getResourceBundleWithCachedFiles"));
            }
            return resourceBundleWithCachedFiles;
        }
        ResourceBundleManager manager = ResourceBundleManager.getInstance(representative.getProject());
        CustomResourceBundle customResourceBundle = manager.getCustomResourceBundle(representative);
        if (customResourceBundle != null) {
            ResourceBundleWithCachedFiles resourceBundleWithCachedFiles = new ResourceBundleWithCachedFiles(customResourceBundle, customResourceBundle.getPropertiesFiles());
            if (resourceBundleWithCachedFiles == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesImplUtil", "getResourceBundleWithCachedFiles"));
            }
            return resourceBundleWithCachedFiles;
        }
        VirtualFile virtualFile = representative.getVirtualFile();
        if (virtualFile == null) {
            ResourceBundleWithCachedFiles resourceBundleWithCachedFiles = ResourceBundleWithCachedFiles.EMPTY;
            if (resourceBundleWithCachedFiles == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesImplUtil", "getResourceBundleWithCachedFiles"));
            }
            return resourceBundleWithCachedFiles;
        }
        if (manager.isDefaultDissociated(virtualFile)) {
            ResourceBundleWithCachedFiles resourceBundleWithCachedFiles = new ResourceBundleWithCachedFiles(new ResourceBundleImpl(representative), Collections.singletonList(representative));
            if (resourceBundleWithCachedFiles == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesImplUtil", "getResourceBundleWithCachedFiles"));
            }
            return resourceBundleWithCachedFiles;
        }
        String baseName = manager.getBaseName(containingFile);
        PsiDirectory directory = (PsiDirectory)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiDirectory>(){

            @Nullable
            public PsiDirectory compute() {
                return containingFile.getContainingDirectory();
            }
        });
        if (directory == null) {
            ResourceBundleWithCachedFiles resourceBundleWithCachedFiles = ResourceBundleWithCachedFiles.EMPTY;
            if (resourceBundleWithCachedFiles == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesImplUtil", "getResourceBundleWithCachedFiles"));
            }
            return resourceBundleWithCachedFiles;
        }
        ResourceBundleWithCachedFiles bundle = PropertiesImplUtil.getResourceBundle(baseName, directory);
        ResourceBundleWithCachedFiles resourceBundleWithCachedFiles = bundle == null ? new ResourceBundleWithCachedFiles(new ResourceBundleImpl(representative), Collections.singletonList(representative)) : bundle;
        if (resourceBundleWithCachedFiles == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesImplUtil", "getResourceBundleWithCachedFiles"));
        }
        return resourceBundleWithCachedFiles;
    }

    @NotNull
    public static ResourceBundle getResourceBundle(@NotNull PropertiesFile representative) {
        if (representative == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "representative", "com/intellij/lang/properties/PropertiesImplUtil", "getResourceBundle"));
        }
        ResourceBundle resourceBundle = PropertiesImplUtil.getResourceBundleWithCachedFiles(representative).getBundle();
        if (resourceBundle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesImplUtil", "getResourceBundle"));
        }
        return resourceBundle;
    }

    @Nullable
    private static ResourceBundleWithCachedFiles getResourceBundle(@NotNull String baseName, final @NotNull PsiDirectory baseDirectory) {
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/intellij/lang/properties/PropertiesImplUtil", "getResourceBundle"));
        }
        if (baseDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDirectory", "com/intellij/lang/properties/PropertiesImplUtil", "getResourceBundle"));
        }
        PropertiesFile defaultPropertiesFile = null;
        ResourceBundleManager bundleBaseNameManager = ResourceBundleManager.getInstance(baseDirectory.getProject());
        PsiFile[] psiFiles = (PsiFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile[]>(){

            public PsiFile[] compute() {
                return baseDirectory.getFiles();
            }
        });
        ArrayList<PropertiesFile> bundleFiles = new ArrayList<PropertiesFile>(1);
        for (PsiFile psiFile : psiFiles) {
            PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(psiFile);
            if (propertiesFile == null || !baseName.equals(bundleBaseNameManager.getBaseName(psiFile))) continue;
            if (defaultPropertiesFile == null) {
                defaultPropertiesFile = propertiesFile;
            } else {
                int nameDiff = defaultPropertiesFile.getName().compareTo(propertiesFile.getName());
                if (nameDiff > 0) {
                    defaultPropertiesFile = propertiesFile;
                } else if (nameDiff == 0) {
                    return null;
                }
            }
            bundleFiles.add(propertiesFile);
        }
        if (defaultPropertiesFile == null) {
            return null;
        }
        return new ResourceBundleWithCachedFiles(new ResourceBundleImpl(defaultPropertiesFile), bundleFiles);
    }

    public static boolean isPropertiesFile(@Nullable PsiFile file) {
        return PropertiesImplUtil.getPropertiesFile(file) != null;
    }

    @Nullable
    public static PropertiesFile getPropertiesFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/properties/PropertiesImplUtil", "getPropertiesFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/properties/PropertiesImplUtil", "getPropertiesFile"));
        }
        return PropertiesImplUtil.getPropertiesFile(PsiManager.getInstance((Project)project).findFile(file));
    }

    @Nullable
    public static PropertiesFile getPropertiesFile(@Nullable PsiFile file) {
        if (!PropertiesImplUtil.canBePropertyFile(file)) {
            return null;
        }
        return file instanceof PropertiesFile ? (PropertiesFile)file : XmlPropertiesFileImpl.getPropertiesFile(file);
    }

    public static boolean canBePropertyFile(PsiFile file) {
        return file instanceof PropertiesFile || file instanceof XmlFile;
    }

    @Nullable
    public static PropertiesFile getPropertiesFile(@Nullable PsiElement element) {
        if (!(element instanceof PsiFile)) {
            return null;
        }
        return PropertiesImplUtil.getPropertiesFile((PsiFile)element);
    }

    @NotNull
    public static List<IProperty> findPropertiesByKey(final @NotNull Project project, final @NotNull String key) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/properties/PropertiesImplUtil", "findPropertiesByKey"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/properties/PropertiesImplUtil", "findPropertiesByKey"));
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        final ArrayList<IProperty> properties = new ArrayList<IProperty>(PropertyKeyIndex.getInstance().get(key, project, scope));
        final HashSet files = new HashSet();
        FileBasedIndex.getInstance().processValues(XmlPropertiesIndex.NAME, (Object)new XmlPropertiesIndex.Key(key), null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<String>(){

            public boolean process(VirtualFile file, String value) {
                PsiFile psiFile;
                PropertiesFile propertiesFile;
                if (files.add(file) && (propertiesFile = XmlPropertiesFileImpl.getPropertiesFile(psiFile = PsiManager.getInstance((Project)project).findFile(file))) != null) {
                    properties.addAll(propertiesFile.findPropertiesByKey(key));
                }
                return false;
            }
        }, scope);
        ArrayList<IProperty> arrayList = properties;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesImplUtil", "findPropertiesByKey"));
        }
        return arrayList;
    }

    @Nullable
    public static ResourceBundle createByUrl(@NotNull String url, @NotNull Project project) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/lang/properties/PropertiesImplUtil", "createByUrl"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/properties/PropertiesImplUtil", "createByUrl"));
        }
        int idx = url.lastIndexOf(47);
        if (idx == -1) {
            return null;
        }
        String baseDirectoryName = url.substring(0, idx);
        String baseName = url.substring(idx + 1);
        VirtualFile baseDirectoryVirtualFile = VirtualFileManager.getInstance().findFileByUrl(baseDirectoryName);
        if (baseDirectoryVirtualFile == null) {
            return null;
        }
        PsiDirectory baseDirectory = PsiManager.getInstance((Project)project).findDirectory(baseDirectoryVirtualFile);
        if (baseDirectory == null) {
            return null;
        }
        ResourceBundleWithCachedFiles rb = PropertiesImplUtil.getResourceBundle(baseName, baseDirectory);
        return rb == null ? null : rb.getBundle();
    }

    public static boolean isAlphaSorted(Collection<? extends IProperty> properties) {
        String previousKey = null;
        for (IProperty iProperty : properties) {
            String key = iProperty.getKey();
            if (key == null) {
                return false;
            }
            if (previousKey != null && String.CASE_INSENSITIVE_ORDER.compare(previousKey, key) > 0) {
                return false;
            }
            previousKey = key;
        }
        return true;
    }

    public static IProperty getProperty(PsiElement element) {
        PomTarget target;
        if (element instanceof IProperty) {
            return (IProperty)element;
        }
        if (element instanceof PomTargetPsiElement && (target = ((PomTargetPsiElement)element).getTarget()) instanceof XmlProperty) {
            return (IProperty)target;
        }
        return null;
    }

    public static class ResourceBundleWithCachedFiles {
        private static final ResourceBundleWithCachedFiles EMPTY = new ResourceBundleWithCachedFiles(EmptyResourceBundle.getInstance(), Collections.emptyList());
        private final ResourceBundle myBundle;
        private final List<PropertiesFile> myFiles;

        private ResourceBundleWithCachedFiles(ResourceBundle bundle, List<PropertiesFile> files) {
            this.myBundle = bundle;
            this.myFiles = files;
        }

        public ResourceBundle getBundle() {
            return this.myBundle;
        }

        public List<PropertiesFile> getFiles() {
            return this.myFiles;
        }
    }
}

