/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.actions.patterns;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.actions.generate.SpringBeanGenerateProvider;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.xml.util.XmlUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowSpringBeanGenerateProvider
extends SpringBeanGenerateProvider {
    private static final String WEBFLOW_NS_PREFIX_VARIABLE = "WEBFLOW_NS_PREFIX";

    public WebflowSpringBeanGenerateProvider(String description, @NonNls String template) {
        super(description, template);
    }

    protected Map<String, String> getPredefinedVars(@Nullable DomElement parentDomElement, @Nullable SpringBean springBean, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/spring/webflow/actions/patterns/WebflowSpringBeanGenerateProvider", "getPredefinedVars"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/webflow/actions/patterns/WebflowSpringBeanGenerateProvider", "getPredefinedVars"));
        }
        Map map = super.getPredefinedVars(parentDomElement, (DomElement)springBean, editor, file);
        return WebflowSpringBeanGenerateProvider.addWebflowNamespacePrefix(file, map);
    }

    public static Map<String, String> addWebflowNamespacePrefix(@NotNull PsiFile file, @NotNull Map<String, String> map) {
        String prefix;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/webflow/actions/patterns/WebflowSpringBeanGenerateProvider", "addWebflowNamespacePrefix"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/spring/webflow/actions/patterns/WebflowSpringBeanGenerateProvider", "addWebflowNamespacePrefix"));
        }
        if (file instanceof XmlFile && !StringUtil.isEmptyOrSpaces((String)(prefix = WebflowSpringBeanGenerateProvider.getWebflowNamespacePrefix((XmlFile)file)))) {
            map.put(WEBFLOW_NS_PREFIX_VARIABLE, prefix + ":");
        }
        return map;
    }

    @Nullable
    public static String getWebflowNamespacePrefix(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/spring/webflow/actions/patterns/WebflowSpringBeanGenerateProvider", "getWebflowNamespacePrefix"));
        }
        return XmlUtil.findNamespacePrefixByURI((XmlFile)xmlFile, (String)"http://www.springframework.org/schema/webflow-config");
    }
}

