/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.navigation;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.Identified;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.model.gotosymbol.GoToSymbolProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WebflowIdentifiedGotoSymbolProvider
extends GoToSymbolProvider {
    private static final Function<Flow, Collection<? extends Identified>> IDENTIFIED_ELEMENTS_FUNCTION = flow -> ContainerUtil.concat((List[])new List[]{flow.getActionStates(), flow.getDecisionStates(), flow.getEndStates(), flow.getInlineFlows(), flow.getSubflowStates(), flow.getViewStates()});

    protected void addNames(@NotNull Module module, Set<String> result) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/webflow/navigation/WebflowIdentifiedGotoSymbolProvider", "addNames"));
        }
        ContainerUtil.process(WebflowIdentifiedGotoSymbolProvider.getIdentifiedElements(module), identified -> {
            result.add(identified.getId().getStringValue());
            return true;
        });
    }

    protected void addItems(@NotNull Module module, String name, List<NavigationItem> result) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/webflow/navigation/WebflowIdentifiedGotoSymbolProvider", "addItems"));
        }
        ContainerUtil.process(WebflowIdentifiedGotoSymbolProvider.getIdentifiedElements(module), identified -> {
            if (Comparing.strEqual((String)name, (String)identified.getId().getStringValue())) {
                result.add(WebflowIdentifiedGotoSymbolProvider.createNavigationItem((DomElement)identified));
            }
            return true;
        });
    }

    protected boolean acceptModule(Module module) {
        return WebflowUtil.isWebFlowAvailable(module);
    }

    private static List<Identified> getIdentifiedElements(Module module) {
        List<Flow> flows = WebflowUtil.getAllFlows(module, Collections.emptyList());
        return ContainerUtil.concat(flows, IDENTIFIED_ELEMENTS_FUNCTION);
    }
}

