/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.api;

import com.yourkit.Constants;
import com.yourkit.api.ControllerImpl;
import com.yourkit.api.ProbeActivityMode;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Controller {
    public static final long CPU_SAMPLING = 4L;
    public static final long CPU_TRACING = 12L;
    public static final long MONITOR_PROFILING = 128L;
    public static final long ALLOCATION_RECORDING = 2L;
    public static final long DEADLOCK_DETECTED = 2048L;
    public static final long SNAPSHOT_WITHOUT_HEAP = 0L;
    public static final long SNAPSHOT_WITH_HEAP = 1L;
    public static final long SNAPSHOT_HPROF = 17L;
    private static final boolean _ignored = false;
    @NotNull
    private final ControllerImpl myImpl;
    private static final String CMD_PRINT_STATUS = "print-current-status";
    private static final String CMD_CAPTURE_PERFORMANCE_SNAPSHOT = "capture-performance-snapshot";
    private static final String CMD_CAPTURE_MEMORY_SNAPSHOT = "capture-memory-snapshot";
    private static final String CMD_CAPTURE_HPROF_SNAPSHOT = "capture-hprof-snapshot";
    private static final String CMD_START_CPU_SAMPLING = "start-cpu-sampling";
    private static final String CMD_START_CPU_TRACING = "start-cpu-tracing";
    private static final String OPT_ALLOC_SAMPLED = "alloc-sampled";
    private static final String CMD_STOP_CPU_PROFILING = "stop-cpu-profiling";
    private static final String CMD_CLEAR_CPU_DATA = "clear-cpu-data";
    private static final String CMD_START_ALLOC_ALL = "start-alloc-recording-all";
    private static final String CMD_START_ALLOC_ADAPTIVE = "start-alloc-recording-adaptive";
    private static final String CMD_STOP_ALLOC = "stop-alloc-recording";
    private static final String CMD_CLEAR_ALLOC_DATA = "clear-alloc-data";
    private static final String CMD_START_MONITOR_PROFILING = "start-monitor-profiling";
    private static final String CMD_STOP_MONITOR_PROFILING = "stop-monitor-profiling";
    private static final String CMD_CLEAR_MONITOR_DATA = "clear-monitor-data";

    public Controller() throws Exception {
        this("localhost", Controller.getUsedPort());
    }

    public Controller(String host, int port) throws Exception {
        this.myImpl = new ControllerImpl(host, port);
    }

    @NotNull
    public String getSessionName() {
        String string = this.myImpl.getSessionName();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public String getHost() {
        return this.myImpl.getHost();
    }

    public int getPort() {
        return this.myImpl.getPort();
    }

    static int getUsedPort() throws Exception {
        int port = -1;
        try {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            Class<?> aClass = loader.loadClass("com.yourkit.runtime.Core");
            Field field = aClass.getDeclaredField("ourPort");
            port = (Integer)field.get(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (port == -1) {
            throw new Exception("To profile application, you should run it with the profiler agent");
        }
        return port;
    }

    public String captureSnapshot(long snapshotFlags) throws Exception {
        if (snapshotFlags != 0L && snapshotFlags != 1L && snapshotFlags != 17L) {
            throw new IllegalArgumentException("illegal snapshotFlags value " + snapshotFlags + "; use one of the " + this.getClass().getName() + ".SNAPSHOT_xxx constants");
        }
        return this.myImpl.captureSnapshot(snapshotFlags, null, null, null);
    }

    public String captureMemorySnapshot() throws Exception {
        return this.captureSnapshot(1L);
    }

    public String capturePerformanceSnapshot() throws Exception {
        return this.captureSnapshot(0L);
    }

    public void startAllocationRecording(boolean recordEachEnabled, int recordEach, boolean sizeLimitEnabled, int sizeLimit, boolean unused, boolean sampledAllocationRecording) throws Exception {
        this.myImpl.startAllocationRecording(recordEachEnabled, recordEach, sizeLimitEnabled, sizeLimit, sampledAllocationRecording);
    }

    public void stopAllocationRecording() throws Exception {
        this.myImpl.stopAllocationRecording();
    }

    public void clearAllocationData() throws Exception {
        this.myImpl.clearAllocationData();
    }

    public void startCPUSampling(@Nullable String settings) throws Exception {
        this.myImpl.startCPUProfiling(4L, settings);
    }

    public void startCPUTracing(@Nullable String settings) throws Exception {
        this.myImpl.startCPUProfiling(12L, settings);
    }

    public void stopCPUProfiling() throws Exception {
        this.myImpl.stopCPUProfiling();
    }

    public void clearCPUData() throws Exception {
        this.myImpl.clearCPUData();
    }

    public void startMonitorProfiling() throws Exception {
        this.myImpl.startMonitorProfiling();
    }

    public void stopMonitorProfiling() throws Exception {
        this.myImpl.stopMonitorProfiling();
    }

    public void clearMonitorData() throws Exception {
        this.myImpl.clearMonitorData();
    }

    public void enableStackTelemetry() throws Exception {
        this.myImpl.enableStackTelemetry();
    }

    public void disableStackTelemetry() throws Exception {
        this.myImpl.disableStackTelemetry();
    }

    public void enableExceptionTelemetry() throws Exception {
        this.myImpl.enableExceptionTelemetry();
    }

    public void disableExceptionTelemetry() throws Exception {
        this.myImpl.disableExceptionTelemetry();
    }

    public void clearExceptions() throws Exception {
        this.myImpl.clearExceptions();
    }

    public void clearUserTables(String ... tableNames) {
        if (tableNames == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.clearEventTables(tableNames);
    }

    public void clearEventTables(String ... tableNames) {
        if (tableNames == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myImpl.clearEventTables(tableNames);
    }

    public void clearProbeTables(String ... tableNames) {
        if (tableNames == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.clearEventTables(tableNames);
    }

    public void advanceGeneration(@Nullable String description) throws Exception {
        this.myImpl.advanceGeneration(description == null ? "" : description);
    }

    public long[] forceGC() throws Exception {
        return this.myImpl.forceGC();
    }

    public long getStatus() throws Exception {
        return this.myImpl.getStatus();
    }

    public void setTriggers(String triggersDescription, boolean append) throws Exception {
        this.myImpl.setTriggers(triggersDescription, append);
    }

    public String getTriggers() throws Exception {
        return this.myImpl.getTriggers();
    }

    @NotNull
    public HashMap<String, ProbeActivityMode> getProbeActivityModes() {
        HashMap<String, ProbeActivityMode> hashMap = this.myImpl.getProbes();
        if (hashMap == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return hashMap;
    }

    public void setProbeActivityModes(@NotNull HashMap<String, ProbeActivityMode> probeClassName2mode) {
        if (probeClassName2mode == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myImpl.setProbes(probeClassName2mode);
    }

    private static void printHelp() {
        System.out.println(Constants.APP_FULL_NAME + " command line tools\n" + "\n" + "Usage: java -jar yjp-controller-api-redist.jar <host> <port> <command>\n" + "\n" + "where <command> is one of:\n" + "\n" + CMD_PRINT_STATUS + "\n" + CMD_CAPTURE_MEMORY_SNAPSHOT + "\n" + CMD_CAPTURE_HPROF_SNAPSHOT + "\n" + CMD_CAPTURE_PERFORMANCE_SNAPSHOT + "\n" + CMD_START_CPU_SAMPLING + "\n" + CMD_START_CPU_TRACING + "\n" + CMD_STOP_CPU_PROFILING + "\n" + CMD_CLEAR_CPU_DATA + "\n" + CMD_START_ALLOC_ALL + "\n" + "  // record each allocation\n" + CMD_START_ALLOC_ADAPTIVE + " [" + OPT_ALLOC_SAMPLED + "] \n" + " // record each 10th allocation, and all objects with size > 1M\n" + CMD_STOP_ALLOC + "\n" + CMD_CLEAR_ALLOC_DATA + "\n" + CMD_START_MONITOR_PROFILING + "\n" + CMD_STOP_MONITOR_PROFILING + "\n" + CMD_CLEAR_MONITOR_DATA + "\n" + "\n" + "Examples:\n" + "java -jar yjp-controller-api-redist.jar localhost 10001 " + CMD_CAPTURE_MEMORY_SNAPSHOT + "\n" + "java -jar yjp-controller-api-redist.jar localhost 10001 " + CMD_START_CPU_SAMPLING + "\n");
    }

    public static void main(@NotNull String[] args) throws Exception {
        String path;
        int port;
        if (args == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (args.length < 3) {
            Controller.printHelp();
            return;
        }
        String host = args[0];
        String portStr = args[1];
        String command = args[2].toLowerCase();
        try {
            port = Integer.parseInt(portStr);
        }
        catch (Exception ignored) {
            System.out.println("Error: invalid port number specified: " + portStr);
            Controller.printHelp();
            return;
        }
        boolean allocSampled = false;
        for (int i = 3; i < args.length; ++i) {
            String option = args[i];
            if (!CMD_START_ALLOC_ALL.equals(command) && !CMD_START_ALLOC_ADAPTIVE.equals(command) || !OPT_ALLOC_SAMPLED.equals(option)) {
                Controller.printHelp();
                return;
            }
            allocSampled = true;
        }
        if (CMD_CAPTURE_MEMORY_SNAPSHOT.equals(command)) {
            Controller controller = new Controller(host, port);
            path = controller.captureSnapshot(1L);
            System.out.println("Snapshot captured: " + path);
            return;
        }
        if (CMD_CAPTURE_HPROF_SNAPSHOT.equals(command)) {
            Controller controller = new Controller(host, port);
            path = controller.captureSnapshot(17L);
            System.out.println("Snapshot captured: " + path);
            return;
        }
        if (CMD_CAPTURE_PERFORMANCE_SNAPSHOT.equals(command)) {
            Controller controller = new Controller(host, port);
            path = controller.captureSnapshot(0L);
            System.out.println("Snapshot captured: " + path);
            return;
        }
        if (CMD_START_CPU_SAMPLING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startCPUSampling(null);
            System.out.println("CPU sampling started");
            return;
        }
        if (CMD_START_CPU_TRACING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startCPUTracing(null);
            System.out.println("CPU tracing started");
            return;
        }
        if (CMD_STOP_CPU_PROFILING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.stopCPUProfiling();
            System.out.println("CPU profiling stopped");
            return;
        }
        if (CMD_CLEAR_CPU_DATA.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.clearCPUData();
            System.out.println("CPU profiling data cleared");
            return;
        }
        if (CMD_START_ALLOC_ALL.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startAllocationRecording(true, 1, false, 0, false, allocSampled);
            System.out.println("Allocation recording started");
            return;
        }
        if (CMD_START_ALLOC_ADAPTIVE.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startAllocationRecording(true, 10, true, 0x100000, false, allocSampled);
            System.out.println("Allocation recording started");
            return;
        }
        if (CMD_STOP_ALLOC.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.stopAllocationRecording();
            System.out.println("Allocation recording stopped");
            return;
        }
        if (CMD_CLEAR_ALLOC_DATA.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.clearAllocationData();
            System.out.println("Allocation data cleared");
            return;
        }
        if (CMD_START_MONITOR_PROFILING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startMonitorProfiling();
            System.out.println("Monitor profiling started");
            return;
        }
        if (CMD_STOP_MONITOR_PROFILING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.stopMonitorProfiling();
            System.out.println("Monitor profiling stopped");
            return;
        }
        if (CMD_CLEAR_MONITOR_DATA.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.clearMonitorData();
            System.out.println("Monitor data cleared");
            return;
        }
        if (CMD_PRINT_STATUS.equals(command)) {
            Controller controller = new Controller(host, port);
            long status = controller.getStatus();
            if ((status & 2L) != 0L) {
                System.out.println("Allocation recording is on");
            } else {
                System.out.println("Allocation recording is off");
            }
            if ((status & 0xCL) == 12L) {
                System.out.println("CPU profiling is on (tracing)");
            } else if ((status & 4L) != 0L) {
                System.out.println("CPU profiling is on (sampling)");
            } else {
                System.out.println("CPU profiling is off");
            }
            if ((status & 0x80L) != 0L) {
                System.out.println("Monitor profiling is on");
            } else {
                System.out.println("Monitor profiling is off");
            }
            return;
        }
        Controller.printHelp();
    }
}

