/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.runtime;

import com.yourkit.Constants;
import com.yourkit.runtime.PresentableException;
import com.yourkit.util.FileUtil;
import com.yourkit.util.Strings;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public final class Agent {
    public static final long CAPABILITY_ATTACHED_AGENT = 1024L;
    public static final long CAPABILITY_EXCEPTION_EVENTS_NOT_AVAILABLE = 16384L;
    private static final boolean USE_PARENTHESES = Constants.OS_WINDOWS;
    @NotNull
    public static final String[] SNAPSHOT_NAME_MACROS = new String[]{"{date}", "{datetime}", "{pid}"};
    @NotNull
    public static final String DEFAULT_SNAPSHOT_NAME_FORMAT = "{sessionname}-{date}";

    private static String getDateForSnapshotFileName() {
        return new SimpleDateFormat("yyyy-MM-dd", Locale.US).format(new Date());
    }

    private static String getDateTimeForSnapshotFileName() {
        return new SimpleDateFormat("yyyy-MM-dd-HH-mm", Locale.US).format(new Date());
    }

    private static String expandSnapshotNameMacros(@NotNull String nameWithMacros, @NotNull String sessionName, int pid) {
        if (nameWithMacros == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (sessionName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String name = Strings.notEmpty(nameWithMacros, DEFAULT_SNAPSHOT_NAME_FORMAT);
        name = Strings.replace(name, "{sessionname}", Agent.sessionNameToFileNamePart(sessionName));
        name = Strings.replace(name, "{date}", Agent.getDateForSnapshotFileName());
        name = Strings.replace(name, "{datetime}", Agent.getDateTimeForSnapshotFileName());
        name = Strings.replace(name, "{pid}", Integer.toString(pid));
        return Agent.sessionNameToFileNamePart(name);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String getFileName(String fileNamePrefix, int index, String fileExtension) {
        String string;
        if (index == 0) {
            string = fileNamePrefix + fileExtension;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        if (USE_PARENTHESES) {
            string = fileNamePrefix + "(" + index + ")" + fileExtension;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = fileNamePrefix + "-" + index + fileExtension;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static File suggestSnapshotFile(@NotNull String snapshotNameFormat, @NotNull File directory, @NotNull String sessionName, int pid, @NotNull String fileExtension) {
        File file;
        int len$;
        File[] arr$;
        String nameWithoutNumber;
        String end;
        String start;
        int maxFound;
        if (snapshotNameFormat == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (directory == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (sessionName == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        if (fileExtension == null) {
            throw new IllegalArgumentException("Parameter 5 must not be null");
        }
        if (!directory.isDirectory()) {
            throw new PresentableException("Bad directory: " + FileUtil.normalize(directory) + "\n" + "\n" + "Please check 'Settings | Snapshot Directory...'");
        }
        String fileNameExpanded = Agent.expandSnapshotNameMacros(snapshotNameFormat, sessionName, pid);
        File[] files = directory.listFiles();
        if (files != null) {
            maxFound = -1;
            start = USE_PARENTHESES ? fileNameExpanded + "(" : fileNameExpanded + "-";
            end = USE_PARENTHESES ? ")" + fileExtension : fileExtension;
            nameWithoutNumber = Agent.getFileName(fileNameExpanded, 0, fileExtension);
            arr$ = files;
            len$ = arr$.length;
        } else {
            int index = 0;
            while (true) {
                File result;
                if (!(result = new File(directory, Agent.getFileName(fileNameExpanded, index, fileExtension))).exists()) {
                    file = result;
                    if (file == null) throw new IllegalStateException("Method must not return null");
                    return file;
                }
                ++index;
            }
        }
        for (int i$ = 0; i$ < len$; ++i$) {
            File file2 = arr$[i$];
            String name = file2.getName();
            if (name.equals(nameWithoutNumber)) {
                maxFound = Math.max(maxFound, 0);
                continue;
            }
            if (!name.startsWith(start) || !name.endsWith(end)) continue;
            String numberStr = name.substring(start.length(), name.length() - end.length());
            try {
                int value = Integer.parseInt(numberStr);
                maxFound = Math.max(value, maxFound);
                continue;
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        file = new File(directory, Agent.getFileName(fileNameExpanded, maxFound + 1, fileExtension));
        if (file != null) return file;
        throw new IllegalStateException("Method must not return null");
    }

    public static String sessionNameToFileNamePart(@NotNull String sessionName) {
        if (sessionName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String forbiddenChars = "\\/<>|\":?*";
        StringBuilder result = new StringBuilder(sessionName.length());
        for (int i = 0; i < sessionName.length(); ++i) {
            char ch = sessionName.charAt(i);
            if (ch >= ' ' && "\\/<>|\":?*".indexOf(ch) == -1) {
                result.append(ch);
                continue;
            }
            result.append('-');
        }
        return result.toString();
    }

    @NotNull
    public static byte[][] getBytecode(@NotNull Class[] classes) {
        if (classes == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (Class aClass : classes) {
            Agent.addBytecode(result, new Class[]{aClass});
            result.add(null);
        }
        byte[][] byArray = (byte[][])result.toArray((T[])new byte[result.size()][]);
        if (byArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return byArray;
    }

    private static void addBytecode(@NotNull ArrayList<byte[]> result, @NotNull Class[] classes) {
        if (result == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (classes == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        for (Class aClass : classes) {
            result.add(Agent.getClassBytes(aClass));
            Agent.addBytecode(result, aClass.getDeclaredClasses());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static byte[] getClassBytes(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        ByteArray byteArray = new ByteArray(1024);
        try {
            InputStream stream = aClass.getResourceAsStream("/" + aClass.getName().replace('.', '/') + ".class");
            try {
                int ch;
                while ((ch = stream.read()) != -1) {
                    byteArray.add((byte)ch);
                }
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] byArray = byteArray.getBytes();
        if (byArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return byArray;
    }

    public static boolean isValidJavaIdentifier(String str) {
        if (str.isEmpty() || str.startsWith(".") || str.endsWith(".") || str.contains("..")) {
            return false;
        }
        for (String token : str.split("\\.")) {
            if (!Character.isJavaIdentifierStart(token.charAt(0))) {
                return false;
            }
            for (int i = 1; i < token.length(); ++i) {
                if (Character.isJavaIdentifierPart(token.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static String validateJavaTypeOrEmpty(String str, boolean addTypeToErrorMessage) {
        if (str.isEmpty()) {
            return null;
        }
        if (Agent.isValidJavaIdentifier(str)) {
            return null;
        }
        return "Invalid class or interface name" + (addTypeToErrorMessage ? " '" + str + "'" : "");
    }

    private static final class ByteArray {
        private byte[] myBytes;
        private int mySize;

        public ByteArray(int initialCapacity) {
            this.myBytes = new byte[initialCapacity];
        }

        public void add(byte aByte) {
            if (this.mySize == this.myBytes.length) {
                int newCapacity = this.myBytes.length * 2;
                byte[] newBytes = new byte[newCapacity];
                System.arraycopy(this.myBytes, 0, newBytes, 0, this.mySize);
                this.myBytes = newBytes;
            }
            this.myBytes[this.mySize++] = aByte;
        }

        @NotNull
        public byte[] getBytes() {
            byte[] result = new byte[this.mySize];
            System.arraycopy(this.myBytes, 0, result, 0, this.mySize);
            if (result == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return result;
        }
    }
}

