/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<JSArgumentList, JSFunctionWithSubstitutor, JSExpression> {
    private static final Set<Class> ourArgumentListAllowedParentClassesSet = new HashSet<Class>(Arrays.asList(JSCallExpression.class));
    private static final Set<? extends Class> ourStopSearch = Collections.singleton(JSFunction.class);

    public boolean couldShowInLookup() {
        return true;
    }

    @NotNull
    public Set<? extends Class> getArgListStopSearchClasses() {
        Set<? extends Class> set = ourStopSearch;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getArgListStopSearchClasses"));
        }
        return set;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        if (!(item instanceof MutableLookupElement)) {
            return null;
        }
        Object o = item.getObject();
        if (o instanceof JSFunctionItem) {
            LinkedHashMap<String, JSFunctionWithSubstitutor> typedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>();
            LinkedHashMap<String, JSFunctionWithSubstitutor> untypedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>();
            HashSet untypedKeysForTypedSignatures = ContainerUtil.newHashSet();
            if (o instanceof JSFunction) {
                for (PsiElement el : DefinitionsScopedSearch.search((PsiElement)((JSFunction)o))) {
                    if (!(el instanceof JSFunction)) continue;
                    JSParameterInfoHandler.doAddSignature(typedSignatures, untypedSignatures, untypedKeysForTypedSignatures, (JSFunctionItem)((JSFunction)el), null);
                }
            }
            ArrayList<JSFunctionWithSubstitutor> result = new ArrayList<JSFunctionWithSubstitutor>(typedSignatures.size() + 1);
            result.add(new JSFunctionWithSubstitutor((JSFunctionItem)o, null));
            ContainerUtil.addAll(result, typedSignatures.values());
            return ArrayUtil.toObjectArray(result);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static void doAddSignature(@NotNull Map<String, JSFunctionWithSubstitutor> typedSignatures, @NotNull Map<String, JSFunctionWithSubstitutor> untypedSignatures, @NotNull Set<String> untypedKeysForTypedSignatures, @NotNull JSFunctionItem functionItem, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (typedSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typedSignatures", "com/intellij/javascript/JSParameterInfoHandler", "doAddSignature"));
        }
        if (untypedSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "untypedSignatures", "com/intellij/javascript/JSParameterInfoHandler", "doAddSignature"));
        }
        if (untypedKeysForTypedSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "untypedKeysForTypedSignatures", "com/intellij/javascript/JSParameterInfoHandler", "doAddSignature"));
        }
        if (functionItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionItem", "com/intellij/javascript/JSParameterInfoHandler", "doAddSignature"));
        }
        String typedSignature = JSParameterInfoHandler.buildSignature((JSFunctionItem)functionItem, (boolean)false, (int)-1, (JSTypeSubstitutor)typeSubstitutor).text;
        String untypedSignature = JSParameterInfoHandler.buildSignature((JSFunctionItem)functionItem, (boolean)true, (int)-1, (JSTypeSubstitutor)typeSubstitutor).text;
        if (typedSignature.equals(untypedSignature)) {
            if (!untypedSignatures.containsKey(untypedSignature)) {
                untypedSignatures.put(untypedSignature, new JSFunctionWithSubstitutor(functionItem, typeSubstitutor));
            }
        } else if (!typedSignatures.containsKey(typedSignature)) {
            typedSignatures.put(typedSignature, new JSFunctionWithSubstitutor(functionItem, typeSubstitutor));
            untypedKeysForTypedSignatures.add(untypedSignature);
        }
    }

    public Object[] getParametersForDocumentation(JSFunctionWithSubstitutor p, ParameterInfoContext context) {
        return p.myFunctionItem.getParameters();
    }

    public JSArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "findElementForParameterInfo"));
        }
        JSArgumentList argList = JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset());
        if (argList != null) {
            if (this.skipTypeScript() && DialectDetector.isTypeScript((PsiElement)argList)) {
                return null;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return this.fillSignaturesForArgumentList(context, argList);
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "lambda$findElementForParameterInfo$2"));
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "lambda$null$1"));
                    }
                    JSArgumentList argListOrNull = this.fillSignaturesForArgumentList(context, argList);
                    if (argListOrNull != null) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (context == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "lambda$null$0"));
                            }
                            this.showParameterInfo(argListOrNull, context);
                        });
                    }
                });
            });
        }
        return argList;
    }

    @Nullable
    public static JSArgumentList findArgumentList(PsiFile file, int offset) {
        JSCallExpression callExpression;
        JSArgumentList argList = (JSArgumentList)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file, (int)offset, JSArgumentList.class, (Class[])new Class[]{JSStatement.class, JSFunctionExpression.class});
        if (argList == null && (callExpression = (JSCallExpression)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file, (int)offset, JSCallExpression.class, (Class[])new Class[]{JSStatement.class})) != null) {
            argList = callExpression.getArgumentList();
        }
        return argList;
    }

    @Nullable
    protected JSArgumentList fillSignaturesForArgumentList(CreateParameterInfoContext context, @NotNull JSArgumentList argList) {
        if (argList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argList", "com/intellij/javascript/JSParameterInfoHandler", "fillSignaturesForArgumentList"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiElement psiElement = argList.getParent();
        if (!(psiElement instanceof JSCallExpression)) {
            return null;
        }
        JSCallExpression parent = (JSCallExpression)psiElement;
        JSExpression methodExpression = JSUtils.unparenthesize(parent.getMethodExpression());
        if (methodExpression instanceof JSReferenceExpression) {
            JSNamespace namespace;
            JSType qualifierType;
            JSType resolveResults = ((JSReferenceExpression)methodExpression).multiResolve(true);
            if (((ResolveResult[])resolveResults).length <= 0) {
                return null;
            }
            LinkedHashMap<String, JSFunctionWithSubstitutor> typedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>(((ResolveResult[])resolveResults).length);
            LinkedHashMap<String, JSFunctionWithSubstitutor> untypedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>();
            HashSet untypedKeysForTypedSignatures = ContainerUtil.newHashSet();
            JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
            JSTypeSubstitutor typeSubstitutor = null;
            if (qualifier != null && (qualifierType = JSResolveUtil.getExpressionJSType(qualifier)) != null && (namespace = JSTypeUtils.getNamespaceMatchingType(qualifierType, true, false)) != null) {
                typeSubstitutor = (JSTypeSubstitutor)namespace.getUserData(JSNamespace.GENERIC_ARGUMENTS_KEY);
            }
            for (JSType r : resolveResults) {
                PsiElement element = r.getElement();
                if (element == null) continue;
                JSFunctionItem functionItem = JSPsiImplUtils.calculatePossibleFunctionCarefully(element, (PsiElement)methodExpression);
                if (functionItem == null) {
                    JSType functionType;
                    JSType jsType = JSTypeUtils.getTypeOfElement(element);
                    if ((jsType = JSTypeUtils.getValuableType(jsType)) != null && (functionType = (JSType)ContainerUtil.getFirstItem(JSTypeUtils.getFunctionType(jsType, parent instanceof JSNewExpression))) != null) {
                        PsiElement sourceElement = jsType.getSource().getSourceElement();
                        if (sourceElement instanceof JSFunctionItem) {
                            functionItem = (JSFunctionItem)sourceElement;
                        } else {
                            PsiElement functionSourceElement;
                            DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
                            if (holder != null && !holder.isECMA4 && (functionSourceElement = functionType.getSource().getSourceElement()) instanceof JSFunctionItem) {
                                functionItem = (JSFunctionItem)functionSourceElement;
                            }
                        }
                    }
                }
                if (functionItem == null) continue;
                JSParameterInfoHandler.doAddSignature(typedSignatures, untypedSignatures, untypedKeysForTypedSignatures, functionItem, typeSubstitutor);
            }
            ArrayList result = new ArrayList(typedSignatures.size() + untypedSignatures.size());
            ContainerUtil.addAll(result, typedSignatures.values());
            for (Map.Entry entry : untypedSignatures.entrySet()) {
                if (untypedKeysForTypedSignatures.contains(entry.getKey())) continue;
                result.add(entry.getValue());
            }
            context.setItemsToShow(ArrayUtil.toObjectArray(result));
            return argList;
        }
        if (methodExpression instanceof JSSuperExpression) {
            PsiElement clazz = methodExpression.getReference().resolve();
            if (clazz instanceof JSFunction) {
                context.setItemsToShow(new Object[]{new JSFunctionWithSubstitutor((JSFunctionItem)((JSFunction)clazz), null)});
                return argList;
            }
        } else if (methodExpression instanceof JSFunctionExpression) {
            context.setItemsToShow(new Object[]{new JSFunctionWithSubstitutor((JSFunctionItem)((JSFunctionExpression)methodExpression), null)});
            return argList;
        }
        return null;
    }

    public void showParameterInfo(@NotNull JSArgumentList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/JSParameterInfoHandler", "showParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "showParameterInfo"));
        }
        context.showHint((PsiElement)element, element.getTextOffset(), (ParameterInfoHandler)this);
    }

    public JSArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        return JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset());
    }

    public void updateParameterInfo(@NotNull JSArgumentList parameterOwner, @NotNull UpdateParameterInfoContext context) {
        if (parameterOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterOwner", "com/intellij/javascript/JSParameterInfoHandler", "updateParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "updateParameterInfo"));
        }
        if (context.getParameterOwner() != parameterOwner) {
            context.removeHint();
            return;
        }
        int currentParameterIndex = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)parameterOwner.getNode(), (int)context.getOffset(), (IElementType)JSTokenTypes.COMMA);
        context.setCurrentParameter(currentParameterIndex);
    }

    @NotNull
    public String getParameterCloseChars() {
        if (",){" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getParameterCloseChars"));
        }
        return ",){";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    public void updateUI(JSFunctionWithSubstitutor pair, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "updateUI"));
        }
        JSFunctionItem p = pair.myFunctionItem;
        if (!(p instanceof JSImplicitFunctionImpl) && !p.isValid()) {
            return;
        }
        JSParameterItem[] params = p.getParameters();
        int currentParameterIndex = context.getCurrentParameterIndex() >= 0 ? context.getCurrentParameterIndex() : params.length;
        JSParameterItem parameter = currentParameterIndex < params.length ? params[currentParameterIndex] : null;
        SignatureInfo signatureInfo = JSParameterInfoHandler.buildSignature(p, false, currentParameterIndex, pair.myTypeSubstitutor);
        String name = signatureInfo.text;
        String currentParameterSignature = parameter != null ? JSParameterInfoHandler.getSignatureForParameter(parameter, pair.myTypeSubstitutor) : null;
        int highlightStart = parameter != null ? signatureInfo.selectedParameterStart : 0;
        int highlightEnd = parameter != null ? highlightStart + currentParameterSignature.length() : 0;
        context.setupUIComponentPresentation(name, highlightStart, highlightEnd, false, false, false, context.getDefaultParameterColor());
    }

    @NotNull
    private static SignatureInfo buildSignature(@NotNull JSFunctionItem function, boolean skipType, int selectedParameterIndex, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/javascript/JSParameterInfoHandler", "buildSignature"));
        }
        JSParameterItem[] params = function.getParameters();
        SignatureInfo info = new SignatureInfo();
        if (params.length > 0) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < params.length; ++i) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                if (selectedParameterIndex == i) {
                    info.selectedParameterStart = result.toString().length();
                }
                result.append(JSParameterInfoHandler.getSignatureForParameter(params[i], skipType, typeSubstitutor));
            }
            if (function.isReferencesArguments()) {
                result.append(", ...");
            }
            info.text = result.toString();
        } else {
            String signature = function.isReferencesArguments() ? "..." : CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]);
            info.text = signature;
        }
        SignatureInfo signatureInfo = info;
        if (signatureInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "buildSignature"));
        }
        return signatureInfo;
    }

    private static String getSignatureForParameter(JSParameterItem p, boolean skipType, @Nullable JSTypeSubstitutor typeSubstitutor) {
        JSParameterTypeDecorator decorator = p.getTypeDecorator();
        JSType type = p.getTypeIncludingOverridden();
        if (type != null) {
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)typeSubstitutor);
        }
        String initializerText = p instanceof JSParameter ? ((JSParameter)p).getLiteralOrReferenceInitializerText() : null;
        DialectOptionHolder holder = p instanceof PsiElement ? DialectDetector.dialectOfElement((PsiElement)p) : null;
        if (!(skipType |= p instanceof JSDestructuringParameter && ((JSDestructuringParameter)p).getTypeElement() == null) && type != null) {
            boolean needOptional;
            String s = type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            boolean isActionScript = holder != null && holder.isECMA4;
            boolean isTypeScript = holder != null && holder.isTypeScript;
            boolean useColonTypeNotation = isTypeScript || isActionScript;
            StringBuilder result = new StringBuilder();
            boolean bl = needOptional = p.isOptional() && initializerText == null;
            if (useColonTypeNotation) {
                if (p.isRest()) {
                    result.append("... ");
                    result.append(p.getName());
                } else {
                    result.append(p.getName());
                    if (needOptional) {
                        result.append('?');
                    }
                }
                result.append(":");
                if (isTypeScript) {
                    result.append(" ");
                }
                result.append(JSLookupUtilImpl.getShortName(s));
            } else {
                result.append("[");
                if (p.isRest()) {
                    result.append("...");
                }
                result.append(s);
                if (needOptional) {
                    result.append(", optional");
                }
                result.append("] ").append(p.getName());
            }
            if (initializerText != null) {
                result.append(" = ");
                result.append(initializerText);
            }
            return result.toString();
        }
        String res = p.getName();
        if (p.isRest()) {
            res = "... " + res;
        }
        if (p.isOptional() && decorator.isExplicitlyDeclared()) {
            res = "[optional] " + res;
        }
        if (initializerText != null) {
            res = res + " = " + initializerText;
        }
        return res;
    }

    public static String getSignatureForParameter(JSParameterItem p) {
        return JSParameterInfoHandler.getSignatureForParameter(p, null);
    }

    public static String getSignatureForParameter(JSParameterItem p, @Nullable JSTypeSubstitutor typeSubstitutor) {
        return JSParameterInfoHandler.getSignatureForParameter(p, false, typeSubstitutor);
    }

    @NotNull
    public JSExpression[] getActualParameters(@NotNull JSArgumentList jsArgumentList) {
        if (jsArgumentList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsArgumentList", "com/intellij/javascript/JSParameterInfoHandler", "getActualParameters"));
        }
        JSExpression[] jSExpressionArray = jsArgumentList.getArguments();
        if (jSExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getActualParameters"));
        }
        return jSExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = JSTokenTypes.COMMA;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getActualParameterDelimiterType"));
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = JSTokenTypes.RBRACE;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getActualParametersRBraceType"));
        }
        return iElementType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set = ourArgumentListAllowedParentClassesSet;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getArgumentListAllowedParentClasses"));
        }
        return set;
    }

    @NotNull
    public Class<JSArgumentList> getArgumentListClass() {
        if (JSArgumentList.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getArgumentListClass"));
        }
        return JSArgumentList.class;
    }

    protected boolean skipTypeScript() {
        return true;
    }

    private static class SignatureInfo {
        String text;
        int selectedParameterStart = -1;

        private SignatureInfo() {
        }
    }
}

