/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.NodeModulesLibraryProvider;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class NodeModulesDirectoryIconProvider
extends IconProvider
implements DumbAware {
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryIconProvider", "getIcon"));
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory psiDirectory = (PsiDirectory)element;
            return NodeModulesDirectoryIconProvider.getDirectoryIcon(psiDirectory.getVirtualFile(), psiDirectory.getProject());
        }
        return null;
    }

    public static Icon getDirectoryIcon(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryIconProvider", "getDirectoryIcon"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryIconProvider", "getDirectoryIcon"));
        }
        SourceFolder sourceFolder = ProjectRootsUtil.getModuleSourceRoot((VirtualFile)file, (Project)project);
        if (sourceFolder != null) {
            return null;
        }
        boolean excluded = ProjectFileIndex.SERVICE.getInstance((Project)project).isExcluded(file);
        if (excluded && !NodeModulesDirectoryIconProvider.hasLibraryFilesInside(project, file)) {
            return AllIcons.Modules.ExcludeRoot;
        }
        return PlatformIcons.DIRECTORY_CLOSED_ICON;
    }

    private static boolean hasLibraryFilesInside(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile dir;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryIconProvider", "hasLibraryFilesInside"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryIconProvider", "hasLibraryFilesInside"));
        }
        VirtualFile nodeModulesDir = null;
        VirtualFile packageRootDir = null;
        VirtualFile dirInsidePackage = null;
        for (dir = file; dir != null; dir = dir.getParent()) {
            dirInsidePackage = packageRootDir;
            packageRootDir = nodeModulesDir;
            nodeModulesDir = dir;
            if (NodeModulesDirectoryManager.isNodeModulesDir(dir)) break;
        }
        if (dir == null) {
            return false;
        }
        NodeModulesDirectoryManager manager = NodeModulesDirectoryManager.getInstance(project);
        if (manager.isLibraryWithMappings(nodeModulesDir)) {
            if (packageRootDir == null) {
                return true;
            }
            VirtualFile packageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir);
            if (packageJson == null) {
                return false;
            }
            PackageJsonData data = PackageJsonUtil.getOrCreateData(packageJson);
            if (data.getAllDependencies().contains(packageRootDir.getName()) && (dirInsidePackage == null || NodeModulesLibraryProvider.isDependencyChildIncluded(dirInsidePackage))) {
                return true;
            }
        }
        return false;
    }
}

